/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import java.util.Arrays;

public class ResolutionNode
extends ProofNode {
    private final Clause mPrimary;
    private final Antecedent[] mAntecedents;

    public ResolutionNode(Clause primary, Antecedent[] antecedents) {
        assert (primary != null);
        this.mPrimary = primary;
        this.mAntecedents = antecedents;
    }

    public boolean isLeaf() {
        return false;
    }

    public Clause getPrimary() {
        return this.mPrimary;
    }

    public Antecedent[] getAntecedents() {
        return this.mAntecedents;
    }

    public String toString() {
        return this.mPrimary + " => " + Arrays.toString(this.mAntecedents);
    }

    public static class Antecedent {
        public final Literal mPivot;
        public final Clause mAntecedent;

        public Antecedent(Literal pivot, Clause antecedent) {
            assert (pivot != null);
            assert (antecedent != null);
            assert (antecedent.contains(pivot));
            this.mPivot = pivot;
            this.mAntecedent = antecedent;
        }

        public String toString() {
            return this.mPivot.toString() + " => " + this.mAntecedent;
        }
    }
}

