/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.FixProofDAG;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.OccurrenceCounter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.RecyclePivots;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.UnitCollector;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class Transformations {
    private Transformations() {
    }

    public static Clause lowerUnits(Clause proof) {
        assert (proof.getSize() == 0);
        OccurrenceCounter occ = new OccurrenceCounter();
        Map<Clause, Integer> counts = occ.count(proof);
        occ = null;
        UnitCollector uc = new UnitCollector();
        Queue<ResolutionNode.Antecedent> units = uc.collectUnits(proof, counts);
        Map<Clause, Set<Literal>> deletedNodes = uc.getDeletedNodes();
        uc = null;
        FixProofDAG fix = new FixProofDAG();
        Clause tmpproof = fix.fix(proof, deletedNodes);
        ArrayDeque<ResolutionNode.Antecedent> fixedUnits = new ArrayDeque<ResolutionNode.Antecedent>(units.size());
        while (!units.isEmpty()) {
            ResolutionNode.Antecedent a = units.remove();
            fixedUnits.add(new ResolutionNode.Antecedent(a.mPivot, fix.fix(a.mAntecedent, deletedNodes)));
        }
        counts = null;
        units = null;
        deletedNodes = null;
        fix = null;
        HashSet<Literal> lits = new HashSet<Literal>();
        for (int i = 0; i < tmpproof.getSize(); ++i) {
            lits.add(tmpproof.getLiteral(i));
        }
        if (lits.isEmpty()) {
            return tmpproof;
        }
        ResolutionNode.Antecedent[] antes = new ResolutionNode.Antecedent[fixedUnits.size()];
        int antepos = 0;
        while (!fixedUnits.isEmpty()) {
            ResolutionNode.Antecedent unit = (ResolutionNode.Antecedent)fixedUnits.remove();
            if (!lits.contains(unit.mPivot.negate())) continue;
            antes[antepos++] = unit;
            lits.remove(unit.mPivot.negate());
            for (int i = 0; i < unit.mAntecedent.getSize(); ++i) {
                Literal l = unit.mAntecedent.getLiteral(i);
                if (l == unit.mPivot) continue;
                lits.add(l);
            }
        }
        if (antepos < antes.length) {
            ResolutionNode.Antecedent[] tmp = new ResolutionNode.Antecedent[antepos];
            System.arraycopy(antes, 0, tmp, 0, antepos);
            antes = tmp;
        }
        assert (lits.isEmpty());
        return new Clause(new Literal[0], new ResolutionNode(tmpproof, antes));
    }

    public static Clause recycleUnits(Clause proof) {
        assert (proof.getSize() == 0);
        OccurrenceCounter occ = new OccurrenceCounter();
        Map<Clause, Integer> counts = occ.count(proof);
        occ = null;
        RecyclePivots rp = new RecyclePivots();
        Map<Clause, Set<Literal>> deleted = rp.regularize(proof, counts);
        rp = null;
        FixProofDAG fix = new FixProofDAG();
        return fix.fix(proof, deleted);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AvailableTransformations {
        NONE{

            public Clause transform(Clause proof) {
                return proof;
            }
        }
        ,
        LU{

            public Clause transform(Clause proof) {
                return Transformations.lowerUnits(proof);
            }
        }
        ,
        RPI{

            public Clause transform(Clause proof) {
                return Transformations.recycleUnits(proof);
            }
        }
        ,
        RPILU{

            public Clause transform(Clause proof) {
                return Transformations.lowerUnits(Transformations.recycleUnits(proof));
            }
        }
        ,
        LURPI{

            public Clause transform(Clause proof) {
                return Transformations.recycleUnits(Transformations.lowerUnits(proof));
            }
        };


        public abstract Clause transform(Clause var1);
    }
}

