/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.Config;
import de.uni_freiburg.informatik.ultimate.smtinterpol.Main;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolCollector;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTermGenerator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.Transformations;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.UnsatCoreCollector;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Div0Remover;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.ScopedArrayList;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTInterpol
extends NoopScript {
    private CheckType mCheckType = CheckType.FULL;
    private DPLLEngine mEngine;
    private Clausifier mClausifier;
    private ScopedArrayList<Term> mAssertions;
    private final TerminationRequest mCancel;
    private String mOutName = "stdout";
    private PrintWriter mErr = new PrintWriter(System.err);
    private String mErrName = "stderr";
    private SimpleLayout mLayout;
    private Logger mLogger;
    private WriterAppender mAppender;
    String mErrorMessage;
    boolean mProduceModels = false;
    long mRandomSeed = 11350294L;
    boolean mProduceProofs = false;
    boolean mProduceUnsatCores = false;
    boolean mProduceAssignment = false;
    boolean mProduceInterpolants = false;
    boolean mReportSuccess = true;
    boolean mPrintCSE = true;
    boolean mInterpolantCheckMode = false;
    boolean mUnsatCoreCheckMode = false;
    boolean mModelCheckMode = false;
    boolean mProofCheckMode = false;
    Model mModel = null;
    private boolean mPartialModels = false;
    private static final Object NAME = new QuotedObject("SMTInterpol");
    private static final Object AUTHORS = new QuotedObject("Jochen Hoenicke, Juergen Christ, and Alexander Nutz");
    private static final Object INTERPOLATION_METHOD = new QuotedObject("tree");
    private Script.LBool mStatus = Script.LBool.SAT;
    private String mStatusSet = null;
    private ReasonUnknown mReasonUnknown = null;
    private long mTimeout;
    private boolean mAssertionStackModified = true;
    private int mBy0Seen = -1;
    private Transformations.AvailableTransformations mProofTransformation = Transformations.AvailableTransformations.NONE;
    private boolean mSimplifyInterpolants = false;
    private CheckType mSimplifyCheckType = CheckType.QUICK;
    private boolean mSimplifyRepeatedly = true;
    private Timer mTimer;
    private static final int OPT_PRINT_SUCCESS = 0;
    private static final int OPT_VERBOSITY = 1;
    private static final int OPT_TIMEOUT = 2;
    private static final int OPT_REGULAR_OUTPUT_CHANNEL = 3;
    private static final int OPT_DIAGNOSTIC_OUTPUT_CHANNEL = 4;
    private static final int OPT_PRODUCE_PROOFS = 5;
    private static final int OPT_PRODUCE_MODELS = 6;
    private static final int OPT_PRODUCE_ASSIGNMENTS = 7;
    private static final int OPT_RANDOM_SEED = 8;
    private static final int OPT_INTERACTIVE_MODE = 9;
    private static final int OPT_INTERPOLANT_CHECK_MODE = 10;
    private static final int OPT_PRODUCE_INTERPOLANTS = 11;
    private static final int OPT_PRODUCE_UNSAT_CORES = 12;
    private static final int OPT_UNSAT_CORE_CHECK_MODE = 13;
    private static final int OPT_PRINT_TERMS_CSE = 14;
    private static final int OPT_MODEL_CHECK_MODE = 15;
    private static final int OPT_PROOF_TRANSFORMATION = 16;
    private static final int OPT_MODELS_PARTIAL = 17;
    private static final int OPT_CHECK_TYPE = 18;
    private static final int OPT_SIMPLIFY_INTERPOLANTS = 19;
    private static final int OPT_SIMPLIFY_CHECK_TYPE = 20;
    private static final int OPT_SIMPLIFY_REPEATEDLY = 21;
    private static final int OPT_PROOF_CHECK_MODE = 22;
    private static final OptionMap OPTIONS = new OptionMap();
    private final boolean mDDFriendly;

    public SMTInterpol() {
        this(Logger.getRootLogger(), true, new NoUserCancellation());
    }

    public SMTInterpol(Logger logger) {
        this(logger, false, new NoUserCancellation());
    }

    public SMTInterpol(Logger logger, boolean ownLogger) {
        this(logger, ownLogger, new NoUserCancellation());
    }

    public SMTInterpol(TerminationRequest cancel) {
        this(Logger.getRootLogger(), true, cancel);
    }

    public SMTInterpol(Logger logger, TerminationRequest cancel) {
        this(logger, false, cancel);
    }

    public SMTInterpol(Logger logger, boolean ownLogger, TerminationRequest cancel) {
        this.mDDFriendly = false;
        if (cancel == null) {
            cancel = new NoUserCancellation();
        }
        this.mLogger = logger;
        if (ownLogger) {
            this.mLayout = new SimpleLayout();
            this.mAppender = new WriterAppender((Layout)this.mLayout, this.mErr);
            this.mLogger.addAppender(this.mAppender);
            this.mLogger.setLevel(Config.DEFAULT_LOG_LEVEL);
        }
        this.mTimeout = 0L;
        this.mCancel = cancel;
        this.reset();
    }

    public SMTInterpol(SMTInterpol other, Map<String, Object> options) {
        super(other.getTheory());
        this.mDDFriendly = false;
        this.mLogger = other.mLogger;
        this.mTimeout = other.mTimeout;
        if (options != null) {
            for (Map.Entry<String, Object> me : options.entrySet()) {
                this.setOption(me.getKey(), me.getValue());
            }
        }
        this.mCancel = other.mCancel;
        this.setupClausifier(this.getTheory().getLogic());
    }

    @Override
    public final void reset() {
        super.reset();
        this.mEngine = null;
        this.mModel = null;
        this.mAssertionStackModified = true;
        if (this.mAssertions != null) {
            this.mAssertions.clear();
        }
    }

    @Override
    public void push(int n) throws SMTLIBException {
        super.push(n);
        this.modifyAssertionStack();
        while (n-- > 0) {
            if (this.mAssertions != null) {
                this.mAssertions.beginScope();
            }
            this.mClausifier.push();
        }
    }

    @Override
    public void pop(int n) throws SMTLIBException {
        super.pop(n);
        this.modifyAssertionStack();
        int i = n;
        while (i-- > 0) {
            if (this.mAssertions == null) continue;
            this.mAssertions.endScope();
        }
        this.mClausifier.pop(n);
        if (this.mStackLevel < this.mBy0Seen) {
            this.mBy0Seen = -1;
        }
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mModel = null;
        this.mAssertionStackModified = false;
        TimeoutTask timer = null;
        if (this.mTimeout > 0L) {
            timer = new TimeoutTask(this.mEngine);
            this.getTimer().schedule((TimerTask)timer, this.mTimeout);
        }
        Script.LBool result = Script.LBool.UNKNOWN;
        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
        this.mEngine.setRandomSeed(this.mRandomSeed);
        try {
            if (this.mCheckType.check(this.mEngine)) {
                if (this.mEngine.hasModel()) {
                    result = Script.LBool.SAT;
                    if (this.mModelCheckMode) {
                        this.mModel = new Model(this.mClausifier, this.getTheory(), this.mPartialModels);
                        for (Term asserted : this.mAssertions) {
                            Term checkedResult = this.mModel.evaluate(asserted);
                            if (checkedResult == this.getTheory().mTrue) continue;
                            if (this.mDDFriendly) {
                                System.exit(1);
                            }
                            this.mLogger.fatal("Model does not satisfy " + asserted.toStringDirect());
                        }
                    }
                } else {
                    result = Script.LBool.UNKNOWN;
                    switch (this.mEngine.getCompleteness()) {
                        case 0: {
                            if (this.mCheckType == CheckType.FULL) {
                                throw new InternalError("Complete but no model?");
                            }
                            this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                            break;
                        }
                        case 3: {
                            this.mReasonUnknown = ReasonUnknown.MEMOUT;
                            break;
                        }
                        case 5: {
                            this.mReasonUnknown = ReasonUnknown.TIMEOUT;
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                            break;
                        }
                        case 4: {
                            this.mReasonUnknown = ReasonUnknown.CRASHED;
                            break;
                        }
                        case 6: {
                            this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                            break;
                        }
                        case 7: {
                            this.mReasonUnknown = ReasonUnknown.CANCELLED;
                            break;
                        }
                        default: {
                            throw new InternalError("Unknown incompleteness reason");
                        }
                    }
                    this.mLogger.info(new DebugMessage("Got {0} as reason to return unknown", this.mEngine.getCompletenessReason()));
                }
            } else {
                ProofChecker proofchecker;
                result = Script.LBool.UNSAT;
                if (this.mProofCheckMode && !(proofchecker = new ProofChecker(this, this.getLogger())).check(this.getProof())) {
                    if (this.mDDFriendly) {
                        System.exit(2);
                    }
                    this.mLogger.fatal("Proof-checker did not verify");
                }
            }
        }
        catch (OutOfMemoryError eoom) {
            this.mReasonUnknown = ReasonUnknown.MEMOUT;
        }
        catch (Throwable ex) {
            if (this.mDDFriendly) {
                System.exit(3);
            }
            this.mLogger.fatal("Error during check ", ex);
            this.mReasonUnknown = ReasonUnknown.CRASHED;
        }
        this.mStatus = result;
        this.mStatusSet = null;
        if (timer != null) {
            timer.cancel();
        }
        return result;
    }

    private final boolean isStatusSet() {
        return this.mStatusSet != null && !this.mStatusSet.equals("unknown");
    }

    @Override
    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        try {
            this.setLogic(Logics.valueOf(logic));
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Logic " + logic + " not supported");
        }
    }

    @Override
    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        this.mSolverSetup = new SMTInterpolSetup(this.getProofMode());
        super.setLogic(logic);
        this.setupClausifier(logic);
    }

    private void setupClausifier(Logics logic) {
        try {
            int proofMode = this.getProofMode();
            this.mEngine = new DPLLEngine(this.getTheory(), this.mLogger, this.mCancel);
            this.mClausifier = new Clausifier(this.mEngine, proofMode);
            this.mEngine.setProofGeneration(proofMode > 0);
            this.mClausifier.setLogic(logic);
            this.mClausifier.setAssignmentProduction(this.mProduceAssignment);
            this.mEngine.setProduceAssignments(this.mProduceAssignment);
            this.mEngine.setRandomSeed(this.mRandomSeed);
        }
        catch (UnsupportedOperationException eLogicUnsupported) {
            super.reset();
            this.mEngine = null;
            this.mClausifier = null;
            throw eLogicUnsupported;
        }
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        super.assertTerm(term);
        if (!term.getSort().equals(this.getTheory().getBooleanSort())) {
            if (term.getSort().getTheory() == this.getTheory()) {
                throw new SMTLIBException("Asserted terms must have sort Bool");
            }
            throw new SMTLIBException("Asserted terms created with incompatible theory");
        }
        if (this.mAssertions != null) {
            this.mAssertions.add(term);
        }
        if (this.mEngine.inconsistent()) {
            this.mLogger.info("Asserting into inconsistent context");
            return Script.LBool.UNSAT;
        }
        try {
            this.modifyAssertionStack();
            this.mClausifier.addFormula(term);
            if (this.mClausifier.resetBy0Seen() && this.mBy0Seen == -1) {
                this.mBy0Seen = this.mStackLevel;
            }
            if (!this.mEngine.quickCheck()) {
                this.mLogger.info("Assertion made context inconsistent");
                return Script.LBool.UNSAT;
            }
        }
        catch (UnsupportedOperationException ex) {
            throw new SMTLIBException(ex.getMessage());
        }
        catch (RuntimeException exc) {
            if (this.mDDFriendly) {
                System.exit(7);
            }
            throw exc;
        }
        catch (AssertionError exc) {
            if (this.mDDFriendly) {
                System.exit(7);
            }
            throw exc;
        }
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mAssertions != null) {
            return this.mAssertions.toArray(new Term[this.mAssertions.size()]);
        }
        throw new SMTLIBException("Set option :interactive-mode to true to get assertions!");
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.mEngine.isProduceAssignments()) {
            throw new SMTLIBException("Set option :produce-assignments to true to generate assignments!");
        }
        this.checkAssertionStackModified();
        return this.mEngine.getAssignments();
    }

    @Override
    public Object getInfo(String info) throws UnsupportedOperationException {
        if (":status".equals(info)) {
            return this.mStatus;
        }
        if (":name".equals(info)) {
            return NAME;
        }
        if (":version".equals(info)) {
            return new QuotedObject(Main.getVersion());
        }
        if (":authors".equals(info)) {
            return AUTHORS;
        }
        if (":all-statistics".equals(info)) {
            return this.mEngine == null ? new Object[]{} : this.mEngine.getStatistics();
        }
        if (":status-set".equals(info)) {
            return this.mStatusSet;
        }
        if (":options".equals(info)) {
            return OPTIONS.getOptionNames();
        }
        if (":reason-unknown".equals(info)) {
            if (this.mStatus != Script.LBool.UNKNOWN) {
                throw new SMTLIBException("Status not unknown");
            }
            return this.mReasonUnknown;
        }
        if (":assertion-stack-levels".equals(info)) {
            return this.mStackLevel;
        }
        if (":interpolation-method".equals(info)) {
            return INTERPOLATION_METHOD;
        }
        Option opt = OPTIONS.find(info);
        if (opt != null) {
            if (opt.isOnlineModifyable()) {
                return new Object[]{":description", new QuotedObject(opt.getDescription()), ":online-modifyable"};
            }
            return new Object[]{":description", new QuotedObject(opt.getDescription())};
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getOption(String opt) throws UnsupportedOperationException {
        Option o = OPTIONS.find(opt);
        if (o == null) {
            throw new UnsupportedOperationException();
        }
        switch (o.getOptionNumber()) {
            case 0: {
                return this.mReportSuccess;
            }
            case 1: {
                switch (this.mLogger.getLevel().toInt()) {
                    case -2147483648: {
                        return BigInteger.valueOf(6L);
                    }
                    case 10000: {
                        return BigInteger.valueOf(5L);
                    }
                    case 20000: {
                        return BigInteger.valueOf(4L);
                    }
                    case 30000: {
                        return BigInteger.valueOf(3L);
                    }
                    case 40000: {
                        return BigInteger.valueOf(2L);
                    }
                    case 50000: {
                        return BigInteger.valueOf(1L);
                    }
                }
                return BigInteger.valueOf(0L);
            }
            case 2: {
                return BigInteger.valueOf(this.mTimeout);
            }
            case 3: {
                return this.mOutName;
            }
            case 4: {
                return this.mErrName;
            }
            case 5: {
                return this.mProduceProofs;
            }
            case 6: {
                return this.mProduceModels;
            }
            case 7: {
                return this.mProduceAssignment;
            }
            case 8: {
                return BigInteger.valueOf(this.mRandomSeed);
            }
            case 9: {
                return this.mAssertions != null;
            }
            case 10: {
                return this.mInterpolantCheckMode;
            }
            case 12: {
                return this.mProduceUnsatCores;
            }
            case 13: {
                return this.mUnsatCoreCheckMode;
            }
            case 14: {
                return this.mPrintCSE;
            }
            case 15: {
                return this.mModelCheckMode;
            }
            case 16: {
                return this.mProofTransformation.name();
            }
            case 11: {
                return this.mProduceInterpolants;
            }
            case 17: {
                return this.mPartialModels;
            }
            case 18: {
                return this.mCheckType.name().toLowerCase();
            }
            case 19: {
                return this.mSimplifyInterpolants;
            }
            case 20: {
                return this.mSimplifyCheckType.name().toLowerCase();
            }
            case 21: {
                return this.mSimplifyRepeatedly;
            }
            case 22: {
                return this.mProofCheckMode;
            }
        }
        throw new InternalError("This should be implemented!!!");
    }

    private int getProofMode() {
        if (this.mProofCheckMode || this.mProduceProofs) {
            return 2;
        }
        if (this.mProduceInterpolants || this.mProduceUnsatCores) {
            return 1;
        }
        return 0;
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        int proofMode = this.getProofMode();
        if (proofMode == 0) {
            throw new SMTLIBException("Option :produce-proofs not set to true");
        }
        if (proofMode == 1) {
            this.mLogger.warn("Using partial proofs (cut at CNF-level).  Set option :produce-proofs to true to get complete proofs.");
        }
        this.checkAssertionStackModified();
        Clause unsat = this.retrieveProof();
        try {
            ProofTermGenerator generator = new ProofTermGenerator(this.getTheory());
            Term res = generator.convert(this.retrieveProof());
            if (this.mBy0Seen != -1) {
                res = new Div0Remover().transform(res);
            }
            return res;
        }
        catch (Exception exc) {
            throw new SMTLIBException(exc.getMessage() == null ? exc.toString() : exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.mProduceProofs && !this.mProduceInterpolants) {
            throw new SMTLIBException("Interpolant production not enabled.  Set either :produce-interpolants or :produce-proofs to true");
        }
        this.checkAssertionStackModified();
        if (partition.length != startOfSubtree.length) {
            throw new SMTLIBException("Partition table and subtree array need to have equal length");
        }
        Set[] parts = new Set[partition.length];
        String errormsg = "arguments must be named terms or conjunctions of named terms";
        for (int i = 0; i < partition.length; ++i) {
            Term[] terms;
            if (!(partition[i] instanceof ApplicationTerm)) {
                throw new SMTLIBException(errormsg);
            }
            FunctionSymbol fsym = ((ApplicationTerm)partition[i]).getFunction();
            if (fsym.isIntern()) {
                if (!fsym.getName().equals("and")) {
                    throw new SMTLIBException(errormsg);
                }
                terms = ((ApplicationTerm)partition[i]).getParameters();
            } else {
                terms = new Term[]{partition[i]};
            }
            parts[i] = new HashSet();
            for (int j = 0; j < terms.length; ++j) {
                if (!(terms[j] instanceof ApplicationTerm)) {
                    throw new SMTLIBException(errormsg);
                }
                ApplicationTerm appTerm = (ApplicationTerm)terms[j];
                if (appTerm.getParameters().length != 0) {
                    throw new SMTLIBException(errormsg);
                }
                if (appTerm.getFunction().isIntern()) {
                    throw new SMTLIBException(errormsg);
                }
                parts[i].add(appTerm.getFunction().getName().intern());
            }
        }
        SMTInterpol tmpBench = null;
        SymbolCollector collector = null;
        Set<FunctionSymbol> globals = null;
        if (this.mInterpolantCheckMode) {
            HashSet usedParts = new HashSet();
            for (Set part : parts) {
                usedParts.addAll(part);
            }
            tmpBench = new SMTInterpol(this, Collections.singletonMap(":interactive-mode", Boolean.TRUE));
            Level old = tmpBench.mLogger.getLevel();
            try {
                tmpBench.mLogger.setLevel(Level.ERROR);
                collector = new SymbolCollector();
                collector.startCollectTheory();
                block11: for (Term asserted : this.mAssertions) {
                    if (asserted instanceof AnnotatedTerm) {
                        AnnotatedTerm annot = (AnnotatedTerm)asserted;
                        for (Annotation an : annot.getAnnotations()) {
                            if (":named".equals(an.getKey()) && usedParts.contains(an.getValue())) continue block11;
                        }
                    }
                    tmpBench.assertTerm(asserted);
                    collector.addGlobalSymbols(asserted);
                }
                globals = collector.getTheorySymbols();
            }
            finally {
                tmpBench.mLogger.setLevel(old);
            }
            usedParts = null;
        }
        Interpolator interpolator = new Interpolator(this.mLogger, tmpBench, this.getTheory(), parts, startOfSubtree);
        Clause refutation = this.retrieveProof();
        Term[] ipls = interpolator.getInterpolants(refutation);
        if (this.mBy0Seen != -1) {
            Div0Remover rem = new Div0Remover();
            for (int i = 0; i < ipls.length; ++i) {
                ipls[i] = rem.transform(ipls[i]);
            }
        }
        if (this.mInterpolantCheckMode) {
            boolean error = false;
            Level old = tmpBench.mLogger.getLevel();
            try {
                int i;
                tmpBench.mLogger.setLevel(Level.ERROR);
                Map[] occs = new Map[partition.length];
                for (i = 0; i < partition.length; ++i) {
                    occs[i] = collector.collect(partition[i]);
                }
                for (i = 0; i < startOfSubtree.length; ++i) {
                    int child = i - 1;
                    while (child >= startOfSubtree[i]) {
                        for (Map.Entry me : occs[child].entrySet()) {
                            Integer ival = (Integer)occs[i].get(me.getKey());
                            ival = ival == null ? (Integer)me.getValue() : ival + (Integer)me.getValue();
                            occs[i].put(me.getKey(), ival);
                        }
                        child = startOfSubtree[child] - 1;
                    }
                }
                SymbolChecker checker = new SymbolChecker(globals);
                for (int i2 = 0; i2 < startOfSubtree.length; ++i2) {
                    tmpBench.push(1);
                    int child = i2 - 1;
                    while (child >= startOfSubtree[i2]) {
                        tmpBench.assertTerm(ipls[child]);
                        child = startOfSubtree[child] - 1;
                    }
                    tmpBench.assertTerm(partition[i2]);
                    try {
                        if (i2 != ipls.length) {
                            tmpBench.assertTerm(tmpBench.term("not", ipls[i2]));
                        }
                    }
                    catch (SMTLIBException exc) {
                        this.mLogger.error("Could not assert interpolant", exc);
                        error = true;
                    }
                    Script.LBool res = tmpBench.checkSat();
                    if (res == Script.LBool.SAT) {
                        if (this.mDDFriendly) {
                            System.exit(2);
                        }
                        this.mLogger.error(new DebugMessage("Interpolant {0} not inductive:  (Check returned {1})", new Object[]{i2, res}));
                        error = true;
                    } else if (res == Script.LBool.UNKNOWN) {
                        ReasonUnknown ru = tmpBench.mReasonUnknown;
                        this.mLogger.warn("Unable to check validity of interpolant: " + (Object)((Object)ru));
                    }
                    tmpBench.pop(1);
                    if (i2 == ipls.length || !checker.check(ipls[i2], occs[i2], occs[ipls.length])) continue;
                    this.mLogger.error(new DebugMessage("Symbol error in Interpolant {0}.  Subtree only symbols: {1}.  Non-subtree only symbols: {2}.", i2, checker.getLeftErrors(), checker.getRightErrors()));
                    error = true;
                }
            }
            finally {
                tmpBench.mLogger.setLevel(old);
                tmpBench.exit();
            }
            if (error) {
                throw new SMTLIBException("generated interpolants did not pass sanity check");
            }
        }
        if (this.mSimplifyInterpolants) {
            SimplifyDDA simplifier = new SimplifyDDA(new SMTInterpol(this, Collections.singletonMap(":check-type", this.mSimplifyCheckType.name())), this.mSimplifyRepeatedly);
            for (int i = 0; i < ipls.length; ++i) {
                ipls[i] = simplifier.getSimplifiedTerm(ipls[i]);
            }
        }
        return ipls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.mProduceUnsatCores) {
            throw new SMTLIBException("Set option :produce-unsat-cores to true before using get-unsat-cores");
        }
        this.checkAssertionStackModified();
        Clause unsat = this.mEngine.getProof();
        if (unsat == null) {
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Term[] core = new UnsatCoreCollector(this).getUnsatCore(unsat);
        if (this.mUnsatCoreCheckMode) {
            HashSet<String> usedParts = new HashSet<String>();
            for (Term t : core) {
                usedParts.add(((ApplicationTerm)t).getFunction().getName());
            }
            SMTInterpol tmpBench = new SMTInterpol(this, null);
            Level old = tmpBench.mLogger.getLevel();
            try {
                tmpBench.mLogger.setLevel(Level.ERROR);
                block4: for (Term asserted : this.mAssertions) {
                    if (asserted instanceof AnnotatedTerm) {
                        AnnotatedTerm annot = (AnnotatedTerm)asserted;
                        for (Annotation an : annot.getAnnotations()) {
                            if (":named".equals(an.getKey()) && usedParts.contains(an.getValue())) continue block4;
                        }
                    }
                    tmpBench.assertTerm(asserted);
                }
                for (Term t : core) {
                    tmpBench.assertTerm(t);
                }
                Script.LBool isUnsat = tmpBench.checkSat();
                if (isUnsat != Script.LBool.UNSAT) {
                    this.mLogger.error(new DebugMessage("Unsat core could not be proven unsat (Result is {0})", new Object[]{isUnsat}));
                }
            }
            finally {
                tmpBench.mLogger.setLevel(old);
                tmpBench.exit();
            }
        }
        return core;
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.buildModel();
        return this.mModel.evaluate(terms);
    }

    @Override
    public de.uni_freiburg.informatik.ultimate.logic.Model getModel() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.buildModel();
        return this.mModel;
    }

    @Override
    public void setInfo(String info, Object value) {
        if (info.equals(":status") && value instanceof String) {
            if (value.equals("sat")) {
                this.mStatus = Script.LBool.SAT;
                this.mStatusSet = "sat";
            } else if (value.equals("unsat")) {
                this.mStatus = Script.LBool.UNSAT;
                this.mStatusSet = "unsat";
            } else if (value.equals("unknown")) {
                this.mStatus = Script.LBool.UNKNOWN;
                this.mStatusSet = "unknown";
            }
        }
    }

    public PrintWriter createChannel(String file) throws IOException {
        if (file.equals("stdout")) {
            return new PrintWriter(System.out);
        }
        if (file.equals("stderr")) {
            return new PrintWriter(System.err);
        }
        return new PrintWriter(new FileWriter(file));
    }

    private final void checkOnlineModifyable(Option opt) throws SMTLIBException {
        if (this.mEngine != null && !opt.isOnlineModifyable()) {
            throw new SMTLIBException("Option " + opt.getName() + " can only be changed before setting the logic");
        }
    }

    @Override
    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        Option o = OPTIONS.find(opt);
        if (o == null) {
            throw new UnsupportedOperationException();
        }
        this.checkOnlineModifyable(o);
        switch (o.getOptionNumber()) {
            case 0: {
                this.mReportSuccess = o.checkArg(value, this.mReportSuccess);
                break;
            }
            case 1: {
                int level;
                BigInteger blevel = o.checkArg(value, BigInteger.ZERO);
                int n = level = blevel.bitLength() >= 32 ? Integer.MAX_VALUE : blevel.intValue();
                if (level > 5) {
                    this.mLogger.setLevel(Level.ALL);
                    break;
                }
                if (level > 4) {
                    this.mLogger.setLevel(Level.DEBUG);
                    break;
                }
                if (level > 3) {
                    this.mLogger.setLevel(Level.INFO);
                    break;
                }
                if (level > 2) {
                    this.mLogger.setLevel(Level.WARN);
                    break;
                }
                if (level > 1) {
                    this.mLogger.setLevel(Level.ERROR);
                    break;
                }
                if (level > 0) {
                    this.mLogger.setLevel(Level.FATAL);
                    break;
                }
                if (level == -1) {
                    this.mLogger.setLevel(Level.TRACE);
                    break;
                }
                this.mLogger.setLevel(Level.OFF);
                break;
            }
            case 2: {
                BigInteger val = o.checkArg(value, BigInteger.ZERO);
                if (val.signum() == -1) {
                    this.mTimeout = 0L;
                    break;
                }
                if (val.bitLength() < 63) {
                    this.mTimeout = val.longValue();
                    break;
                }
                this.mTimeout = Long.MAX_VALUE;
                break;
            }
            case 3: {
                this.mOutName = o.checkArg(value, this.mOutName);
                break;
            }
            case 4: {
                if (this.mAppender == null) {
                    throw new SMTLIBException("SMTInterpol does not own the logger");
                }
                try {
                    String arg = o.checkArg(value, this.mErrName);
                    this.mErr = this.createChannel(arg);
                    this.mAppender.setWriter(this.mErr);
                    this.mErrName = arg;
                    break;
                }
                catch (IOException ex) {
                    this.mLogger.error(ex);
                    throw new SMTLIBException("file not found: " + value);
                }
            }
            case 5: {
                this.mProduceProofs = o.checkArg(value, this.mProduceProofs);
                break;
            }
            case 6: {
                this.mProduceModels = o.checkArg(value, this.mProduceModels);
                break;
            }
            case 7: {
                this.mProduceAssignment = o.checkArg(value, this.mProduceAssignment);
                break;
            }
            case 8: {
                BigInteger val = o.checkArg(value, BigInteger.ZERO);
                long l = this.mRandomSeed = val.bitLength() < 64 ? val.longValue() : Long.MAX_VALUE;
                if (this.mEngine == null) break;
                this.mEngine.setRandomSeed(this.mRandomSeed);
                break;
            }
            case 9: {
                if (o.checkArg(value, Boolean.TRUE) == Boolean.TRUE) {
                    this.mAssertions = new ScopedArrayList();
                    break;
                }
                if (this.mInterpolantCheckMode || this.mUnsatCoreCheckMode || this.mProofCheckMode) break;
                this.mAssertions = null;
                break;
            }
            case 10: {
                this.mInterpolantCheckMode = o.checkArg(value, this.mInterpolantCheckMode);
                if (!this.mInterpolantCheckMode || this.mAssertions != null) break;
                this.mAssertions = new ScopedArrayList();
                break;
            }
            case 12: {
                this.mProduceUnsatCores = o.checkArg(value, this.mProduceUnsatCores);
                break;
            }
            case 13: {
                this.mUnsatCoreCheckMode = o.checkArg(value, this.mUnsatCoreCheckMode);
                if (!this.mUnsatCoreCheckMode || this.mAssertions != null) break;
                this.mAssertions = new ScopedArrayList();
                break;
            }
            case 14: {
                this.mPrintCSE = o.checkArg(value, this.mPrintCSE);
                break;
            }
            case 15: {
                this.mModelCheckMode = o.checkArg(value, this.mModelCheckMode);
                if (!this.mModelCheckMode || this.mAssertions != null) break;
                this.mAssertions = new ScopedArrayList();
                break;
            }
            case 16: {
                String arg = o.checkArg(value, "");
                try {
                    Transformations.AvailableTransformations tmp;
                    this.mProofTransformation = tmp = Transformations.AvailableTransformations.valueOf(arg);
                    break;
                }
                catch (IllegalArgumentException eiae) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Illegal value. Only ");
                    String sep = "";
                    for (Transformations.AvailableTransformations a : Transformations.AvailableTransformations.values()) {
                        sb.append(sep).append(a.name());
                        sep = ", ";
                    }
                    sb.append(" allowed.");
                    throw new SMTLIBException(sb.toString());
                }
            }
            case 11: {
                this.mProduceInterpolants = o.checkArg(value, this.mProduceInterpolants);
                break;
            }
            case 17: {
                this.mPartialModels = o.checkArg(value, this.mPartialModels);
                this.mModel = null;
                break;
            }
            case 18: {
                this.mCheckType = CheckType.fromOption(o, value);
                break;
            }
            case 19: {
                this.mSimplifyInterpolants = o.checkArg(value, this.mSimplifyInterpolants);
                break;
            }
            case 20: {
                this.mSimplifyCheckType = CheckType.fromOption(o, value);
                break;
            }
            case 21: {
                this.mSimplifyRepeatedly = o.checkArg(value, this.mSimplifyRepeatedly);
                break;
            }
            case 22: {
                this.mProofCheckMode = o.checkArg(value, this.mProofCheckMode);
                if (!this.mProofCheckMode || this.mAssertions != null) break;
                this.mAssertions = new ScopedArrayList();
                break;
            }
            default: {
                throw new InternalError("This should be implemented!!!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term simplify(Term term) throws SMTLIBException {
        CheckType old = this.mCheckType;
        int oldNumScopes = this.mStackLevel;
        try {
            this.mCheckType = this.mSimplifyCheckType;
            Term term2 = new SimplifyDDA(this, this.mSimplifyRepeatedly).getSimplifiedTerm(term);
            return term2;
        }
        finally {
            this.mCheckType = old;
            assert (this.mStackLevel == oldNumScopes);
        }
    }

    public void flipDecisions() {
        this.mEngine.flipDecisions();
    }

    public void flipNamedLiteral(String name) throws SMTLIBException {
        this.mEngine.flipNamedLiteral(name);
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public Logger getLogger() {
        return this.mLogger;
    }

    protected void setEngine(DPLLEngine engine) {
        this.mEngine = engine;
    }

    protected void setClausifier(Clausifier clausifier) {
        this.mClausifier = clausifier;
    }

    private void checkAssertionStackModified() throws SMTLIBException {
        if (this.mAssertionStackModified) {
            throw new SMTLIBException("Assertion stack has been modified since last check-sat!");
        }
    }

    private void modifyAssertionStack() {
        this.mAssertionStackModified = true;
        this.mModel = null;
    }

    private void buildModel() throws SMTLIBException {
        this.checkAssertionStackModified();
        if (this.mEngine.inconsistent()) {
            if (this.mDDFriendly) {
                System.exit(4);
            }
            throw new SMTLIBException("Context is inconsistent");
        }
        if (this.mStatus != Script.LBool.SAT) {
            if (this.mDDFriendly) {
                System.exit(9);
            }
            throw new SMTLIBException("Cannot construct model since solving did not complete");
        }
        if (this.mModel == null) {
            this.mModel = new Model(this.mClausifier, this.getTheory(), this.mPartialModels);
        }
    }

    public Clause retrieveProof() throws SMTLIBException {
        Clause unsat = this.mEngine.getProof();
        if (unsat == null) {
            if (this.mDDFriendly) {
                System.exit(5);
            }
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Clause proof = this.mProofTransformation.transform(unsat);
        return proof;
    }

    public Term[] getSatisfiedLiterals() throws SMTLIBException {
        this.checkAssertionStackModified();
        return this.mEngine.getSatisfiedLiterals();
    }

    private boolean dumpInterpolationBug(int[] startOfSubtree, Term[] partition, Term[] ipls, int num) {
        try {
            FileWriter fw = new FileWriter("iplBug.txt");
            FormulaUnLet unlet = new FormulaUnLet();
            PrintTerm outputter = new PrintTerm();
            int child = num - 1;
            while (child >= startOfSubtree[num]) {
                outputter.append((Appendable)fw, unlet.unlet(ipls[child]));
                child = startOfSubtree[child] - 1;
                fw.append("\nand\n");
            }
            outputter.append((Appendable)fw, ((ApplicationTerm)partition[num]).getFunction().getDefinition());
            fw.append('\n');
            if (num != ipls.length) {
                fw.append("==>\n");
                outputter.append((Appendable)fw, unlet.unlet(ipls[num]));
                fw.append('\n');
            }
            fw.flush();
            fw.close();
            return true;
        }
        catch (IOException eioe) {
            eioe.printStackTrace();
            return false;
        }
    }

    @Override
    public Iterable<Term[]> checkAllsat(final Term[] input) {
        final Literal[] lits = new Literal[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (input[i].getSort() != this.getTheory().getBooleanSort()) {
                throw new SMTLIBException("AllSAT over non-Boolean");
            }
            lits[i] = this.mClausifier.getCreateLiteral(input[i]);
        }
        return new Iterable<Term[]>(){

            @Override
            public Iterator<Term[]> iterator() {
                DPLLEngine dPLLEngine = SMTInterpol.this.mEngine;
                dPLLEngine.getClass();
                return dPLLEngine.new DPLLEngine.AllSatIterator(lits, input);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term[] findImpliedEquality(Term[] x, Term[] y) throws SMTLIBException, UnsupportedOperationException {
        Term ct;
        Term bt;
        Term at;
        block21: {
            Rational xdiff;
            if (x.length != y.length) {
                throw new SMTLIBException("Different number of x's and y's");
            }
            if (x.length < 2) {
                throw new SMTLIBException("Need at least two elements to find equality");
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i].getSort().isNumericSort() && y[i].getSort().isNumericSort()) continue;
                throw new SMTLIBException("Only numeric types supported");
            }
            Script.LBool isSat = this.checkSat();
            if (isSat == Script.LBool.UNSAT) {
                throw new SMTLIBException("Context is inconsistent!");
            }
            Term[] terms = new Term[x.length + y.length];
            System.arraycopy(x, 0, terms, 0, x.length);
            System.arraycopy(y, 0, terms, x.length, y.length);
            Map<Term, Term> vals = this.getValue(terms);
            Rational x0 = (Rational)((ConstantTerm)vals.get(x[0])).getValue();
            Rational y0 = (Rational)((ConstantTerm)vals.get(y[0])).getValue();
            Rational x1 = null;
            Rational y1 = null;
            for (int i = 1; i < x.length; ++i) {
                x1 = (Rational)((ConstantTerm)vals.get(x[i])).getValue();
                y1 = (Rational)((ConstantTerm)vals.get(y[i])).getValue();
                if (!x1.equals(x0)) break;
                if (y1.equals(y0)) continue;
                return new Term[0];
            }
            if ((xdiff = x0.sub(x1)).equals(Rational.ZERO)) {
                return new Term[0];
            }
            Rational a = y0.subdiv(y1, xdiff);
            Rational b = Rational.ONE;
            Rational c = y0.mul(x1).subdiv(x0.mul(y1), xdiff);
            Sort s = x[0].getSort();
            if (x[0].getSort().getName().equals("Int") && y[0].getSort().getName().equals("Int")) {
                BigInteger denom;
                if (!a.isIntegral()) {
                    denom = a.denominator();
                    a = a.mul(denom);
                    b = b.mul(denom);
                    c = c.mul(denom);
                }
                if (!c.isIntegral()) {
                    denom = c.denominator();
                    a = a.mul(denom);
                    b = b.mul(denom);
                    c = c.mul(denom);
                }
            } else if (s.getName().equals("Int")) {
                s = this.sort("Real", new Sort[0]);
            }
            at = a.toTerm(s);
            bt = b.toTerm(s);
            ct = c.toTerm(s);
            if (this.mCheckType == CheckType.FULL) {
                Term[] disj = new Term[x.length];
                for (int i = 0; i < x.length; ++i) {
                    disj[i] = this.term("not", this.term("=", this.term("*", at, x[i]), this.term("+", this.term("*", bt, y[i]), ct)));
                }
                try {
                    this.push(1);
                    this.assertTerm(this.term("or", disj));
                    Script.LBool isImplied = this.checkSat();
                    if (isImplied != Script.LBool.UNSAT) {
                        Term[] termArray = new Term[]{};
                        return termArray;
                    }
                    break block21;
                }
                finally {
                    this.pop(1);
                }
            }
            for (int i = 0; i < x.length; ++i) {
                Term neq = this.term("not", this.term("=", this.term("*", at, x[i]), this.term("+", this.term("*", bt, y[i]), ct)));
                try {
                    this.push(1);
                    this.assertTerm(neq);
                    Script.LBool isImplied = this.checkSat();
                    if (isImplied == Script.LBool.UNSAT) continue;
                    Term[] termArray = new Term[]{};
                    return termArray;
                }
                finally {
                    this.pop(1);
                }
            }
        }
        return new Term[]{at, bt, ct};
    }

    @Override
    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        Sort realSort = resultSort.getRealSort();
        if (realSort.isArraySort() && realSort.getArguments()[0] == this.getTheory().getBooleanSort()) {
            throw new UnsupportedOperationException("SMTInterpol does not support Arrays with Boolean indices");
        }
        super.declareFun(fun, paramSorts, resultSort);
    }

    private Timer getTimer() {
        if (this.mTimer == null) {
            this.mTimer = new Timer("SMTInterpol Timeout Handler", true);
        }
        return this.mTimer;
    }

    @Override
    public void exit() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        super.exit();
    }

    static {
        new BoolOption(":print-success", "Print \"success\" after successfully executing a command", true, 0);
        new IntOption(":verbosity", "Set the verbosity level", true, 1);
        new IntOption(":timeout", "Set the timeout", true, 2);
        new StringOption(":regular-output-channel", "Configure the standard output channel", true, 3);
        new StringOption(":diagnostic-output-channel", "Configure the debug output channel", true, 4);
        new BoolOption(":produce-proofs", "Generate proofs (needed for interpolants)", false, 5);
        new BoolOption(":produce-models", "Produce models", true, 6);
        new BoolOption(":produce-assignments", "Produce assignments for named Boolean terms", false, 7);
        new IntOption(":random-seed", "Set the random seed", true, 8);
        new BoolOption(":interactive-mode", "Cache all asserted terms", false, 9);
        new BoolOption(":interpolant-check-mode", "Check generated interpolants", false, 10);
        new BoolOption(":produce-unsat-cores", "Enable unsat core generation", false, 12);
        new BoolOption(":unsat-core-check-mode", "Check generated unsat cores", false, 13);
        new BoolOption(":print-terms-cse", "Eliminate common subexpressions in output", true, 14);
        new BoolOption(":model-check-mode", "Check satisfiable formulas against the produced model", false, 15);
        new StringOption(":proof-transformation", "Algorithm used to transform the resolution proof tree", true, 16);
        new BoolOption(":produce-interpolants", "Enable interpolant production", false, 11);
        new BoolOption(":partial-models", "Don't totalize models", true, 17);
        new StringOption(":check-type", "Strength of check used in check-sat command", true, 18);
        new BoolOption(":simplify-interpolants", "Apply strong context simplification to computed interpolants", true, 19);
        new StringOption(":simplify-check-type", "Strength of check used in simplify command", true, 20);
        new BoolOption(":simplify-repeatedly", "Simplify until the fixpoint is reached", true, 21);
        new BoolOption(":proof-check-mode", "Check the produced proof for unsatisfiable formulas", false, 22);
    }

    private static class TimeoutTask
    extends TimerTask {
        private final DPLLEngine mEngine;

        public TimeoutTask(DPLLEngine engine) {
            this.mEngine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DPLLEngine dPLLEngine = this.mEngine;
            synchronized (dPLLEngine) {
                this.mEngine.setCompleteness(5);
                this.mEngine.stop();
            }
        }
    }

    private static class OptionMap {
        private Option[] mOptions = new Option[32];
        private int mNumOptions = 0;

        private void grow() {
            Option[] oldOptions = this.mOptions;
            this.mOptions = new Option[this.mOptions.length * 2];
            for (Option o : oldOptions) {
                this.add_internal(o);
            }
        }

        public void add(Option option) {
            if (++this.mNumOptions > this.mOptions.length) {
                this.grow();
            }
            this.add_internal(option);
        }

        private void add_internal(Option o) {
            int hash = o.getName().hashCode();
            for (int i = 0; i < this.mOptions.length; ++i) {
                int idx = hash + i & this.mOptions.length - 1;
                if (this.mOptions[idx] != null) continue;
                this.mOptions[idx] = o;
                return;
            }
            throw new AssertionError((Object)"Did not find empty slot");
        }

        public Option find(String name) {
            int hash = name.hashCode();
            for (int i = 0; i < this.mNumOptions; ++i) {
                int idx = hash + i & this.mOptions.length - 1;
                if (this.mOptions[idx] == null) {
                    return null;
                }
                String optname = this.mOptions[idx].getName();
                if (optname.hashCode() != hash || !optname.equals(name)) continue;
                return this.mOptions[idx];
            }
            return null;
        }

        public String[] getOptionNames() {
            String[] res = new String[this.mNumOptions];
            int pos = 0;
            for (Option o : this.mOptions) {
                if (o == null) continue;
                res[pos] = o.getName();
                if (++pos != this.mNumOptions) continue;
                return res;
            }
            return res;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringOption
    extends Option {
        public StringOption(String optName, String description, boolean onlineModifyable, int optnum) {
            super(optName, description, onlineModifyable, optnum);
        }

        public String checkArg(Object value) throws SMTLIBException {
            if (value instanceof String) {
                return (String)value;
            }
            throw new SMTLIBException("Option " + this.getName() + " expects a string value");
        }

        @Override
        public <T> T checkArg(Object value, T curval) throws SMTLIBException {
            if (curval instanceof String) {
                return (T)this.checkArg(value);
            }
            throw new SMTLIBException("Option " + this.getName() + " expects a string value");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntOption
    extends Option {
        public IntOption(String optName, String description, boolean onlineModifyable, int optnum) {
            super(optName, description, onlineModifyable, optnum);
        }

        public BigInteger checkArg(Object value) throws SMTLIBException {
            if (value instanceof BigInteger) {
                return (BigInteger)value;
            }
            if (value instanceof Long) {
                return BigInteger.valueOf((Long)value);
            }
            if (value instanceof Integer) {
                return BigInteger.valueOf(((Integer)value).intValue());
            }
            if (value instanceof String) {
                try {
                    return new BigInteger((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new SMTLIBException("Option " + this.getName() + " expects a numeral value");
        }

        @Override
        public <T> T checkArg(Object value, T curval) throws SMTLIBException {
            if (curval instanceof BigInteger || curval instanceof Integer || curval instanceof Long) {
                return (T)this.checkArg(value);
            }
            throw new SMTLIBException("Option " + this.getName() + " expects a numeral value");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoolOption
    extends Option {
        public BoolOption(String optName, String description, boolean onlineModifyable, int optnum) {
            super(optName, description, onlineModifyable, optnum);
        }

        public Boolean checkArg(Object value) throws SMTLIBException {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                if (value.equals("false")) {
                    return Boolean.FALSE;
                }
                if (value.equals("true")) {
                    return Boolean.TRUE;
                }
            }
            throw new SMTLIBException("Option " + this.getName() + " expects a Boolean value");
        }

        @Override
        public <T> T checkArg(Object value, T curval) throws SMTLIBException {
            if (curval instanceof Boolean) {
                return (T)this.checkArg(value);
            }
            throw new SMTLIBException("Option " + this.getName() + " expects a Boolean value");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Option {
        private final String mOptName;
        private final String mDescription;
        private final boolean mOnlineModifyable;
        private final int mOptNum;

        public Option(String optName, String description, boolean onlineModifyable, int optnum) {
            this.mOptName = optName;
            this.mDescription = description;
            this.mOnlineModifyable = onlineModifyable;
            this.mOptNum = optnum;
            OPTIONS.add(this);
        }

        public String getName() {
            return this.mOptName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public boolean isOnlineModifyable() {
            return this.mOnlineModifyable;
        }

        public int getOptionNumber() {
            return this.mOptNum;
        }

        public abstract <T> T checkArg(Object var1, T var2) throws SMTLIBException;
    }

    private static class SMTInterpolSetup
    extends Theory.SolverSetup {
        private final int mProofMode;

        public SMTInterpolSetup(int proofMode) {
            this.mProofMode = proofMode;
        }

        public void setLogic(Theory theory, Logics logic) {
            int leftassoc = 2;
            Sort proof = null;
            Sort[] proof2 = null;
            Sort bool = theory.getSort("Bool", new Sort[0]);
            Sort[] bool1 = new Sort[]{bool};
            if (this.mProofMode > 0) {
                this.declareInternalSort(theory, "@Proof", 0, 0);
                proof = theory.getSort("@Proof", new Sort[0]);
                proof2 = new Sort[]{proof, proof};
                this.declareInternalFunction(theory, "@res", proof2, proof, leftassoc);
                this.declareInternalFunction(theory, "@tautology", bool1, proof, 0);
                this.declareInternalFunction(theory, "@lemma", bool1, proof, 0);
                this.declareInternalFunction(theory, "@asserted", bool1, proof, 0);
            }
            if (this.mProofMode > 1) {
                this.declareInternalFunction(theory, "@intern", bool1, proof, 0);
                this.declareInternalFunction(theory, "@split", new Sort[]{proof, bool}, proof, 0);
                this.defineFunction(theory, new RewriteProofFactory("@eq", proof));
                this.declareInternalFunction(theory, "@rewrite", bool1, proof, 0);
                this.declareInternalFunction(theory, "@clause", new Sort[]{proof, bool}, proof, 0);
            }
            this.defineFunction(theory, new FunctionSymbolFactory("@undefined"){

                public int getFlags(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                    return 17;
                }

                public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                    if (indices != null || paramSorts.length != 0) {
                        return null;
                    }
                    return resultSort;
                }
            });
            if (logic.isArray()) {
                this.declareArraySymbols(theory);
            }
            if (logic.hasIntegers()) {
                this.declareIntSymbols(theory);
            }
            if (logic.hasReals()) {
                this.declareRealSymbols(theory);
            }
        }

        private final void declareIntSymbols(Theory theory) {
            Sort intSort = theory.getSort("Int", new Sort[0]);
            Sort[] sort1 = new Sort[]{intSort};
            this.declareInternalFunction(theory, "@mod0", sort1, intSort, 0);
            this.declareInternalFunction(theory, "@div0", sort1, intSort, 0);
        }

        private final void declareRealSymbols(Theory theory) {
            Sort realSort = theory.getSort("Real", new Sort[0]);
            Sort[] sort1 = new Sort[]{realSort};
            this.declareInternalFunction(theory, "@/0", sort1, realSort, 0);
        }

        private final void declareArraySymbols(Theory theory) {
            Sort[] vars = theory.createSortVariables("Index", "Elem");
            Sort array = theory.getSort("Array", vars);
            this.declareInternalPolymorphicFunction(theory, "@diff", vars, new Sort[]{array, array}, vars[0], 0);
        }

        private static class RewriteProofFactory
        extends FunctionSymbolFactory {
            Sort mProofSort;

            public RewriteProofFactory(String name, Sort proofSort) {
                super(name);
                this.mProofSort = proofSort;
            }

            public int getFlags(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                return paramSorts.length == 1 ? 1 : 3;
            }

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length == 0 || paramSorts.length > 2 || resultSort != null || paramSorts[0] != this.mProofSort) {
                    return null;
                }
                if (paramSorts.length == 2 && paramSorts[0] != paramSorts[1]) {
                    return null;
                }
                return paramSorts[0];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CheckType {
        FULL{

            boolean check(DPLLEngine engine) {
                engine.provideCompleteness(0);
                return engine.solve();
            }
        }
        ,
        PROPAGATION{

            boolean check(DPLLEngine engine) {
                engine.provideCompleteness(6);
                return engine.propagate();
            }
        }
        ,
        QUICK{

            boolean check(DPLLEngine engine) {
                engine.provideCompleteness(6);
                return engine.quickCheck();
            }
        };


        abstract boolean check(DPLLEngine var1);

        public static final CheckType fromOption(Option o, Object value) {
            try {
                return CheckType.valueOf(o.checkArg(value, "").toUpperCase());
            }
            catch (IllegalArgumentException eiae) {
                StringBuilder sb = new StringBuilder(53);
                sb.append("Illegal value. Only ");
                String sep = "";
                for (CheckType t : CheckType.values()) {
                    sb.append(sep).append(t.name().toLowerCase());
                    sep = ", ";
                }
                sb.append(" allowed.");
                throw new SMTLIBException(sb.toString());
            }
        }
    }

    private static class NoUserCancellation
    implements TerminationRequest {
        private NoUserCancellation() {
        }

        public boolean isTerminationRequested() {
            return false;
        }
    }
}

