/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.WeakCongruencePath;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAnnotation
extends CCAnnotation {
    final CCTerm[] mWeakIndices;
    final RuleKind mRule;

    public ArrayAnnotation(CCEquality diseq, Collection<CongruencePath.SubPath> paths, RuleKind rule) {
        super(diseq, paths);
        this.mWeakIndices = new CCTerm[this.mPaths.length];
        int i = 0;
        for (CongruencePath.SubPath p : paths) {
            this.mWeakIndices[i++] = p instanceof WeakCongruencePath.WeakSubPath ? ((WeakCongruencePath.WeakSubPath)p).getIndex() : null;
        }
        this.mRule = rule;
    }

    public CCTerm[] getWeakIndices() {
        return this.mWeakIndices;
    }

    @Override
    public Term toTerm(Clause cls, Theory theory) {
        Term base = cls.toTerm(theory);
        Object[] subannots = new Object[2 * this.mPaths.length + (this.mDiseq == null ? 0 : 1)];
        int i = 0;
        if (this.mDiseq != null) {
            subannots[i++] = this.mDiseq.getSMTFormula(theory);
        }
        for (int p = 0; p < this.mPaths.length; ++p) {
            CCTerm idx = this.mWeakIndices[p];
            CCTerm[] path = this.mPaths[p];
            Term[] subs = new Term[path.length];
            for (int j = 0; j < path.length; ++j) {
                subs[j] = path[j].toSMTTerm(theory);
            }
            if (idx != null) {
                subannots[i++] = ":weakpath";
                subannots[i++] = new Object[]{this.mWeakIndices[p].toSMTTerm(theory), subs};
                continue;
            }
            subannots[i++] = ":subpath";
            subannots[i++] = subs;
        }
        Annotation[] annots = new Annotation[]{new Annotation(this.mRule.getKind(), subannots)};
        return theory.term("@lemma", theory.annotatedTerm(annots, base));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RuleKind {
        READ_OVER_WEAKEQ(":read-over-weakeq"),
        WEAKEQ_EXT(":weakeq-ext");

        String mKind;

        private RuleKind(String kind) {
            this.mKind = kind;
        }

        public String getKind() {
            return this.mKind;
        }
    }
}

