/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTermPairHash;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CCTerm
extends SimpleListable<CCTerm> {
    CCTerm mEqualEdge;
    CCTerm mRepStar;
    CCTerm mRep;
    CCTerm mOldRep;
    CCEquality mReasonLiteral;
    int mMergeTime = Integer.MAX_VALUE;
    CCParentInfo mCCPars;
    SimpleList<CCTerm> mMembers;
    int mNumMembers;
    SimpleList<CCTermPairHash.Info.Entry> mPairInfos;
    SharedTerm mSharedTerm;
    SharedTerm mFlatTerm;
    int mHashCode;
    int mModelVal;
    boolean mIsFunc;
    int mParentPosition;

    protected CCTerm(boolean isFunc, int parentPos, SharedTerm term, int hash) {
        this.mIsFunc = isFunc;
        this.mCCPars = null;
        if (isFunc) {
            this.mParentPosition = parentPos;
        }
        this.mCCPars = new CCParentInfo();
        this.mRep = this.mRepStar = this;
        this.mMembers = new SimpleList();
        this.mPairInfos = new SimpleList();
        this.mMembers.append(this);
        this.mNumMembers = 1;
        assert (this.invariant());
        this.mFlatTerm = term;
        this.mHashCode = hash;
    }

    boolean pairHashValid(CClosure engine) {
        return true;
    }

    final boolean invariant() {
        return true;
    }

    public final CCTerm getRepresentative() {
        return this.mRepStar;
    }

    public final boolean isRepresentative() {
        return this.mRep == this;
    }

    public void share(CClosure engine, SharedTerm sterm) {
        if (this.mSharedTerm != null) {
            if (this.mSharedTerm == sterm) {
                return;
            }
            this.propagateSharedEquality(engine, sterm);
        }
        CCTerm term = this;
        SharedTerm oldTerm = this.mSharedTerm;
        this.mSharedTerm = sterm;
        while (term.mRep != term) {
            term = term.mRep;
            if (term.mSharedTerm == oldTerm) {
                term.mSharedTerm = sterm;
                continue;
            }
            term.propagateSharedEquality(engine, sterm);
            break;
        }
    }

    public void unshare(SharedTerm sterm) {
        assert (this.mSharedTerm == sterm);
        assert (this.isRepresentative());
        this.mSharedTerm = null;
    }

    private void propagateSharedEquality(CClosure engine, SharedTerm sterm) {
        EqualityProxy eqForm = this.mSharedTerm.createEquality(sterm);
        assert (eqForm != EqualityProxy.getTrueProxy());
        assert (eqForm != EqualityProxy.getFalseProxy());
        CCEquality cceq = eqForm.createCCEquality(this.mSharedTerm, sterm);
        if (engine.mEngine.getLogger().isDebugEnabled()) {
            engine.mEngine.getLogger().debug("PL: " + cceq);
        }
        engine.addPending(cceq);
    }

    public void invertEqualEdges(CClosure engine) {
        if (this.mEqualEdge == null) {
            return;
        }
        CCTerm last = null;
        CCTerm lastRep = null;
        CCTerm next = this;
        while (next != null) {
            CCTerm t = next;
            next = next.mEqualEdge;
            t.mEqualEdge = last;
            CCTerm nextRep = t.mOldRep;
            t.mOldRep = lastRep;
            last = t;
            lastRep = nextRep;
        }
    }

    public Clause merge(CClosure engine, CCTerm lhs, CCEquality reason) {
        Clause res;
        assert (reason != null || this instanceof CCAppTerm && lhs instanceof CCAppTerm);
        assert (engine.mMergeDepth == engine.mMerges.size());
        CCTerm src = lhs.mRepStar;
        CCTerm dest = this.mRepStar;
        assert (src.invariant());
        assert (src.pairHashValid(engine));
        assert (dest.invariant());
        assert (dest.pairHashValid(engine));
        if (src == dest) {
            return null;
        }
        engine.incMergeCount();
        if (src.mNumMembers > dest.mNumMembers) {
            res = lhs.mergeInternal(engine, this, reason);
            if (res == null && reason == null) {
                ((CCAppTerm)this).markParentInfos();
            }
        } else {
            res = this.mergeInternal(engine, lhs, reason);
            if (res == null && reason == null) {
                ((CCAppTerm)lhs).markParentInfos();
            }
        }
        assert (engine.mMergeDepth == engine.mMerges.size());
        assert (this.invariant());
        assert (lhs.invariant());
        assert (this.mRepStar.pairHashValid(engine));
        return res;
    }

    private Clause mergeInternal(CClosure engine, CCTerm lhs, CCEquality reason) {
        CCAppTerm t;
        CCParentInfo destParentInfo;
        CCParentInfo srcParentInfo;
        CCTerm src = lhs.mRepStar;
        CCTerm dest = this.mRepStar;
        CCEquality diseq = null;
        CCTermPairHash.Info diseqInfo = engine.mPairHash.getInfo(src, dest);
        if (diseqInfo != null) {
            diseq = diseqInfo.mDiseq;
        }
        boolean sharedTermConflict = false;
        if (diseq == null && src.mSharedTerm != null) {
            if (dest.mSharedTerm == null) {
                dest.mSharedTerm = src.mSharedTerm;
            } else {
                EqualityProxy form = src.mSharedTerm.createEquality(dest.mSharedTerm);
                if (form == EqualityProxy.getFalseProxy()) {
                    sharedTermConflict = true;
                } else {
                    form.createCCEquality(src.mSharedTerm, dest.mSharedTerm);
                }
            }
        }
        lhs.invertEqualEdges(engine);
        lhs.mEqualEdge = this;
        lhs.mOldRep = src;
        src.mReasonLiteral = reason;
        if (sharedTermConflict || diseq != null) {
            Clause conflict = sharedTermConflict ? engine.computeCycle(src.mSharedTerm.getCCTerm(), dest.mSharedTerm.getCCTerm()) : engine.computeCycle(diseq);
            lhs.mEqualEdge = null;
            lhs.mOldRep = null;
            src.mReasonLiteral = null;
            return conflict;
        }
        assert (engine.mMergeDepth == engine.mMerges.size());
        src.mMergeTime = ++engine.mMergeDepth;
        engine.mMerges.push(lhs);
        engine.mEngine.getLogger().debug(new DebugMessage("M {0} {1}", this, lhs));
        assert (engine.mMerges.size() == engine.mMergeDepth);
        src.mRep = dest;
        for (CCTerm t2 : src.mMembers) {
            t2.mRepStar = dest;
        }
        dest.mMembers.joinList(src.mMembers);
        dest.mNumMembers += src.mNumMembers;
        for (CCTermPairHash.Info.Entry pentry : src.mPairInfos) {
            CCTermPairHash.Info info = pentry.getInfo();
            assert (pentry.getOtherEntry().mOther == src);
            CCTerm other = pentry.mOther;
            assert (other.mRepStar == other);
            if (other == dest) {
                assert (info.mDiseq == null);
                for (CCEquality.Entry eq : info.mEqlits) {
                    engine.addPending(eq.getCCEquality());
                }
            } else {
                CCTermPairHash.Info destInfo = engine.mPairHash.getInfo(dest, other);
                if (destInfo == null) {
                    destInfo = new CCTermPairHash.Info(dest, other);
                    engine.mPairHash.add(destInfo);
                }
                if (destInfo.mDiseq == null && info.mDiseq != null) {
                    destInfo.mDiseq = info.mDiseq;
                    for (CCEquality.Entry eq : destInfo.mEqlits) {
                        assert (eq.getCCEquality().getDecideStatus() != eq.getCCEquality());
                        if (eq.getCCEquality().getDecideStatus() != null) continue;
                        eq.getCCEquality().mDiseqReason = info.mDiseq;
                        engine.addPending(eq.getCCEquality().negate());
                    }
                } else if (destInfo.mDiseq != null && info.mDiseq == null) {
                    for (CCEquality.Entry eq : info.mEqlits) {
                        assert (eq.getCCEquality().getDecideStatus() != eq.getCCEquality());
                        if (eq.getCCEquality().getDecideStatus() != null) continue;
                        eq.getCCEquality().mDiseqReason = destInfo.mDiseq;
                        engine.addPending(eq.getCCEquality().negate());
                    }
                }
                destInfo.mEqlits.joinList(info.mEqlits);
            }
            pentry.getOtherEntry().unlink();
            assert (other.mPairInfos.wellformed());
            engine.mPairHash.remove(info);
        }
        if (this.mIsFunc) {
            srcParentInfo = src.mCCPars.mNext;
            destParentInfo = dest.mCCPars.mNext;
            if (srcParentInfo != null) {
                assert (srcParentInfo.mFuncSymbNr == destParentInfo.mFuncSymbNr);
                block5: for (CCAppTerm.Parent t1 : srcParentInfo.mCCParents) {
                    if (t1.isMarked()) continue;
                    t = t1.getData();
                    for (CCAppTerm.Parent u1 : destParentInfo.mCCParents) {
                        if (u1.isMarked()) continue;
                        engine.incCcCount();
                        if (t.mArg.mRepStar != u1.getData().mArg.mRepStar) continue;
                        engine.addPendingCongruence(t, u1.getData());
                        continue block5;
                    }
                }
                destParentInfo.mCCParents.joinList(srcParentInfo.mCCParents);
            }
        } else {
            srcParentInfo = src.mCCPars.mNext;
            destParentInfo = dest.mCCPars.mNext;
            while (srcParentInfo != null && destParentInfo != null) {
                if (srcParentInfo.mFuncSymbNr < destParentInfo.mFuncSymbNr) {
                    srcParentInfo = srcParentInfo.mNext;
                    continue;
                }
                if (srcParentInfo.mFuncSymbNr > destParentInfo.mFuncSymbNr) {
                    destParentInfo = destParentInfo.mNext;
                    continue;
                }
                assert (srcParentInfo.mFuncSymbNr == destParentInfo.mFuncSymbNr);
                block8: for (CCAppTerm.Parent t1 : srcParentInfo.mCCParents) {
                    if (t1.isMarked()) continue;
                    t = t1.getData();
                    for (CCAppTerm.Parent u1 : destParentInfo.mCCParents) {
                        if (u1.isMarked()) continue;
                        engine.incCcCount();
                        if (t.mFunc.mRepStar != u1.getData().mFunc.mRepStar) continue;
                        engine.addPendingCongruence(t, u1.getData());
                        continue block8;
                    }
                }
                srcParentInfo = srcParentInfo.mNext;
                destParentInfo = destParentInfo.mNext;
            }
            dest.mCCPars.mergeParentInfo(src.mCCPars);
        }
        assert (this.invariant());
        assert (lhs.invariant());
        assert (src.invariant());
        assert (dest.invariant());
        return null;
    }

    public void undoMerge(CClosure engine, CCTerm lhs) {
        engine.mEngine.getLogger().debug(new DebugMessage("U {0} {1}", lhs, this));
        assert (this.invariant());
        assert (lhs.invariant());
        assert (this.mRepStar.pairHashValid(engine));
        assert (this.mEqualEdge == lhs);
        assert (this.mRepStar == lhs.mRepStar);
        CCTerm src = this.mOldRep;
        this.mEqualEdge = null;
        this.mOldRep = null;
        CCTerm dest = this.mRepStar;
        dest.mCCPars.unmergeParentInfo(src.mCCPars);
        if (src.mReasonLiteral == null) {
            ((CCAppTerm)this).unmarkParentInfos();
        }
        src.mReasonLiteral = null;
        for (CCTermPairHash.Info.Entry pentry : src.mPairInfos.reverse()) {
            CCTermPairHash.Info destInfo;
            CCTermPairHash.Info info = pentry.getInfo();
            assert (pentry.getOtherEntry().mOther == src);
            engine.mPairHash.add(pentry.getInfo());
            assert (pentry.mOther.mPairInfos.wellformed());
            pentry.mOther.mPairInfos.append(pentry.getOtherEntry());
            assert (pentry.mOther.mPairInfos.wellformed());
            CCTerm other = pentry.mOther;
            assert (other.mRepStar == other);
            if (other == dest || (destInfo = engine.mPairHash.getInfo(dest, other)) == null) continue;
            assert (destInfo.mEqlits.wellformed());
            destInfo.mEqlits.unjoinList(info.mEqlits);
            assert (info.mEqlits.wellformed() && destInfo.mEqlits.wellformed());
            if (destInfo.mDiseq == info.mDiseq) {
                destInfo.mDiseq = null;
            }
            if (destInfo.mDiseq != null || !destInfo.mEqlits.isEmpty()) continue;
            destInfo.mLhsEntry.unlink();
            destInfo.mRhsEntry.unlink();
            engine.mPairHash.remove(destInfo);
        }
        dest.mNumMembers -= src.mNumMembers;
        dest.mMembers.unjoinList(src.mMembers);
        for (CCTerm t : src.mMembers) {
            t.mRepStar = src;
        }
        src.mRep = src;
        assert (src.mMergeTime == engine.mMergeDepth);
        --engine.mMergeDepth;
        assert (engine.mMergeDepth == engine.mMerges.size());
        src.mMergeTime = Integer.MAX_VALUE;
        if (dest.mSharedTerm == src.mSharedTerm) {
            dest.mSharedTerm = null;
        }
        assert (this.invariant());
        assert (lhs.invariant());
        assert (src.invariant());
        assert (dest.invariant());
        assert (src.pairHashValid(engine));
        assert (dest.pairHashValid(engine));
    }

    public SharedTerm getSharedTerm() {
        return this.mSharedTerm;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public SharedTerm getFlatTerm() {
        return this.mFlatTerm;
    }

    public abstract Term toSMTTerm(Theory var1, boolean var2);

    public Term toSMTTerm(Theory t) {
        return this.toSMTTerm(t, false);
    }

    static class CongruenceInfo {
        CCAppTerm mAppTerm1;
        CCAppTerm mAppTerm2;
        boolean mMerged;
        CongruenceInfo mNext;

        public CongruenceInfo(CCAppTerm app1, CCAppTerm app2, CongruenceInfo next) {
            this.mAppTerm1 = app1;
            this.mAppTerm2 = app2;
            this.mNext = next;
        }
    }

    static class TermPairMergeInfo {
        CCTermPairHash.Info.Entry mInfo;
        TermPairMergeInfo mNext;

        public TermPairMergeInfo(CCTermPairHash.Info.Entry i, TermPairMergeInfo n) {
            this.mInfo = i;
            this.mNext = n;
        }
    }
}

