/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.util.UnifyHash;

public final class CongruenceBlockPair {
    private static UnifyHash<CongruenceBlockPair> g_unifier;
    private final CCTerm mFunc;
    private final CCTerm mArg;

    public static CongruenceBlockPair getRootPair(CCAppTerm t) {
        return CongruenceBlockPair.getPair(t.mFunc.mRepStar, t.mArg.mRepStar);
    }

    public static CongruenceBlockPair getPair(CCAppTerm t) {
        return CongruenceBlockPair.getPair(t.mFunc, t.mArg);
    }

    public static CongruenceBlockPair getPair(CCTerm func, CCTerm arg) {
        int hash = CongruenceBlockPair.hash(func, arg);
        if (g_unifier == null) {
            g_unifier = new UnifyHash();
        } else {
            for (CongruenceBlockPair p : g_unifier.iterateHashCode(hash)) {
                if (!p.equals(func, arg)) continue;
                return p;
            }
        }
        CongruenceBlockPair res = new CongruenceBlockPair(func, arg);
        g_unifier.put(hash, res);
        return res;
    }

    private static int hash(CCTerm t1, CCTerm t2) {
        return t1.hashCode() + 9337 * t2.hashCode();
    }

    private CongruenceBlockPair(CCTerm func, CCTerm arg) {
        this.mFunc = func;
        this.mArg = arg;
    }

    public int hashCode() {
        return CongruenceBlockPair.hash(this.mFunc, this.mArg);
    }

    public boolean equals(Object o) {
        if (o instanceof CongruenceBlockPair) {
            CongruenceBlockPair p = (CongruenceBlockPair)o;
            return p.equals(p.mFunc, p.mArg);
        }
        return false;
    }

    public boolean equals(CCTerm func, CCTerm arg) {
        return this.mFunc == func && this.mArg == arg;
    }

    public CongruenceBlockPair getRoot() {
        return CongruenceBlockPair.getPair(this.mFunc.mRepStar, this.mArg.mRepStar);
    }
}

