/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import java.util.Map;

public class CompositeReason
extends LAReason {
    private final LAReason[] mReasons;
    private final Rational[] mCoeffs;
    private final InfinitNumber mExactBound;

    public CompositeReason(LinVar var, InfinitNumber bound, boolean isUpper, LAReason[] reasons, Rational[] coeffs, LiteralReason lastLiteral) {
        super(var, bound, isUpper, lastLiteral);
        assert (lastLiteral != null);
        this.mReasons = reasons;
        this.mCoeffs = coeffs;
        this.mExactBound = bound;
        this.mBound = var.mIsInt ? (isUpper ? bound.floor() : bound.ceil()) : bound;
        assert (!this.getVar().mIsInt || this.mBound.isIntegral());
    }

    public InfinitNumber getExactBound() {
        return this.mExactBound;
    }

    InfinitNumber explain(Explainer explainer, InfinitNumber slack, Rational factor) {
        InfinitNumber diff;
        BoundConstraint nextBound;
        Map.Entry<InfinitNumber, BoundConstraint> nextEntry;
        boolean needToExplain = false;
        if (this.isUpper()) {
            nextEntry = this.getVar().mConstraints.ceilingEntry(this.getBound());
            if (nextEntry != null) {
                nextBound = nextEntry.getValue();
                if (nextBound.getDecideStatus() == nextBound && explainer.canExplainWith(nextBound)) {
                    diff = nextBound.getBound().sub(this.getBound());
                    if (slack.compareTo(diff) > 0) {
                        explainer.addLiteral(nextBound.negate(), factor);
                        return slack.sub(diff);
                    }
                } else {
                    needToExplain = true;
                }
            }
        } else {
            nextEntry = this.getVar().mConstraints.lowerEntry(this.getBound());
            if (nextEntry != null) {
                nextBound = nextEntry.getValue();
                if (nextBound.getDecideStatus() == nextBound.negate() && explainer.canExplainWith(nextBound)) {
                    diff = this.getBound().sub(nextBound.getInverseBound());
                    if (slack.compareTo(diff) > 0) {
                        explainer.addLiteral(nextBound, factor);
                        return slack.sub(diff);
                    }
                } else {
                    needToExplain = true;
                }
            }
        }
        InfinitNumber diff2 = !this.getVar().mIsInt ? InfinitNumber.ZERO : (this.isUpper() ? this.mExactBound.sub(this.getBound()) : this.getBound().sub(this.mExactBound));
        int decideLevel = explainer.getDecideLevel();
        if (needToExplain || slack.compareTo(diff2) > 0 && this.getLastLiteral().getDecideLevel() >= decideLevel) {
            boolean enoughSlack;
            boolean bl = enoughSlack = slack.compareTo(diff2) > 0;
            if (!enoughSlack) {
                explainer.addAnnotation(this, factor);
                return slack;
            }
            slack = slack.sub(diff2);
            assert (slack.compareTo(InfinitNumber.ZERO) > 0);
            for (int i = 0; i < this.mReasons.length; ++i) {
                Rational coeff = this.mCoeffs[i];
                slack = slack.div(coeff.abs());
                slack = this.mReasons[i].explain(explainer, slack, factor.mul(coeff));
                slack = slack.mul(coeff.abs());
                assert (slack.compareTo(InfinitNumber.ZERO) > 0);
            }
            return slack;
        }
        Literal lit = explainer.createComposite(this);
        assert (lit.getAtom().getDecideStatus() == lit);
        explainer.addLiteral(lit.negate(), factor);
        return slack;
    }
}

