/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CutCreator {
    LinArSolve mSolver;
    Row[] mURows;
    Column[] mAColumns;

    private int compare(LinVar v1, LinVar v2) {
        return v1.mMatrixpos - v2.mMatrixpos;
    }

    public void computeMatrix(LinArSolve solver) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class LinVarBigInt
        implements Comparable<LinVarBigInt> {
            LinVar mRow;
            BigInteger mCoeff;

            public LinVarBigInt(LinVar r, BigInteger c) {
                this.mRow = r;
                this.mCoeff = c;
            }

            void addToMap(Map<LinVar, Collection<LinVarBigInt>> map, LinVar lv) {
                Collection<LinVarBigInt> column = map.get(lv);
                if (column == null) {
                    column = new TreeSet<LinVarBigInt>();
                    map.put(lv, column);
                }
                column.add(this);
            }

            @Override
            public int compareTo(LinVarBigInt o) {
                return CutCreator.this.compare(this.mRow, o.mRow);
            }
        }
        TreeMap<LinVar, Collection<LinVarBigInt>> colmap = new TreeMap<LinVar, Collection<LinVarBigInt>>();
        for (LinVar lv : solver.mLinvars) {
            if (lv.mBasic) continue;
            boolean negated = false;
            if (lv.mCurval.lesseq(lv.getLowerBound())) {
                negated = true;
            }
            if (lv.isInitiallyBasic()) {
                for (Map.Entry<LinVar, BigInteger> entry : lv.getLinTerm().entrySet()) {
                    BigInteger value = entry.getValue();
                    if (negated) {
                        value = value.negate();
                    }
                    new LinVarBigInt(lv, value).addToMap(colmap, entry.getKey());
                }
                continue;
            }
            new LinVarBigInt(lv, BigInteger.valueOf(negated ? -1L : 1L)).addToMap(colmap, lv);
        }
        this.mAColumns = new Column[colmap.size()];
        this.mURows = new Row[colmap.size()];
        int i = 0;
        for (Map.Entry e : colmap.entrySet()) {
            Collection list = (Collection)e.getValue();
            LinVar[] indices = new LinVar[list.size()];
            BigInteger[] coeffs = new BigInteger[list.size()];
            int j = 0;
            for (LinVarBigInt ib : list) {
                indices[j] = ib.mRow;
                coeffs[j] = ib.mCoeff;
                assert (j == 0 || this.compare(indices[j - 1], indices[j]) < 0);
                ++j;
            }
            this.mAColumns[i] = new Column(indices, coeffs);
            this.mURows[i] = new Row((LinVar)e.getKey());
            ++i;
        }
    }

    private void mgcdColumn(int nr) {
        BigInteger coeffNr;
        LinVar row = this.mAColumns[nr].mIndices[0];
        for (int i = nr + 1; i < this.mAColumns.length; ++i) {
            if (this.compare(this.mAColumns[i].mIndices[0], row) >= 0) continue;
            row = this.mAColumns[i].mIndices[0];
        }
        boolean isTight = this.isTight(row);
        boolean isFixed = this.isFixed(row);
        int end = this.mAColumns.length;
        while (end > nr + 1) {
            while (this.mAColumns[end - 1].mIndices[0] != row) {
                --end;
            }
            assert (end > nr);
            for (int i = nr; i < end; ++i) {
                Row tr;
                Column tc;
                assert (this.mAColumns[end - 1].mIndices[0] == row);
                if (this.mAColumns[i].mIndices[0] != row) {
                    tc = this.mAColumns[i];
                    this.mAColumns[i] = this.mAColumns[--end];
                    this.mAColumns[end] = tc;
                    tr = this.mURows[i];
                    this.mURows[i] = this.mURows[end];
                    this.mURows[end] = tr;
                }
                while (this.mAColumns[end - 1].mIndices[0] != row) {
                    --end;
                }
                assert (this.mAColumns[nr].mIndices[0] == row);
                assert (this.mAColumns[i].mIndices[0] == row);
                if (!this.mURows[nr].isInt() || this.mURows[i].isInt() && this.mAColumns[nr].mCoeffs[0].abs().compareTo(this.mAColumns[i].mCoeffs[0].abs()) <= 0) continue;
                tc = this.mAColumns[i];
                this.mAColumns[i] = this.mAColumns[nr];
                this.mAColumns[nr] = tc;
                tr = this.mURows[i];
                this.mURows[i] = this.mURows[nr];
                this.mURows[nr] = tr;
            }
            if (this.mAColumns[nr].mCoeffs[0].signum() < 0) {
                this.mAColumns[nr].negate();
                this.mURows[nr].negate();
            }
            coeffNr = this.mAColumns[nr].mCoeffs[0];
            if (!this.mURows[nr].isInt() && !coeffNr.equals(BigInteger.ONE)) {
                this.mURows[nr].divide(coeffNr);
                for (int i = 0; i < this.mAColumns[nr].mCoeffs.length; ++i) {
                    BigInteger gcd = this.mAColumns[nr].mCoeffs[i].gcd(coeffNr);
                    BigInteger factor = coeffNr.divide(gcd);
                    this.multiplyARow(this.mAColumns[nr].mIndices[i], factor);
                    this.mAColumns[nr].mCoeffs[i] = this.mAColumns[nr].mCoeffs[i].divide(coeffNr);
                }
                coeffNr = BigInteger.ONE;
            }
            BigInteger coeffNr2 = coeffNr.shiftRight(1);
            for (int i = nr + 1; i < end; ++i) {
                assert (this.mAColumns[i].mIndices[0] == row);
                BigInteger coeffI = this.mAColumns[i].mCoeffs[0];
                coeffI = coeffI.signum() < 0 ? coeffI.subtract(coeffNr2) : coeffI.add(coeffNr2);
                BigInteger div = coeffI.divide(coeffNr);
                this.mAColumns[i].addmul(this.mAColumns[nr], div.negate());
                assert (this.mAColumns[i].mIndices[0] != row || this.mAColumns[i].mCoeffs[0].abs().compareTo(coeffNr2.abs()) <= 0);
                this.mURows[nr].addmul(this.mURows[i], div);
            }
        }
        if (this.mAColumns[nr].mCoeffs[0].signum() < 0) {
            this.mAColumns[nr].negate();
            this.mURows[nr].negate();
        }
        if ((coeffNr = this.mAColumns[nr].mCoeffs[0]).equals(BigInteger.ONE)) {
            for (int i = 0; i < nr; ++i) {
                int j;
                if (!this.mURows[i].isInt() && this.mURows[nr].isInt()) continue;
                for (j = 0; j < this.mAColumns[i].mIndices.length && this.compare(this.mAColumns[i].mIndices[j], row) < 0; ++j) {
                }
                if (j == this.mAColumns[i].mIndices.length || this.mAColumns[i].mIndices[j] != row) continue;
                assert (this.mAColumns[i].mIndices[j] == row);
                BigInteger div = this.mAColumns[i].mCoeffs[j];
                this.mAColumns[i].addmul(this.mAColumns[nr], div.negate());
                this.mURows[nr].addmul(this.mURows[i], div);
            }
        } else {
            BigInteger limitHalf = coeffNr.shiftRight(1);
            BigInteger limitSmall = coeffNr.shiftRight(5);
            for (int i = 0; i < nr; ++i) {
                int j;
                for (j = 0; j < this.mAColumns[i].mIndices.length && this.compare(this.mAColumns[i].mIndices[j], row) < 0; ++j) {
                }
                if (j == this.mAColumns[i].mIndices.length || this.mAColumns[i].mIndices[j] != row) continue;
                assert (this.mAColumns[i].mIndices[j] == row);
                if (!this.mURows[i].isInt() && this.mURows[nr].isInt()) {
                    isFixed &= this.mURows[i].mFixed;
                    continue;
                }
                BigInteger coeffI = this.mAColumns[i].mCoeffs[j];
                BigInteger[] quorem = coeffI.divideAndRemainder(coeffNr);
                BigInteger quo = quorem[0];
                BigInteger rem = quorem[1];
                if (rem.signum() != 0) {
                    BigInteger limit;
                    int adjust = 0;
                    isFixed &= this.mURows[i].mFixed;
                    if (rem.signum() < 0) {
                        rem = rem.add(coeffNr);
                        adjust = -1;
                    }
                    if (rem.compareTo(limit = this.mURows[i].mFixed || !isTight || !this.mURows[i].mTight ? limitHalf : limitSmall) >= 0) {
                        rem = rem.subtract(coeffNr);
                        ++adjust;
                    }
                    if (adjust != 0) {
                        quo = quo.add(BigInteger.valueOf(adjust));
                    }
                    if (!this.mURows[i].mTight) {
                        isTight = false;
                    } else if (rem.signum() > 0) {
                        isTight &= this.mURows[i].mFixed;
                    }
                }
                if (quo.signum() == 0) continue;
                this.mAColumns[i].addmul(this.mAColumns[nr], quo.negate());
                this.mURows[nr].addmul(this.mURows[i], quo);
            }
        }
        this.mURows[nr].mFixed = isFixed;
        this.mURows[nr].mTight = isTight;
        this.mURows[nr].computeValue();
        assert (nr + 1 == this.mAColumns.length || this.mAColumns[nr + 1].mIndices[0] != row);
    }

    private void multiplyARow(LinVar linVar, BigInteger factor) {
        for (int i = 0; i < this.mAColumns.length; ++i) {
            for (int j = 0; j < this.mAColumns[i].mIndices.length; ++j) {
                if (this.mAColumns[i].mIndices[j] != linVar) continue;
                this.mAColumns[i].mCoeffs[j] = this.mAColumns[i].mCoeffs[j].multiply(factor);
            }
        }
    }

    private boolean isTight(LinVar linVar) {
        return linVar.mCurval.lesseq(linVar.getLowerBound()) || linVar.getUpperBound().lesseq(linVar.mCurval);
    }

    private boolean isFixed(LinVar linVar) {
        return linVar.getLowerBound().equals(linVar.getUpperBound());
    }

    private boolean[] computeBadness() {
        boolean[] isBad = new boolean[this.mAColumns.length];
        for (int i = 0; i < this.mAColumns.length; ++i) {
            if (this.mURows[i].isBad()) {
                isBad[i] = true;
                continue;
            }
            int k = i + 1;
            for (int j = 1; j < this.mAColumns[i].mIndices.length; ++j) {
                while (k < this.mAColumns.length && this.compare(this.mAColumns[k].mIndices[0], this.mAColumns[i].mIndices[j]) < 0) {
                    ++k;
                }
                if (k >= this.mAColumns.length || this.mAColumns[k].mIndices[0] != this.mAColumns[i].mIndices[j]) continue;
                isBad[k] = true;
            }
        }
        return isBad;
    }

    public void generateCut(int row, boolean isTight) {
        assert (this.mURows[row].mIndices[0].mIsInt);
        Literal cut = this.mURows[row].createConstraint();
        if (this.mSolver.mEngine.getLogger().isDebugEnabled()) {
            this.mSolver.mEngine.getLogger().debug((isTight ? "cut on " : "branch on ") + cut);
        }
        this.mSolver.mSuggestions.add(cut);
        if (isTight) {
            ++this.mSolver.mNumCuts;
        } else {
            ++this.mSolver.mNumBranches;
        }
    }

    public CutCreator(LinArSolve solver) {
        this.mSolver = solver;
        solver.calculateSimpVals();
        this.computeMatrix(solver);
    }

    public void generateCuts() {
        int i;
        for (i = 0; i < this.mAColumns.length; ++i) {
            this.mgcdColumn(i);
        }
        if (this.mSolver.mEngine.getLogger().isDebugEnabled()) {
            this.mSolver.mEngine.getLogger().debug("Cuts From Proofs");
            this.mSolver.mEngine.getLogger().debug("cols");
            for (i = 0; i < this.mAColumns.length; ++i) {
                if (this.mAColumns[i].mCoeffs.length == 1 && this.mAColumns[i].mCoeffs[0].equals(BigInteger.ONE)) continue;
                this.mSolver.mEngine.getLogger().debug("[" + i + "] " + this.mAColumns[i]);
            }
            this.mSolver.mEngine.getLogger().debug("rows");
            for (i = 0; i < this.mURows.length; ++i) {
                this.mSolver.mEngine.getLogger().debug("[" + i + "] " + this.mURows[i]);
            }
        }
        boolean[] isBad = this.computeBadness();
        int best = -1;
        int bestlen = Integer.MAX_VALUE;
        int bestsize = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < this.mURows.length; ++i2) {
            if (isBad[i2] || !this.mURows[i2].mTight && best >= 0 && this.mURows[best].mTight || this.mURows[i2].mCoeffs.length > bestlen && this.mURows[best].mTight == this.mURows[i2].mTight) continue;
            int max = 0;
            for (BigInteger coeff : this.mURows[i2].mCoeffs) {
                max = Math.max(max, coeff.bitLength());
            }
            if (max >= bestsize && this.mURows[i2].mCoeffs.length == bestlen && this.mURows[best].mTight == this.mURows[i2].mTight) continue;
            best = i2;
            bestsize = max;
            bestlen = this.mURows[i2].mCoeffs.length;
        }
        this.generateCut(best, this.mURows[best].mTight);
    }

    public class Row {
        LinVar[] mIndices;
        BigInteger[] mCoeffs;
        boolean mIsInt;
        boolean mTight;
        boolean mFixed;
        Rational mCurval;
        Rational mEpsilons;

        public Row(LinVar nonbasic) {
            assert (!nonbasic.isInitiallyBasic());
            this.mIsInt = nonbasic.mIsInt;
            if (this.mIsInt) {
                this.mIndices = new LinVar[]{nonbasic};
                this.mCoeffs = new BigInteger[]{BigInteger.ONE};
            } else {
                this.mIndices = new LinVar[0];
                this.mCoeffs = new BigInteger[0];
            }
        }

        public boolean isInt() {
            return this.mIsInt;
        }

        public void negate() {
            for (int i = 0; i < this.mCoeffs.length; ++i) {
                this.mCoeffs[i] = this.mCoeffs[i].negate();
            }
        }

        public void addmul(Row other, BigInteger factor) {
            if (!this.isInt()) {
                return;
            }
            assert (other.isInt());
            LinVar[] newIndices = new LinVar[this.mIndices.length + other.mIndices.length];
            BigInteger[] newCoeffs = new BigInteger[newIndices.length];
            int idx = 0;
            int oidx = 0;
            int newidx = 0;
            while (idx < this.mIndices.length && oidx < other.mIndices.length) {
                if (this.mIndices[idx] == other.mIndices[oidx]) {
                    BigInteger newcoeff = this.mCoeffs[idx].add(other.mCoeffs[oidx].multiply(factor));
                    if (newcoeff.signum() != 0) {
                        newIndices[newidx] = this.mIndices[idx];
                        newCoeffs[newidx] = newcoeff;
                        ++newidx;
                    }
                    ++idx;
                    ++oidx;
                    continue;
                }
                if (CutCreator.this.compare(this.mIndices[idx], other.mIndices[oidx]) < 0) {
                    newIndices[newidx] = this.mIndices[idx];
                    newCoeffs[newidx] = this.mCoeffs[idx];
                    ++newidx;
                    ++idx;
                    continue;
                }
                newIndices[newidx] = other.mIndices[oidx];
                newCoeffs[newidx] = other.mCoeffs[oidx].multiply(factor);
                ++newidx;
                ++oidx;
            }
            while (idx < this.mIndices.length) {
                newIndices[newidx] = this.mIndices[idx];
                newCoeffs[newidx] = this.mCoeffs[idx];
                ++newidx;
                ++idx;
            }
            while (oidx < other.mIndices.length) {
                newIndices[newidx] = other.mIndices[oidx];
                newCoeffs[newidx] = other.mCoeffs[oidx].multiply(factor);
                ++newidx;
                ++oidx;
            }
            assert (newidx > 0);
            if (newidx < newCoeffs.length) {
                this.mIndices = new LinVar[newidx];
                this.mCoeffs = new BigInteger[newidx];
                System.arraycopy(newIndices, 0, this.mIndices, 0, newidx);
                System.arraycopy(newCoeffs, 0, this.mCoeffs, 0, newidx);
            } else {
                this.mIndices = newIndices;
                this.mCoeffs = newCoeffs;
            }
        }

        public String getVar() {
            StringBuilder sb = new StringBuilder();
            String plus = "";
            for (int i = 0; i < this.mIndices.length; ++i) {
                sb.append(plus).append(this.mCoeffs[i]).append(" * (").append(this.mIndices[i]).append(')');
                plus = " + ";
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getVar());
            sb.append(" == ").append(this.mCurval);
            sb.append(" + ").append(this.mEpsilons).append(" eps");
            return sb.toString();
        }

        public Literal createConstraint() {
            assert (this.mIsInt);
            MutableAffinTerm mat = new MutableAffinTerm();
            int maxlevel = 0;
            for (int i = 0; i < this.mIndices.length; ++i) {
                if (maxlevel < this.mIndices[i].mAssertionstacklevel) {
                    maxlevel = this.mIndices[i].mAssertionstacklevel;
                }
                mat.add(Rational.valueOf(this.mCoeffs[i], BigInteger.ONE), this.mIndices[i]);
            }
            mat.add(new InfinitNumber(this.mCurval, this.mEpsilons.signum()).floor().negate());
            return CutCreator.this.mSolver.generateConstraint(mat, false, maxlevel);
        }

        public void computeValue() {
            this.mCurval = Rational.ZERO;
            this.mEpsilons = Rational.ZERO;
            for (int i = 0; i < this.mIndices.length; ++i) {
                LinVar var = this.mIndices[i];
                Rational coeff = Rational.valueOf(this.mCoeffs[i], BigInteger.ONE);
                this.mCurval = this.mCurval.addmul(coeff, var.mCurval.mA);
                this.mEpsilons = this.mEpsilons.addmul(coeff, var.computeEpsilon());
            }
        }

        public boolean isBad() {
            if (!this.mIsInt) {
                return true;
            }
            return this.mCurval.isIntegral() && this.mEpsilons.signum() == 0;
        }

        public void divide(BigInteger denom) {
            assert (!this.mIsInt);
        }
    }

    public class Column {
        LinVar[] mIndices;
        BigInteger[] mCoeffs;

        public Column(LinVar[] indices, BigInteger[] coeffs) {
            this.mIndices = indices;
            this.mCoeffs = coeffs;
        }

        public void negate() {
            for (int i = 0; i < this.mCoeffs.length; ++i) {
                this.mCoeffs[i] = this.mCoeffs[i].negate();
            }
        }

        public void addmul(Column other, BigInteger factor) {
            LinVar[] newIndices = new LinVar[this.mIndices.length + other.mIndices.length];
            BigInteger[] newCoeffs = new BigInteger[newIndices.length];
            int idx = 0;
            int oidx = 0;
            int newidx = 0;
            while (idx < this.mIndices.length && oidx < other.mIndices.length) {
                if (this.mIndices[idx] == other.mIndices[oidx]) {
                    BigInteger newcoeff = this.mCoeffs[idx].add(other.mCoeffs[oidx].multiply(factor));
                    if (newcoeff.signum() != 0) {
                        newIndices[newidx] = this.mIndices[idx];
                        newCoeffs[newidx] = newcoeff;
                        ++newidx;
                    }
                    ++idx;
                    ++oidx;
                    continue;
                }
                if (CutCreator.this.compare(this.mIndices[idx], other.mIndices[oidx]) < 0) {
                    newIndices[newidx] = this.mIndices[idx];
                    newCoeffs[newidx] = this.mCoeffs[idx];
                    ++newidx;
                    ++idx;
                    continue;
                }
                newIndices[newidx] = other.mIndices[oidx];
                newCoeffs[newidx] = other.mCoeffs[oidx].multiply(factor);
                ++newidx;
                ++oidx;
            }
            while (idx < this.mIndices.length) {
                newIndices[newidx] = this.mIndices[idx];
                newCoeffs[newidx] = this.mCoeffs[idx];
                ++newidx;
                ++idx;
            }
            while (oidx < other.mIndices.length) {
                newIndices[newidx] = other.mIndices[oidx];
                newCoeffs[newidx] = other.mCoeffs[oidx].multiply(factor);
                ++newidx;
                ++oidx;
            }
            assert (newidx > 0);
            if (newidx < newCoeffs.length) {
                this.mIndices = new LinVar[newidx];
                this.mCoeffs = new BigInteger[newidx];
                System.arraycopy(newIndices, 0, this.mIndices, 0, newidx);
                System.arraycopy(newCoeffs, 0, this.mCoeffs, 0, newidx);
            } else {
                this.mIndices = newIndices;
                this.mCoeffs = newCoeffs;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String plus = "";
            for (int i = 0; i < this.mIndices.length; ++i) {
                sb.append(plus).append(this.mIndices[i].mMatrixpos).append(": ").append(this.mCoeffs[i]);
                plus = ", ";
            }
            return sb.toString();
        }
    }
}

