/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CompositeReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;

public class Explainer {
    private final LinArSolve mSolver;
    private final Map<LAReason, LAAnnotation> mSubReasons;
    private final Literal mExplainedLiteral;
    private final ArrayDeque<LAAnnotation> mAnnotationStack;

    public Explainer(LinArSolve solver, boolean generateProofTree, Literal explainedLiteral) {
        this.mSolver = solver;
        this.mExplainedLiteral = explainedLiteral;
        this.mSubReasons = new HashMap<LAReason, LAAnnotation>();
        this.mAnnotationStack = new ArrayDeque();
        this.mAnnotationStack.add(new LAAnnotation());
    }

    public boolean canExplainWith(Literal lit) {
        DPLLAtom atom = lit.getAtom();
        return atom.getStackPosition() >= 0 && (this.mExplainedLiteral == null || this.mExplainedLiteral.getAtom().getStackPosition() == -1 || atom.getStackPosition() < this.mExplainedLiteral.getAtom().getStackPosition());
    }

    public void addAnnotation(LAReason reason, Rational coeff) {
        assert (coeff.signum() > 0 == reason.isUpper());
        Rational sign = Rational.valueOf(coeff.signum(), 1L);
        LAAnnotation annot = this.mSubReasons.get(reason);
        if (annot == null) {
            annot = new LAAnnotation(reason);
            this.mSubReasons.put(reason, annot);
            if (this.mAnnotationStack != null) {
                this.mAnnotationStack.addLast(annot);
            }
            reason.explain(this, reason.getVar().getEpsilon(), sign);
            if (this.mAnnotationStack != null) {
                this.mAnnotationStack.removeLast();
            }
        }
        if (this.mAnnotationStack != null) {
            this.mAnnotationStack.getLast().addFarkas(annot, coeff);
        }
    }

    public void addEQAnnotation(LiteralReason reason, Rational coeff) {
        assert (coeff.signum() > 0 == reason.isUpper());
        Rational sign = Rational.valueOf(coeff.signum(), 1L);
        LAAnnotation annot = this.mSubReasons.get(reason);
        if (annot == null) {
            annot = new LAAnnotation(reason);
            this.mSubReasons.put(reason, annot);
            this.mAnnotationStack.addLast(annot);
            if (reason.getOldReason() instanceof LiteralReason) {
                reason.getOldReason().explain(this, reason.getVar().getEpsilon(), sign);
            } else {
                this.addAnnotation(reason.getOldReason(), sign);
            }
            this.addLiteral(reason.getLiteral().negate(), sign);
            this.mAnnotationStack.removeLast();
        }
        this.mAnnotationStack.getLast().addFarkas(annot, coeff);
    }

    public void addLiteral(Literal lit, Rational coeff) {
        if (this.mAnnotationStack != null) {
            this.mAnnotationStack.getLast().addFarkas(lit, coeff);
        }
    }

    private boolean validClause() {
        if (this.mAnnotationStack == null) {
            return true;
        }
        assert (this.mAnnotationStack.size() == 1);
        MutableAffinTerm mat = this.mAnnotationStack.getFirst().addLiterals();
        assert (mat.isConstant() && InfinitNumber.ZERO.less(mat.getConstant()));
        for (Map.Entry<LAReason, LAAnnotation> reasonEntry : this.mSubReasons.entrySet()) {
            LAReason reason = reasonEntry.getKey();
            mat = reasonEntry.getValue().addLiterals();
            Rational coeff = reason.isUpper() ? Rational.MONE : Rational.ONE;
            mat.add(coeff, reason.getVar());
            mat.add(reason.getBound().mul(coeff.negate()));
            mat.add(reason.getVar().getEpsilon());
            assert (mat.isConstant() && InfinitNumber.ZERO.less(mat.getConstant()));
        }
        return true;
    }

    public Clause createClause(DPLLEngine engine) {
        assert (this.mAnnotationStack.size() == 1);
        LAAnnotation baseAnnotation = this.mAnnotationStack.getLast();
        Literal[] lits = baseAnnotation.collectLiterals();
        Clause clause = new Clause(lits);
        if (engine.isProofGenerationEnabled()) {
            clause.setProof(new LeafNode(-4, baseAnnotation));
        }
        assert (this.validClause());
        return clause;
    }

    public int getDecideLevel() {
        return this.mExplainedLiteral == null ? this.mSolver.mEngine.getDecideLevel() : this.mExplainedLiteral.getAtom().getDecideLevel();
    }

    public Literal createComposite(CompositeReason reason) {
        return this.mSolver.createCompositeLiteral(reason, this.mExplainedLiteral);
    }
}

