/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.AnnotationToProofTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LAAnnotation
implements IAnnotation {
    private Map<Literal, Rational> mCoefficients = new HashMap<Literal, Rational>();
    private Map<LAAnnotation, Rational> mAuxAnnotations = new HashMap<LAAnnotation, Rational>();
    private LinVar mLinvar;
    private InfinitNumber mBound;
    private boolean mIsUpper;

    public LAAnnotation() {
    }

    public LAAnnotation(LAReason reason) {
        this();
        this.mLinvar = reason.getVar();
        this.mBound = reason.getBound();
        this.mIsUpper = reason.isUpper();
    }

    public Map<Literal, Rational> getCoefficients() {
        return this.mCoefficients;
    }

    public Map<LAAnnotation, Rational> getAuxAnnotations() {
        return this.mAuxAnnotations;
    }

    public void addFarkas(LAAnnotation annot, Rational coeff) {
        Rational r = this.mAuxAnnotations.get(annot);
        if (r == null) {
            r = Rational.ZERO;
        }
        assert (r.signum() * coeff.signum() >= 0);
        r = r.add(coeff);
        this.mAuxAnnotations.put(annot, r);
    }

    public void addFarkas(Literal lit, Rational coeff) {
        Rational r = this.mCoefficients.get(lit);
        if (r == null) {
            r = Rational.ZERO;
        }
        assert (lit.getAtom() instanceof LAEquality || r.signum() * coeff.signum() >= 0);
        if ((r = r.add(coeff)) == Rational.ZERO) {
            this.mCoefficients.remove(lit);
        } else {
            this.mCoefficients.put(lit, r);
        }
    }

    MutableAffinTerm addLiterals() {
        Rational coeff;
        MutableAffinTerm mat = new MutableAffinTerm();
        for (Map.Entry<Literal, Rational> entry : this.mCoefficients.entrySet()) {
            coeff = entry.getValue();
            Literal lit = entry.getKey();
            if (lit.getAtom() instanceof BoundConstraint) {
                BoundConstraint bc = (BoundConstraint)lit.getAtom();
                InfinitNumber bound = bc.getBound();
                assert (coeff.signum() > 0 == (bc != lit));
                if (bc == lit) {
                    bound = bc.getInverseBound();
                }
                mat.add(coeff, bc.getVar());
                mat.add(bound.mul(coeff.negate()));
                continue;
            }
            LAEquality lasd = (LAEquality)lit.getAtom();
            if (lasd == lit) {
                assert (coeff.abs().equals(Rational.ONE));
                mat.add(lasd.getVar().getEpsilon());
                continue;
            }
            mat.add(coeff, lasd.getVar());
            mat.add(lasd.getBound().mul(coeff.negate()));
        }
        for (Map.Entry<Object, Rational> entry : this.mAuxAnnotations.entrySet()) {
            coeff = entry.getValue();
            LAAnnotation annot = (LAAnnotation)entry.getKey();
            assert (coeff.signum() > 0 == annot.mIsUpper);
            mat.add(coeff, annot.mLinvar);
            mat.add(annot.mBound.mul(coeff.negate()));
        }
        return mat;
    }

    public String toString() {
        return this.mCoefficients.toString() + this.mAuxAnnotations.toString();
    }

    @Override
    public Term toTerm(Clause ignored, Theory theory) {
        assert (this.mCoefficients != null);
        return new AnnotationToProofTerm().convert(this, theory);
    }

    public int hashCode() {
        return this.mLinvar == null ? 0 : HashUtils.hashJenkins(this.mBound.hashCode(), (Object)this.mLinvar);
    }

    public LinVar getLinVar() {
        return this.mLinvar;
    }

    public InfinitNumber getBound() {
        return this.mBound;
    }

    public boolean isUpper() {
        return this.mIsUpper;
    }

    private void collect(HashSet<Literal> lits, HashSet<LAAnnotation> visited) {
        if (visited.add(this)) {
            lits.addAll(this.mCoefficients.keySet());
            for (LAAnnotation annot : this.mAuxAnnotations.keySet()) {
                annot.collect(lits, visited);
            }
        }
    }

    public Literal[] collectLiterals() {
        HashSet<Literal> lits = new HashSet<Literal>();
        this.collect(lits, new HashSet<LAAnnotation>());
        return lits.toArray(new Literal[lits.size()]);
    }
}

