/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.MutableRational;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CompositeReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CutCreator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.EQAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableInfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayMap;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.ScopedHashMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinArSolve
implements ITheory {
    final DPLLEngine mEngine;
    final ArrayList<LinVar> mLinvars;
    final ArrayList<LinVar> mIntVars;
    final Queue<Literal> mProplist;
    final ScopedHashMap<Map<LinVar, Rational>, LinVar> mTerms;
    final TreeSet<LinVar> mOob;
    HashMap<LinVar, TreeMap<LinVar, Rational>> mSimps;
    int mNumPivots;
    int mNumPivotsBland;
    int mNumSwitchToBland;
    long mPivotTime;
    int mCompositeCreateLit;
    int mNumCuts;
    int mNumBranches;
    long mCutGenTime;
    final ScopedArrayList<SharedTerm> mSharedVars = new ScopedArrayList();
    final ArrayDeque<Literal> mSuggestions;
    private long mPropBoundTime;
    private long mPropBoundSetTime;
    private long mBacktrackPropTime;
    private TreeSet<LinVar> mPropBounds;
    private LinVar mConflictVar;
    private Rational mEps;
    private boolean mInCheck = false;
    private int mVarNum = 0;

    public LinArSolve(DPLLEngine engine) {
        this.mEngine = engine;
        this.mLinvars = new ArrayList();
        this.mIntVars = new ArrayList();
        this.mPropBounds = new TreeSet();
        this.mProplist = new ArrayDeque<Literal>();
        this.mSuggestions = new ArrayDeque();
        this.mTerms = new ScopedHashMap();
        this.mOob = new TreeSet();
        this.mSimps = new HashMap();
        this.mNumPivots = 0;
        this.mNumSwitchToBland = 0;
        this.mPivotTime = 0L;
        this.mCompositeCreateLit = 0;
        this.mNumCuts = 0;
        this.mNumBranches = 0;
        this.mCutGenTime = 0L;
    }

    private boolean checkClean() {
        return true;
    }

    private boolean checkColumn(MatrixEntry mentry) {
        LinVar c = mentry.mColumn;
        assert (!c.mBasic);
        assert (c.mHeadEntry.mColumn == c);
        assert (c.mHeadEntry.mRow == LinVar.DUMMY_LINVAR);
        assert (c.mHeadEntry.mNextInRow == null && c.mHeadEntry.mPrevInRow == null);
        boolean seen = false;
        MatrixEntry entry = c.mHeadEntry.mNextInCol;
        while (entry != c.mHeadEntry) {
            assert (entry.mNextInCol.mPrevInCol == entry);
            assert (entry.mPrevInCol.mNextInCol == entry);
            assert (entry.mColumn == c);
            if (mentry == entry) {
                seen = true;
            }
            entry = entry.mNextInCol;
        }
        assert (c.mHeadEntry.mNextInCol.mPrevInCol == c.mHeadEntry);
        assert (c.mHeadEntry.mPrevInCol.mNextInCol == c.mHeadEntry);
        assert (seen);
        return true;
    }

    private boolean checkPostSimplify() {
        if (this.mSimps == null) {
            return true;
        }
        for (LinVar b : this.mLinvars) {
            LinVar nb;
            MatrixEntry entry;
            if (b.mBasic) {
                entry = b.mHeadEntry.mNextInRow;
                while (entry != b.mHeadEntry) {
                    nb = entry.mColumn;
                    assert (!this.mSimps.containsKey(nb)) : "Variable " + b + (b.mBasic ? " [basic]" : " [nonbasic]") + " contains simplified variable!";
                    entry = entry.mNextInRow;
                }
                continue;
            }
            entry = b.mHeadEntry.mNextInCol;
            while (entry != b.mHeadEntry) {
                nb = entry.mRow;
                assert (!this.mSimps.containsKey(nb)) : "Variable " + b + (b.mBasic ? " [basic]" : " [nonbasic]") + " contains simplified variable!";
                entry = entry.mNextInCol;
            }
        }
        return true;
    }

    private boolean checkoobcontent() {
        for (LinVar v : this.mLinvars) {
            assert (!v.outOfBounds() || this.mOob.contains(v)) : "Variable " + v + " is out of bounds: " + v.getLowerBound() + "<=" + v.mCurval + "<=" + v.getUpperBound();
        }
        return true;
    }

    public LinVar addVar(SharedTerm name, boolean isint, int level) {
        if (this.mEngine.getLogger().isDebugEnabled()) {
            this.mEngine.getLogger().debug("Creating var " + name);
        }
        LinVar var = new LinVar(name, isint, level, this.mVarNum++);
        this.mLinvars.add(var);
        if (isint) {
            this.mIntVars.add(var);
        }
        return var;
    }

    public LinVar generateLinVar(TreeMap<LinVar, Rational> factors, int level) {
        if (factors.size() == 1) {
            Map.Entry<LinVar, Rational> me = factors.entrySet().iterator().next();
            assert (me.getValue().equals(Rational.ONE));
            LinVar var = me.getKey();
            this.ensureUnsimplified(var);
            return var;
        }
        LinVar var = this.mTerms.get(factors);
        if (var == null) {
            LinVar[] vars = new LinVar[factors.size()];
            BigInteger[] coeffs = new BigInteger[factors.size()];
            int i = 0;
            TreeMap<LinVar, Rational> curcoeffs = new TreeMap<LinVar, Rational>();
            boolean isInt = true;
            for (Map.Entry<LinVar, Rational> entry : factors.entrySet()) {
                vars[i] = entry.getKey();
                assert (entry.getValue().denominator().equals(BigInteger.ONE));
                coeffs[i] = entry.getValue().numerator();
                this.unsimplifyAndAdd(entry.getKey(), entry.getValue(), curcoeffs);
                isInt &= vars[i].mIsInt;
                ++i;
            }
            ArrayMap<LinVar, BigInteger> intSum = new ArrayMap<LinVar, BigInteger>(vars, coeffs);
            var = new LinVar(new LinTerm(intSum), isInt, level, this.mVarNum++);
            this.insertVar(var, curcoeffs);
            this.mTerms.put(factors, var);
            this.mLinvars.add(var);
            assert (var.checkBrpCounters());
        }
        return var;
    }

    public Literal generateConstraint(MutableAffinTerm at, boolean strict, int level) {
        Rational normFactor = at.getGCD().inverse();
        at.mul(normFactor);
        LinVar var = this.generateLinVar(this.getSummandMap(at), level);
        return this.generateConstraint(var, at.mConstant.mA.negate(), normFactor.isNegative(), strict);
    }

    private final TreeMap<LinVar, Rational> getSummandMap(MutableAffinTerm at) {
        return at.getSummands();
    }

    private void updateVariableValue(LinVar updateVar, InfinitNumber newValue) {
        assert (!updateVar.mBasic);
        InfinitNumber diff = newValue.sub(updateVar.mCurval);
        updateVar.mCurval = newValue;
        MatrixEntry entry = updateVar.mHeadEntry.mNextInCol;
        while (entry != updateVar.mHeadEntry) {
            LinVar var = entry.mRow;
            assert (var.mBasic);
            Rational coeff = Rational.valueOf(entry.mCoeff, var.mHeadEntry.mCoeff.negate());
            var.mCurval = var.mCurval.addmul(diff, coeff);
            assert (var.checkBrpCounters());
            assert (!var.mCurval.mA.denominator().equals(BigInteger.ZERO));
            if (var.outOfBounds()) {
                this.mOob.add(var);
            }
            entry = entry.mNextInCol;
        }
    }

    private Clause updateVariable(LinVar updateVar, boolean isUpper, InfinitNumber oldBound, InfinitNumber newBound) {
        assert (!updateVar.mBasic);
        InfinitNumber diff = newBound.sub(updateVar.mCurval);
        if (diff.signum() > 0 == isUpper) {
            diff = InfinitNumber.ZERO;
        } else {
            updateVar.mCurval = newBound;
        }
        assert (!updateVar.mCurval.mA.denominator().equals(BigInteger.ZERO));
        Clause conflict = null;
        MatrixEntry entry = updateVar.mHeadEntry.mNextInCol;
        while (entry != updateVar.mHeadEntry) {
            LinVar var = entry.mRow;
            assert (var.mBasic);
            Rational coeff = Rational.valueOf(entry.mCoeff, var.mHeadEntry.mCoeff.negate());
            if (diff != InfinitNumber.ZERO) {
                var.mCurval = var.mCurval.addmul(diff, coeff);
            }
            assert (!var.mCurval.mA.denominator().equals(BigInteger.ZERO));
            if (var.outOfBounds()) {
                this.mOob.add(var);
            }
            if (isUpper == entry.mCoeff.signum() < 0) {
                var.updateLower(entry.mCoeff, oldBound, newBound);
                assert (var.checkBrpCounters());
                if (var.mNumLowerInf == 0) {
                    if (conflict == null) {
                        conflict = this.propagateBound(var, false);
                    } else {
                        this.mPropBounds.add(var);
                    }
                }
            } else {
                var.updateUpper(entry.mCoeff, oldBound, newBound);
                assert (var.checkBrpCounters());
                if (var.mNumUpperInf == 0) {
                    if (conflict == null) {
                        conflict = this.propagateBound(var, true);
                    } else {
                        this.mPropBounds.add(var);
                    }
                }
            }
            assert (!var.mBasic || var.checkBrpCounters());
            entry = entry.mNextInCol;
        }
        return conflict;
    }

    private void updatePropagationCountersOnBacktrack(LinVar var, InfinitNumber oldBound, InfinitNumber newBound, boolean upper) {
        MatrixEntry entry = var.mHeadEntry.mNextInCol;
        while (entry != var.mHeadEntry) {
            if (upper == entry.mCoeff.signum() < 0) {
                entry.mRow.updateLower(entry.mCoeff, oldBound, newBound);
            } else {
                entry.mRow.updateUpper(entry.mCoeff, oldBound, newBound);
            }
            assert (entry.mRow.checkBrpCounters());
            entry = entry.mNextInCol;
        }
    }

    public void removeReason(LAReason reason) {
        LAReason chain;
        LinVar var = reason.getVar();
        if (var.mBasic && var.mHeadEntry != null) {
            this.mPropBounds.add(var);
        }
        if (reason.isUpper()) {
            if (var.mUpper == reason) {
                var.mUpper = reason.getOldReason();
                if (!var.mDead) {
                    if (!var.mBasic) {
                        this.updatePropagationCountersOnBacktrack(var, reason.getBound(), var.getUpperBound(), true);
                        if (var.mCurval.less(var.getLowerBound())) {
                            this.updateVariableValue(var, var.getLowerBound());
                        }
                    } else if (var.outOfBounds()) {
                        this.mOob.add(var);
                    }
                }
                return;
            }
            chain = var.mUpper;
        } else {
            if (var.mLower == reason) {
                var.mLower = reason.getOldReason();
                if (!var.mDead) {
                    if (!var.mBasic) {
                        this.updatePropagationCountersOnBacktrack(var, reason.getBound(), var.getLowerBound(), false);
                        if (var.getUpperBound().less(var.mCurval)) {
                            this.updateVariableValue(var, var.getUpperBound());
                        }
                    } else if (var.outOfBounds()) {
                        this.mOob.add(var);
                    }
                }
                return;
            }
            chain = var.mLower;
        }
        while (chain.getOldReason() != reason) {
            chain = chain.getOldReason();
        }
        chain.setOldReason(reason.getOldReason());
    }

    public void removeLiteralReason(LiteralReason reason) {
        for (LAReason depReason : reason.getDependents()) {
            this.removeReason(depReason);
        }
        this.removeReason(reason);
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        LAReason reason;
        InfinitNumber bound;
        LinVar var;
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof LAEquality) {
            LAEquality laeq = (LAEquality)atom;
            var = laeq.getVar();
            bound = new InfinitNumber(laeq.getBound(), 0);
            if (laeq == literal.negate()) {
                var.removeDiseq(laeq);
            }
        } else if (atom instanceof BoundConstraint) {
            BoundConstraint bc = (BoundConstraint)atom;
            var = bc.getVar();
            bound = bc.getBound();
        } else {
            return;
        }
        for (reason = var.mUpper; reason != null && reason.getBound().lesseq(bound); reason = reason.getOldReason()) {
            if (!(reason instanceof LiteralReason) || ((LiteralReason)reason).getLiteral() != literal || reason.getLastLiteral() != reason) continue;
            this.removeLiteralReason((LiteralReason)reason);
            break;
        }
        for (reason = var.mLower; reason != null && bound.lesseq(reason.getBound()); reason = reason.getOldReason()) {
            if (!(reason instanceof LiteralReason) || ((LiteralReason)reason).getLiteral() != literal || reason.getLastLiteral() != reason) continue;
            this.removeLiteralReason((LiteralReason)reason);
            break;
        }
    }

    public Clause checkPendingConflict() {
        LinVar var = this.mConflictVar;
        if (var != null && var.getUpperBound().less(var.getLowerBound())) {
            Explainer explainer = new Explainer(this, this.mEngine.isProofGenerationEnabled(), null);
            InfinitNumber slack = var.getLowerBound().sub(var.getUpperBound());
            slack = var.mUpper.explain(explainer, slack, Rational.ONE);
            slack = var.mLower.explain(explainer, slack, Rational.MONE);
            return explainer.createClause(this.mEngine);
        }
        this.mConflictVar = null;
        return null;
    }

    @Override
    public Clause backtrackComplete() {
        this.mProplist.clear();
        this.mSuggestions.clear();
        Clause conflict = this.checkPendingConflict();
        if (conflict != null) {
            return conflict;
        }
        conflict = this.checkPendingBoundPropagations();
        if (conflict != null) {
            return conflict;
        }
        assert (this.checkClean());
        return this.fixOobs();
    }

    private Clause checkPendingBoundPropagations() {
        while (!this.mPropBounds.isEmpty()) {
            LinVar b = this.mPropBounds.pollFirst();
            if (b.mDead || !b.mBasic) continue;
            assert (b.checkBrpCounters());
            Clause conflict = null;
            if (b.mNumUpperInf == 0) {
                conflict = this.propagateBound(b, true);
            }
            if (b.mNumLowerInf == 0) {
                if (conflict == null) {
                    conflict = this.propagateBound(b, false);
                } else {
                    this.mPropBounds.add(b);
                }
            }
            if (conflict == null) continue;
            return conflict;
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        this.mSuggestions.clear();
        this.mEngine.getLogger().debug("Final Check LA");
        Clause c = this.fixOobs();
        if (c != null) {
            return c;
        }
        c = this.ensureIntegrals();
        if (c != null || !this.mSuggestions.isEmpty() || !this.mProplist.isEmpty()) {
            return c;
        }
        assert (this.mOob.isEmpty());
        this.mutate();
        assert (this.mOob.isEmpty());
        Map<ExactInfinitNumber, List<SharedTerm>> cong = this.getSharedCongruences();
        assert (this.checkClean());
        this.mEngine.getLogger().debug(new DebugMessage("cong: {0}", cong));
        for (LinVar v : this.mLinvars) {
            Literal lit;
            LAEquality ea = v.getDiseq(v.mCurval.mA);
            if (ea == null || (lit = this.ensureDisequality(ea)) == null) continue;
            assert (lit.getAtom().getDecideStatus() == null);
            this.mSuggestions.add(lit);
            this.mEngine.getLogger().debug(new DebugMessage("Using {0} to ensure disequality {1}", lit, ea.negate()));
        }
        if (this.mSuggestions.isEmpty() && this.mProplist.isEmpty()) {
            return this.mbtc(cong);
        }
        assert (this.compositesSatisfied());
        return null;
    }

    private boolean compositesSatisfied() {
        for (LinVar v : this.mLinvars) {
            if (v.mBasic) {
                v.fixEpsilon();
            }
            assert (v.mCurval.lesseq(v.getUpperBound()));
            assert (v.getLowerBound().lesseq(v.mCurval));
        }
        return true;
    }

    @Override
    public Literal getPropagatedLiteral() {
        while (!this.mProplist.isEmpty()) {
            Literal lit = this.mProplist.remove();
            if (lit.getAtom().getDecideStatus() != null) continue;
            return lit;
        }
        return null;
    }

    private Clause createUnitClause(Literal literal, boolean isUpper, InfinitNumber bound, LinVar var) {
        Explainer explainer = new Explainer(this, this.mEngine.isProofGenerationEnabled(), literal);
        if (isUpper) {
            assert (var.getUpperBound().less(bound));
            explainer.addLiteral(literal, Rational.MONE);
            LAReason reason = var.mUpper;
            while (reason.getOldReason() != null && reason.getOldReason().getBound().less(bound)) {
                reason = reason.getOldReason();
            }
            reason.explain(explainer, bound.sub(reason.getBound()), Rational.ONE);
        } else {
            assert (bound.less(var.getLowerBound()));
            explainer.addLiteral(literal, Rational.ONE);
            LAReason reason = var.mLower;
            while (reason.getOldReason() != null && bound.less(reason.getOldReason().getBound())) {
                reason = reason.getOldReason();
            }
            reason.explain(explainer, reason.getBound().sub(bound), Rational.MONE);
        }
        return explainer.createClause(this.mEngine);
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof LAEquality) {
            LAReason upper;
            LAEquality laeq = (LAEquality)atom;
            LinVar var = laeq.getVar();
            if (literal == laeq) {
                InfinitNumber bound = new InfinitNumber(laeq.getBound(), 0);
                LAReason upperReason = var.mUpper;
                while (upperReason.getBound().less(bound)) {
                    upperReason = upperReason.getOldReason();
                }
                LAReason lowerReason = var.mLower;
                while (bound.less(lowerReason.getBound())) {
                    lowerReason = lowerReason.getOldReason();
                }
                assert (upperReason.getBound().equals(bound) && lowerReason.getBound().equals(bound)) : "Bounds on variable do not match propagated equality bound";
                Explainer explainer = new Explainer(this, this.mEngine.isProofGenerationEnabled(), literal);
                LiteralReason uppereq = new LiteralReason(var, var.getUpperBound().sub(var.getEpsilon()), true, laeq.negate());
                uppereq.setOldReason(upperReason);
                lowerReason.explain(explainer, var.getEpsilon(), Rational.MONE);
                explainer.addEQAnnotation(uppereq, Rational.ONE);
                return explainer.createClause(this.mEngine);
            }
            InfinitNumber bound = new InfinitNumber(laeq.getBound(), 0);
            for (upper = var.mUpper; laeq.getStackPosition() >= 0 && upper != null && upper.getLastLiteral().getStackPosition() >= laeq.getStackPosition(); upper = upper.getOldReason()) {
            }
            return this.createUnitClause(literal, upper != null && upper.getBound().less(bound), bound, var);
        }
        if (atom instanceof CCEquality) {
            return this.generateEqualityClause(literal);
        }
        BoundConstraint bc = (BoundConstraint)atom;
        LinVar var = bc.getVar();
        boolean isUpper = literal.getSign() > 0;
        return this.createUnitClause(literal, isUpper, isUpper ? bc.getInverseBound() : bc.getBound(), var);
    }

    private Clause generateEqualityClause(Literal cclit) {
        CCEquality cceq = (CCEquality)cclit.getAtom();
        Literal ea = cceq.getLASharedData();
        if (cceq == cclit) {
            ea = ea.negate();
        }
        return new Clause(new Literal[]{cclit, ea}, new LeafNode(-6, EQAnnotation.EQ));
    }

    private void insertReasonOfNewComposite(LinVar var, Literal lit) {
        boolean isUpper;
        BoundConstraint bc = (BoundConstraint)lit.getAtom();
        boolean bl = isUpper = lit == bc;
        if (isUpper) {
            InfinitNumber bound = bc.getBound();
            LiteralReason reason = new LiteralReason(var, bound, true, lit);
            if (bound.less(var.getExactUpperBound())) {
                reason.setOldReason(var.mUpper);
                var.mUpper = reason;
            } else {
                LAReason thereason = var.mUpper;
                while (thereason.getOldReason().getExactBound().less(bound)) {
                    thereason = thereason.getOldReason();
                }
                assert (thereason.getExactBound().less(bound) && bound.less(thereason.getOldReason().getExactBound()));
                reason.setOldReason(thereason.getOldReason());
                thereason.setOldReason(reason);
            }
            if (var.mBasic && var.outOfBounds()) {
                this.mOob.add(var);
            }
        } else {
            InfinitNumber bound = bc.getInverseBound();
            LiteralReason reason = new LiteralReason(var, bound, false, lit);
            if (var.getExactLowerBound().less(bound)) {
                reason.setOldReason(var.mLower);
                var.mLower = reason;
            } else {
                LAReason thereason = var.mLower;
                while (bound.less(thereason.getOldReason().getExactBound())) {
                    thereason = thereason.getOldReason();
                }
                assert (thereason.getOldReason().getExactBound().less(bound) && bound.less(thereason.getExactBound()));
                reason.setOldReason(thereason.getOldReason());
                thereason.setOldReason(reason);
            }
            if (var.mBasic && var.outOfBounds()) {
                this.mOob.add(var);
            }
        }
    }

    private Clause setBound(LAReason reason) {
        Clause conflict;
        LAEquality ea;
        InfinitNumber oldBound;
        LinVar var = reason.getVar();
        InfinitNumber bound = reason.getBound();
        InfinitNumber epsilon = var.getEpsilon();
        LiteralReason lastLiteral = reason.getLastLiteral();
        if (reason.isUpper()) {
            oldBound = var.getUpperBound();
            assert (reason.getExactBound().less(var.getExactUpperBound()));
            reason.setOldReason(var.mUpper);
            var.mUpper = reason;
            while (bound.mEps == 0 && (ea = var.getDiseq(bound.mA)) != null) {
                bound = bound.sub(epsilon);
                if (ea.getStackPosition() > lastLiteral.getStackPosition()) {
                    lastLiteral = new LiteralReason(var, bound, true, ea.negate());
                    var.mUpper = lastLiteral;
                } else {
                    var.mUpper = new LiteralReason(var, bound, true, ea.negate(), lastLiteral);
                    lastLiteral.addDependent(var.mUpper);
                }
                var.mUpper.setOldReason(reason);
                reason = var.mUpper;
            }
            if (!var.mBasic) {
                conflict = this.updateVariable(var, true, oldBound, bound);
                if (conflict != null) {
                    return conflict;
                }
            } else if (var.outOfBounds()) {
                this.mOob.add(var);
            }
            for (BoundConstraint bc : var.mConstraints.subMap(bound, oldBound).values()) {
                assert (var.getUpperBound().lesseq(bc.getBound()));
                this.mProplist.add(bc);
            }
            for (LAEquality laeq : var.mEqualities.subMap(bound.add(var.getEpsilon()), oldBound.add(var.getEpsilon())).values()) {
                this.mProplist.add(laeq.negate());
            }
        } else {
            oldBound = var.getLowerBound();
            assert (var.getExactLowerBound().less(reason.getExactBound()));
            reason.setOldReason(var.mLower);
            var.mLower = reason;
            while (bound.mEps == 0 && (ea = var.getDiseq(bound.mA)) != null) {
                bound = bound.add(epsilon);
                if (ea.getStackPosition() > lastLiteral.getStackPosition()) {
                    lastLiteral = new LiteralReason(var, bound, false, ea.negate());
                    var.mLower = lastLiteral;
                } else {
                    var.mLower = new LiteralReason(var, bound, false, ea.negate(), lastLiteral);
                    lastLiteral.addDependent(var.mLower);
                }
                var.mLower.setOldReason(reason);
                reason = var.mLower;
            }
            if (!var.mBasic) {
                conflict = this.updateVariable(var, false, oldBound, bound);
                if (conflict != null) {
                    return conflict;
                }
            } else if (var.outOfBounds()) {
                this.mOob.add(var);
            }
            for (BoundConstraint bc : var.mConstraints.subMap(oldBound, bound).values()) {
                assert (bc.getInverseBound().lesseq(var.getLowerBound()));
                this.mProplist.add(bc.negate());
            }
            for (LAEquality laeq : var.mEqualities.subMap(oldBound, bound).values()) {
                this.mProplist.add(laeq.negate());
            }
        }
        InfinitNumber ubound = var.getUpperBound();
        InfinitNumber lbound = var.getLowerBound();
        if (lbound.equals(ubound)) {
            LAEquality lasd = (LAEquality)var.mEqualities.get(lbound);
            if (lasd != null && lasd.getDecideStatus() == null) {
                this.mProplist.add(lasd);
            }
        } else if (ubound.less(lbound)) {
            this.mConflictVar = var;
            return this.checkPendingConflict();
        }
        assert (var.mBasic || !var.outOfBounds());
        return null;
    }

    @Override
    public Clause setLiteral(Literal literal) {
        Clause conflict = this.checkPendingBoundPropagations();
        if (conflict != null) {
            return conflict;
        }
        assert (this.checkClean());
        if (this.mProplist.contains(literal.negate())) {
            return this.getUnitClause(literal.negate());
        }
        DPLLAtom atom = literal.getAtom();
        if (atom instanceof LAEquality) {
            LAEquality lasd = (LAEquality)atom;
            for (CCEquality eq : lasd.getDependentEqualities()) {
                if (eq.getDecideStatus() == null) {
                    this.mProplist.add(literal == atom ? eq : eq.negate());
                    continue;
                }
                if (eq.getDecideStatus().getSign() == literal.getSign()) continue;
                return this.generateEqualityClause(eq.getDecideStatus().negate());
            }
            LinVar var = lasd.getVar();
            InfinitNumber bound = new InfinitNumber(lasd.getBound(), 0);
            if (literal.getSign() == 1) {
                if (this.mEngine.getLogger().isDebugEnabled()) {
                    this.mEngine.getLogger().debug("Setting " + lasd.getVar() + " to " + lasd.getBound());
                }
                if (bound.less(var.getUpperBound())) {
                    conflict = this.setBound(new LiteralReason(var, bound, true, literal));
                }
                if (conflict != null) {
                    return conflict;
                }
                if (var.getLowerBound().less(bound)) {
                    conflict = this.setBound(new LiteralReason(var, bound, false, literal));
                }
            } else {
                var.addDiseq(lasd);
                if (var.getUpperBound().equals(bound)) {
                    conflict = this.setBound(new LiteralReason(var, bound.sub(var.getEpsilon()), true, literal));
                } else if (var.getLowerBound().equals(bound)) {
                    conflict = this.setBound(new LiteralReason(var, bound.add(var.getEpsilon()), false, literal));
                }
            }
        } else if (atom instanceof BoundConstraint) {
            BoundConstraint bc = (BoundConstraint)atom;
            LinVar var = bc.getVar();
            if (literal == bc) {
                if (bc.getBound().less(var.getExactUpperBound())) {
                    conflict = this.setBound(new LiteralReason(var, bc.getBound(), true, literal));
                }
            } else if (var.getExactLowerBound().less(bc.getInverseBound())) {
                conflict = this.setBound(new LiteralReason(var, bc.getInverseBound(), false, literal));
            }
        }
        assert (conflict != null || this.checkClean());
        return conflict;
    }

    @Override
    public Clause checkpoint() {
        Clause conflict = this.checkPendingBoundPropagations();
        if (conflict != null) {
            return conflict;
        }
        if (!this.mInCheck) {
            return null;
        }
        return this.fixOobs();
    }

    public Rational realValue(LinVar var) {
        if (this.mEps == null) {
            this.prepareModel();
        }
        if (var.mDead) {
            Rational val = Rational.ZERO;
            for (Map.Entry<LinVar, Rational> chain : this.mSimps.get(var).entrySet()) {
                val = val.add(this.realValue(chain.getKey()).mul(chain.getValue()));
            }
            return val;
        }
        Rational cureps = var.computeEpsilon();
        return var.mCurval.mA.addmul(this.mEps, cureps);
    }

    public void dumpTableaux(Logger logger) {
        for (LinVar var : this.mLinvars) {
            if (!var.mBasic) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(var.mHeadEntry.mCoeff).append('*').append(var).append(" ; ");
            MatrixEntry entry = var.mHeadEntry.mNextInRow;
            while (entry != var.mHeadEntry) {
                sb.append(" ; ").append(entry.mCoeff).append('*').append(entry.mColumn);
                entry = entry.mNextInRow;
            }
            logger.debug(sb.toString());
        }
    }

    public void dumpConstraints(Logger logger) {
        for (LinVar var : this.mLinvars) {
            StringBuilder sb = new StringBuilder();
            sb.append(var).append(var.mIsInt ? "[int]" : "[real]").append(": ");
            InfinitNumber lower = var.getLowerBound();
            if (lower != InfinitNumber.NEGATIVE_INFINITY) {
                sb.append("lower: ").append(var.getLowerBound()).append(" <= ");
            }
            sb.append(var.mCurval);
            InfinitNumber upper = var.getUpperBound();
            if (upper != InfinitNumber.POSITIVE_INFINITY) {
                sb.append(" <= ").append(upper).append(" : upper");
            }
            logger.debug(sb);
        }
    }

    private void prepareModel() {
        if (this.mEps != null) {
            return;
        }
        TreeSet<Rational> prohibitions = new TreeSet<Rational>();
        InfinitNumber maxeps = this.computeMaxEpsilon(prohibitions);
        this.mEps = maxeps == InfinitNumber.POSITIVE_INFINITY ? Rational.ONE : maxeps.inverse().ceil().mA.inverse();
        TreeMap<Rational, Set<Rational>> sharedPoints = new TreeMap<Rational, Set<Rational>>();
        Map<ExactInfinitNumber, List<SharedTerm>> cong = this.getSharedCongruences();
        for (ExactInfinitNumber value : cong.keySet()) {
            Rational eps = value.getEpsilon();
            TreeSet<Rational> confl = (TreeSet<Rational>)sharedPoints.get(eps);
            if (confl == null) {
                confl = new TreeSet<Rational>();
                sharedPoints.put(eps, confl);
            }
            confl.add(value.getRealValue());
        }
        while (prohibitions.contains(this.mEps) || this.hasSharing(sharedPoints, this.mEps)) {
            this.mEps = this.mEps.inverse().add(Rational.ONE).inverse();
        }
    }

    @Override
    public void dumpModel(Logger logger) {
        this.dumpTableaux(logger);
        this.dumpConstraints(logger);
        this.prepareModel();
        logger.info("Assignments:");
        for (LinVar var : this.mLinvars) {
            if (var.isInitiallyBasic()) continue;
            logger.info(var + " = " + this.realValue(var));
        }
        if (this.mSimps != null) {
            for (LinVar var : this.mSimps.keySet()) {
                logger.info(var + " = " + this.realValue(var));
            }
        }
    }

    @Override
    public void printStatistics(Logger logger) {
        logger.info("Number of Bland pivoting-Operations: " + this.mNumPivotsBland + "/" + this.mNumPivots);
        logger.info("Number of switches to Bland's Rule: " + this.mNumSwitchToBland);
        int basicVars = 0;
        for (LinVar var : this.mLinvars) {
            if (var.isInitiallyBasic()) continue;
            ++basicVars;
        }
        logger.info("Number of variables: " + this.mLinvars.size() + " nonbasic: " + basicVars + " shared: " + this.mSharedVars.size());
        logger.info("Time for pivoting         : " + this.mPivotTime / 1000000L);
        logger.info("Time for bound computation: " + this.mPropBoundTime / 1000000L);
        logger.info("Time for bound setting    : " + this.mPropBoundSetTime / 1000000L);
        logger.info("Time for bound comp(back) : " + this.mBacktrackPropTime / 1000000L);
        logger.info("No. of simplified variables: " + (this.mSimps == null ? 0 : this.mSimps.size()));
        logger.info("Composite::createLit: " + this.mCompositeCreateLit);
        logger.info("Number of cuts: " + this.mNumCuts);
        logger.info("Time for cut-generation: " + this.mCutGenTime / 1000000L);
        logger.info("Number of branchings: " + this.mNumBranches);
    }

    private final Clause pivot(MatrixEntry pivotEntry) {
        if (this.mEngine.getLogger().isDebugEnabled()) {
            this.mEngine.getLogger().debug("pivot " + pivotEntry);
        }
        Clause conflict = null;
        ++this.mNumPivots;
        LinVar basic = pivotEntry.mRow;
        LinVar nonbasic = pivotEntry.mColumn;
        assert (basic.checkChainlength());
        assert (nonbasic.checkChainlength());
        assert (basic.checkBrpCounters());
        assert (basic.mBasic);
        assert (!nonbasic.mBasic);
        basic.mBasic = false;
        nonbasic.mBasic = true;
        BigInteger nbcoeff = pivotEntry.mCoeff;
        BigInteger bcoeff = basic.mHeadEntry.mCoeff;
        basic.updateUpperLowerClear(nbcoeff, nonbasic);
        nonbasic.moveBounds(basic);
        nonbasic.updateUpperLowerSet(bcoeff, basic);
        assert (basic.checkCoeffChain());
        pivotEntry.pivot();
        basic.mCachedRowVars = null;
        basic.mCachedRowCoeffs = null;
        assert (nonbasic.checkChainlength());
        assert (basic.checkChainlength());
        assert (nonbasic.mCachedRowCoeffs == null);
        assert (nonbasic.checkCoeffChain());
        assert (nonbasic.checkBrpCounters());
        MatrixEntry columnHead = nonbasic.mHeadEntry;
        while (columnHead.mNextInCol != columnHead) {
            LinVar row = columnHead.mNextInCol.mRow;
            assert (row.checkBrpCounters());
            assert (row.checkChainlength());
            columnHead.mNextInCol.add(columnHead);
            assert (row.checkChainlength());
            row.mCachedRowVars = null;
            row.mCachedRowCoeffs = null;
            assert (row.checkCoeffChain());
            assert (row.checkBrpCounters());
            if (row.mNumUpperInf == 0) {
                if (conflict == null) {
                    conflict = this.propagateBound(row, true);
                } else {
                    this.mPropBounds.add(row);
                }
            }
            if (row.mNumLowerInf != 0) continue;
            if (conflict == null) {
                conflict = this.propagateBound(row, false);
                continue;
            }
            this.mPropBounds.add(row);
        }
        assert (nonbasic.checkChainlength());
        if (nonbasic.mNumUpperInf == 0) {
            if (conflict == null) {
                conflict = this.propagateBound(nonbasic, true);
            } else {
                this.mPropBounds.add(nonbasic);
            }
        }
        if (nonbasic.mNumLowerInf == 0) {
            if (conflict == null) {
                conflict = this.propagateBound(nonbasic, false);
            } else {
                this.mPropBounds.add(nonbasic);
            }
        }
        return conflict;
    }

    private Clause ensureIntegrals() {
        boolean isIntegral = true;
        for (LinVar lv : this.mIntVars) {
            lv.fixEpsilon();
            if (lv.mCurval.isIntegral()) continue;
            isIntegral = false;
        }
        if (isIntegral) {
            return null;
        }
        Logger logger = this.mEngine.getLogger();
        if (logger.isDebugEnabled()) {
            this.dumpTableaux(logger);
            this.dumpConstraints(logger);
        }
        assert (this.mOob.isEmpty());
        CutCreator cutter = new CutCreator(this);
        cutter.generateCuts();
        Clause c = this.checkPendingConflict();
        if (c != null) {
            return c;
        }
        c = this.checkpoint();
        if (c != null) {
            return c;
        }
        return null;
    }

    private Clause fixOobs() {
        int switchtobland = 5 * this.mLinvars.size();
        assert (this.checkClean());
        int curnumpivots = 0;
        boolean useBland = false;
        block0: while (!this.mOob.isEmpty()) {
            MatrixEntry entry;
            BigInteger denom;
            InfinitNumber diff;
            boolean isLower;
            InfinitNumber bound;
            LinVar oob;
            LinVar linVar = oob = useBland ? this.mOob.pollFirst() : this.findBestVar();
            if (oob == null) {
                return null;
            }
            assert (oob.mBasic);
            assert (oob.getLowerBound().lesseq(oob.getUpperBound()));
            assert (oob.checkBrpCounters());
            assert (oob.checkCoeffChain());
            oob.fixEpsilon();
            if (oob.mCurval.compareTo(oob.getExactLowerBound()) < 0) {
                bound = oob.getLowerBound();
                isLower = oob.mHeadEntry.mCoeff.signum() < 0;
                diff = oob.mCurval.sub(bound).negate();
                denom = oob.mHeadEntry.mCoeff;
            } else {
                if (oob.mCurval.compareTo(oob.getExactUpperBound()) <= 0) continue;
                bound = oob.getUpperBound();
                isLower = oob.mHeadEntry.mCoeff.signum() > 0;
                diff = oob.mCurval.sub(bound);
                denom = oob.mHeadEntry.mCoeff.negate();
            }
            assert (InfinitNumber.ZERO.less(diff));
            if (useBland) {
                entry = oob.mHeadEntry;
                while (entry.mColumn.mMatrixpos > entry.mPrevInRow.mColumn.mMatrixpos) {
                    entry = entry.mNextInRow;
                }
            } else {
                entry = this.findNonBasic(oob, isLower);
            }
            MatrixEntry start = entry;
            do {
                assert (entry == oob.mHeadEntry || !entry.mColumn.mBasic);
                assert (entry == oob.mHeadEntry || entry.mColumn.mCurval.compareTo(entry.mColumn.getUpperBound()) <= 0);
                assert (entry == oob.mHeadEntry || entry.mColumn.mCurval.compareTo(entry.mColumn.getLowerBound()) >= 0);
                if (entry != oob.mHeadEntry) {
                    boolean checkLower = entry.mCoeff.signum() < 0 == isLower;
                    InfinitNumber colBound = checkLower ? entry.mColumn.getLowerBound() : entry.mColumn.getUpperBound();
                    InfinitNumber slack = entry.mColumn.mCurval.sub(colBound);
                    slack = slack.mul(Rational.valueOf(entry.mCoeff, denom));
                    if (!useBland && slack.less(diff)) {
                        if (slack.signum() > 0) {
                            this.updateVariableValue(entry.mColumn, colBound);
                            this.mOob.remove(oob);
                            oob.fixEpsilon();
                            diff = oob.mCurval.sub(bound);
                            if (diff.signum() < 0) {
                                diff = diff.negate();
                            }
                        }
                    } else if (slack.signum() > 0) {
                        assert (!this.mOob.contains(oob));
                        Clause conflict = this.pivot(entry);
                        boolean oldBland = useBland;
                        if (oldBland) {
                            ++this.mNumPivotsBland;
                        }
                        boolean bl = useBland = ++curnumpivots > switchtobland;
                        if (useBland && !oldBland) {
                            this.mEngine.getLogger().debug("Using Blands Rule");
                            ++this.mNumSwitchToBland;
                        }
                        this.updateVariableValue(oob, bound);
                        if (conflict == null) continue block0;
                        return conflict;
                    }
                }
                MatrixEntry matrixEntry = entry = useBland ? entry.mNextInRow : this.findNonBasic(oob, isLower);
            } while (!useBland || entry != start);
            assert (oob.checkBrpCounters());
            throw new AssertionError((Object)"Bound was not propagated????");
        }
        assert (this.checkClean());
        return null;
    }

    private Clause propagateBound(LinVar basic, boolean isUpper) {
        InfinitNumber bound;
        BigInteger denom = basic.mHeadEntry.mCoeff.negate();
        InfinitNumber infinitNumber = bound = (isUpper ^= denom.signum() < 0) ? basic.getUpperComposite() : basic.getLowerComposite();
        if (isUpper ? bound.less(basic.getUpperBound()) : basic.getLowerBound().less(bound)) {
            Rational[] coeffs;
            LAReason[] reasons;
            LiteralReason lastLiteral = null;
            if (basic.mCachedRowCoeffs == null) {
                int rowLength = 0;
                MatrixEntry entry = basic.mHeadEntry.mNextInRow;
                while (entry != basic.mHeadEntry) {
                    ++rowLength;
                    entry = entry.mNextInRow;
                }
                LinVar[] rowVars = new LinVar[rowLength];
                reasons = new LAReason[rowLength];
                coeffs = new Rational[rowLength];
                int i = 0;
                MatrixEntry entry2 = basic.mHeadEntry.mNextInRow;
                while (entry2 != basic.mHeadEntry) {
                    LinVar nb = entry2.mColumn;
                    Rational coeff = Rational.valueOf(entry2.mCoeff, denom);
                    rowVars[i] = nb;
                    reasons[i] = coeff.isNegative() == isUpper ? nb.mLower : nb.mUpper;
                    coeffs[i] = coeff;
                    LiteralReason lastOfThis = reasons[i].getLastLiteral();
                    if (lastLiteral == null || lastOfThis.getStackPosition() > lastLiteral.getStackPosition()) {
                        lastLiteral = lastOfThis;
                    }
                    ++i;
                    entry2 = entry2.mNextInRow;
                }
                basic.mCachedRowCoeffs = coeffs;
                basic.mCachedRowVars = rowVars;
            } else {
                LinVar[] rowVars = basic.mCachedRowVars;
                coeffs = basic.mCachedRowCoeffs;
                reasons = new LAReason[rowVars.length];
                for (int i = 0; i < rowVars.length; ++i) {
                    reasons[i] = coeffs[i].isNegative() == isUpper ? rowVars[i].mLower : rowVars[i].mUpper;
                    LiteralReason lastOfThis = reasons[i].getLastLiteral();
                    if (lastLiteral != null && lastOfThis.getStackPosition() <= lastLiteral.getStackPosition()) continue;
                    lastLiteral = lastOfThis;
                }
            }
            CompositeReason newComposite = new CompositeReason(basic, bound, isUpper, reasons, coeffs, lastLiteral);
            lastLiteral.addDependent(newComposite);
            Clause conflict = this.setBound(newComposite);
            return conflict;
        }
        return null;
    }

    private void dumpSimps() {
        if (this.mSimps == null) {
            return;
        }
        for (Map.Entry<LinVar, TreeMap<LinVar, Rational>> me : this.mSimps.entrySet()) {
            this.mEngine.getLogger().debug(me.getKey() + " = " + me.getValue());
        }
    }

    private Literal generateConstraint(LinVar var, Rational bound, boolean isLowerBound, boolean strict) {
        InfinitNumber rbound = new InfinitNumber(bound, strict ^ isLowerBound ? -1 : 0);
        if (var.isInt()) {
            rbound = rbound.floor();
        }
        return this.generateConstraint(var, rbound, isLowerBound);
    }

    private Literal generateConstraint(LinVar var, InfinitNumber rbound, boolean isLowerBound) {
        BoundConstraint bc;
        if (var.mDead) {
            this.ensureUnsimplified(var);
        }
        if ((bc = (BoundConstraint)var.mConstraints.get(rbound)) == null) {
            bc = new BoundConstraint(rbound, var, this.mEngine.getAssertionStackLevel());
            assert (bc.mVar.checkCoeffChain());
            this.mEngine.addAtom(bc);
            if (var.getUpperBound().lesseq(rbound)) {
                this.mProplist.add(bc);
            }
            if (rbound.less(var.getLowerBound())) {
                this.mProplist.add(bc.negate());
            }
        }
        return isLowerBound ? bc.negate() : bc;
    }

    private void insertVar(LinVar v, TreeMap<LinVar, Rational> coeffs) {
        v.mBasic = true;
        v.mHeadEntry = new MatrixEntry();
        v.mHeadEntry.mColumn = v;
        v.mHeadEntry.mRow = v;
        v.mHeadEntry.mNextInRow = v.mHeadEntry.mPrevInRow = v.mHeadEntry;
        v.mHeadEntry.mNextInCol = v.mHeadEntry.mPrevInCol = v.mHeadEntry;
        v.resetComposites();
        MutableInfinitNumber val = new MutableInfinitNumber();
        Rational gcd = Rational.ONE;
        for (Rational rational : coeffs.values()) {
            gcd = gcd.gcd(rational);
        }
        assert (gcd.numerator().equals(BigInteger.ONE));
        v.mHeadEntry.mCoeff = gcd.denominator().negate();
        for (Map.Entry entry : coeffs.entrySet()) {
            assert (!((LinVar)entry.getKey()).mBasic);
            LinVar nb = (LinVar)entry.getKey();
            Rational value = ((Rational)entry.getValue()).div(gcd);
            assert (value.denominator().equals(BigInteger.ONE));
            BigInteger coeff = value.numerator();
            v.mHeadEntry.insertRow(nb, coeff);
            val.addmul(nb.mCurval, value);
            v.updateUpperLowerSet(coeff, nb);
        }
        val = val.mul(gcd);
        v.mCurval = val.toInfinitNumber();
        assert (v.checkBrpCounters());
        if (v.mNumUpperInf == 0 || v.mNumLowerInf == 0) {
            this.mPropBounds.add(v);
        }
        assert (!v.mCurval.mA.denominator().equals(BigInteger.ZERO));
    }

    private TreeMap<LinVar, Rational> removeVar(LinVar v) {
        assert (v.mBasic);
        this.mLinvars.remove(v);
        TreeMap<LinVar, Rational> res = new TreeMap<LinVar, Rational>();
        BigInteger denom = v.mHeadEntry.mCoeff.negate();
        MatrixEntry entry = v.mHeadEntry.mNextInRow;
        while (entry != v.mHeadEntry) {
            assert (!entry.mColumn.mBasic);
            res.put(entry.mColumn, Rational.valueOf(entry.mCoeff, denom));
            entry.removeFromMatrix();
            entry = entry.mNextInRow;
        }
        v.mHeadEntry = null;
        return res;
    }

    public void removeLinVar(LinVar v) {
        assert (this.mOob.isEmpty());
        if (!v.mBasic) {
            if (v.mHeadEntry.mNextInCol == v.mHeadEntry) {
                this.mLinvars.remove(v);
                return;
            }
            Clause conflict = this.pivot(v.mHeadEntry.mNextInCol);
            assert (conflict == null) : "Removing a variable produced a conflict!";
        }
        TreeMap<LinVar, Rational> coeffs = this.removeVar(v);
        this.updateSimps(v, coeffs);
    }

    private Clause simplifyTableau() {
        ArrayList<LinVar> removeVars = new ArrayList<LinVar>(this.mLinvars.size());
        block0: for (LinVar v : this.mLinvars) {
            if (v.isInt() || v.mDead || !v.unconstrained()) continue;
            if (v.mBasic) {
                removeVars.add(v);
                v.mDead = true;
                continue;
            }
            MatrixEntry entry = v.mHeadEntry.mNextInCol;
            while (entry != v.mHeadEntry) {
                LinVar basic = entry.mRow;
                if (!(basic.unconstrained() || basic.mDead || removeVars.contains(basic))) {
                    if (this.mEngine.getLogger().isDebugEnabled()) {
                        this.mEngine.getLogger().debug("simplify pivot " + entry);
                    }
                    Clause conflict = this.pivot(entry);
                    InfinitNumber bound = basic.getLowerBound();
                    if (bound.isInfinity()) {
                        bound = basic.getUpperBound();
                    }
                    if (!bound.isInfinity()) {
                        this.updateVariableValue(basic, bound);
                    }
                    this.mOob.remove(basic);
                    v.mDead = true;
                    removeVars.add(v);
                    if (conflict == null) continue block0;
                    for (LinVar var : removeVars) {
                        var.mDead = false;
                    }
                    return conflict;
                }
                entry = entry.mNextInCol;
            }
        }
        HashMap<LinVar, TreeMap<LinVar, Rational>> newsimps = new HashMap<LinVar, TreeMap<LinVar, Rational>>();
        for (LinVar v : removeVars) {
            assert (v.mBasic);
            this.mEngine.getLogger().debug(new DebugMessage("Simplifying {0}", v));
            TreeMap<LinVar, Rational> coeffs = this.removeVar(v);
            this.updateSimps(v, coeffs);
            newsimps.put(v, coeffs);
            this.mOob.remove(v);
            this.mPropBounds.remove(v);
        }
        this.mSimps.putAll(newsimps);
        assert (this.checkPostSimplify());
        return null;
    }

    private void unsimplifyAndAdd(LinVar lv, Rational fac, Map<LinVar, Rational> facs) {
        if (lv.mDead) {
            ArrayDeque<UnsimpData> unsimpStack = new ArrayDeque<UnsimpData>();
            unsimpStack.add(new UnsimpData(lv, fac));
            while (!unsimpStack.isEmpty()) {
                UnsimpData data = (UnsimpData)unsimpStack.removeFirst();
                if (data.mVar.mDead) {
                    for (Map.Entry<LinVar, Rational> simp : this.mSimps.get(data.mVar).entrySet()) {
                        unsimpStack.add(new UnsimpData(simp.getKey(), data.mFac.mul(simp.getValue())));
                    }
                    continue;
                }
                this.unsimplifyAndAdd(data.mVar, data.mFac, facs);
            }
        } else if (lv.mBasic) {
            BigInteger denom = lv.mHeadEntry.mCoeff.negate();
            MatrixEntry entry = lv.mHeadEntry.mNextInRow;
            while (entry != lv.mHeadEntry) {
                Rational coeff = Rational.valueOf(entry.mCoeff, denom);
                this.unsimplifyAndAdd(entry.mColumn, fac.mul(coeff), facs);
                entry = entry.mNextInRow;
            }
        } else {
            Rational oldval = facs.get(lv);
            if (oldval == null) {
                facs.put(lv, fac);
            } else {
                Rational newval = oldval.add(fac);
                if (newval.equals(Rational.ZERO)) {
                    facs.remove(lv);
                } else {
                    facs.put(lv, newval);
                }
            }
        }
    }

    private void updateSimps(LinVar v, Map<LinVar, Rational> coeffs) {
        for (Map.Entry<LinVar, TreeMap<LinVar, Rational>> me : this.mSimps.entrySet()) {
            TreeMap<LinVar, Rational> cmap = me.getValue();
            Rational cc = cmap.get(v);
            if (cc == null) continue;
            cmap.remove(v);
            for (Map.Entry<LinVar, Rational> cme : coeffs.entrySet()) {
                Rational c = cmap.get(cme.getKey());
                if (c == null) {
                    cmap.put(cme.getKey(), cme.getValue().mul(cc));
                    continue;
                }
                Rational newcoeff = cme.getValue().mul(cc).add(c);
                if (newcoeff.equals(Rational.ZERO)) {
                    cmap.remove(cme.getKey());
                    continue;
                }
                cmap.put(cme.getKey(), newcoeff);
            }
            me.setValue(cmap);
        }
    }

    private void ensureUnsimplified(LinVar var) {
        this.ensureUnsimplified(var, true);
    }

    private void ensureUnsimplified(LinVar var, boolean remove) {
        if (var.mDead) {
            assert (this.mSimps.containsKey(var));
            this.mEngine.getLogger().debug(new DebugMessage("Ensuring {0} is unsimplified", var));
            TreeMap<LinVar, Rational> curcoeffs = new TreeMap<LinVar, Rational>();
            this.unsimplifyAndAdd(var, Rational.ONE, curcoeffs);
            this.insertVar(var, curcoeffs);
            var.mDead = false;
            if (remove) {
                this.mSimps.remove(var);
            }
            this.mLinvars.add(var);
        }
        assert (!var.mDead);
    }

    Map<LinVar, ExactInfinitNumber> calculateSimpVals() {
        HashMap<LinVar, ExactInfinitNumber> simps = new HashMap<LinVar, ExactInfinitNumber>();
        for (Map.Entry<LinVar, TreeMap<LinVar, Rational>> me : this.mSimps.entrySet()) {
            MutableRational real = new MutableRational(0, 1);
            MutableRational eps = new MutableRational(0, 1);
            for (Map.Entry<LinVar, Rational> chain : me.getValue().entrySet()) {
                real.addmul(chain.getKey().mCurval.mA, chain.getValue());
                if (chain.getKey().mBasic) {
                    eps.addmul(chain.getKey().computeEpsilon(), chain.getValue());
                    continue;
                }
                if (chain.getKey().mCurval.mEps < 0) {
                    eps.sub(chain.getValue());
                    continue;
                }
                if (chain.getKey().mCurval.mEps <= 0) continue;
                eps.add(chain.getValue());
            }
            Rational rreal = real.toRational();
            me.getKey().mCurval = new InfinitNumber(rreal, eps.signum());
            simps.put(me.getKey(), new ExactInfinitNumber(rreal, eps.toRational()));
        }
        return simps;
    }

    private void freedom(LinVar var, MutableInfinitNumber lower, MutableInfinitNumber upper) {
        lower.assign(var.getLowerBound());
        upper.assign(var.getUpperBound());
        if (lower.equals(upper)) {
            return;
        }
        InfinitNumber maxBelow = InfinitNumber.NEGATIVE_INFINITY;
        InfinitNumber minAbove = InfinitNumber.POSITIVE_INFINITY;
        MatrixEntry me = var.mHeadEntry.mNextInCol;
        while (me != var.mHeadEntry) {
            Rational coeff = Rational.valueOf(me.mRow.mHeadEntry.mCoeff.negate(), me.mCoeff);
            InfinitNumber below = me.mRow.getLowerBound().sub(me.mRow.mCurval).mul(coeff);
            InfinitNumber above = me.mRow.getUpperBound().sub(me.mRow.mCurval).mul(coeff);
            if (coeff.isNegative()) {
                InfinitNumber t = below;
                below = above;
                above = t;
            }
            assert (below.signum() <= 0 && above.signum() >= 0);
            if (below.compareTo(maxBelow) > 0) {
                maxBelow = below;
            }
            if (above.compareTo(minAbove) < 0) {
                minAbove = above;
            }
            me = me.mNextInCol;
        }
        maxBelow = maxBelow.add(var.mCurval);
        minAbove = minAbove.add(var.mCurval);
        if (maxBelow.compareTo(lower.toInfinitNumber()) > 0) {
            lower.assign(maxBelow);
        }
        if (minAbove.compareTo(upper.toInfinitNumber()) < 0) {
            upper.assign(minAbove);
        }
    }

    private void mutate() {
        MutableInfinitNumber lower = new MutableInfinitNumber();
        MutableInfinitNumber upper = new MutableInfinitNumber();
        TreeMap<Rational, Set<Rational>> sharedPoints = new TreeMap<Rational, Set<Rational>>();
        TreeSet<Rational> prohib = new TreeSet<Rational>();
        for (LinVar lv : this.mLinvars) {
            if (lv.mBasic || lv.getUpperBound().equals(lv.getLowerBound())) continue;
            this.freedom(lv, lower, upper);
            if (lower.equals(upper)) continue;
            Rational gcd = lv.isInt() ? Rational.ONE : Rational.ZERO;
            Rational curval = lv.mCurval.mA;
            sharedPoints.clear();
            prohib.clear();
            if (lv.mDisequalities != null) {
                for (Rational diseq : lv.mDisequalities.keySet()) {
                    prohib.add(diseq);
                }
            }
            HashMap<LinVar, Rational> basicFactors = new HashMap<LinVar, Rational>();
            MatrixEntry it1 = lv.mHeadEntry.mNextInCol;
            while (it1 != lv.mHeadEntry) {
                LinVar basic = it1.mRow;
                Rational coeff = Rational.valueOf(it1.mCoeff.negate(), it1.mRow.mHeadEntry.mCoeff);
                basicFactors.put(basic, coeff);
                if (basic.isInt()) {
                    gcd = gcd.gcd(coeff.abs());
                }
                if (basic.mDisequalities != null) {
                    for (Rational diseq : basic.mDisequalities.keySet()) {
                        prohib.add(diseq.sub(basic.mCurval.mA).div(coeff).add(curval));
                    }
                }
                it1 = it1.mNextInCol;
            }
            for (int i = 0; i < this.mSharedVars.size(); ++i) {
                SharedTerm sharedVar = (SharedTerm)this.mSharedVars.get(i);
                LinVar sharedLV = sharedVar.getLinVar();
                Rational sharedCoeff = (Rational)basicFactors.get(sharedLV);
                sharedCoeff = sharedCoeff == null ? Rational.ZERO : sharedCoeff.mul(sharedVar.getFactor());
                TreeSet<Rational> set = (TreeSet<Rational>)sharedPoints.get(sharedCoeff);
                if (set == null) {
                    set = new TreeSet<Rational>();
                    sharedPoints.put(sharedCoeff, set);
                }
                Rational sharedCurVal = sharedVar.getOffset();
                if (sharedLV != null) {
                    sharedCurVal = sharedCurVal.addmul(sharedLV.mCurval.mA, sharedVar.getFactor());
                }
                set.add(sharedCurVal);
            }
            Rational lcm = gcd.inverse();
            InfinitNumber chosen = this.choose(lower, upper, prohib, sharedPoints, lcm, lv.mCurval);
            assert (chosen.compareTo(lower.toInfinitNumber()) >= 0 && chosen.compareTo(upper.toInfinitNumber()) <= 0);
            if (chosen.equals(lv.mCurval)) continue;
            this.updateVariableValue(lv, chosen);
        }
    }

    Map<ExactInfinitNumber, List<SharedTerm>> getSharedCongruences() {
        this.mEngine.getLogger().debug("Shared Vars:");
        HashMap<ExactInfinitNumber, List<SharedTerm>> result = new HashMap<ExactInfinitNumber, List<SharedTerm>>();
        Map<LinVar, ExactInfinitNumber> simps = this.calculateSimpVals();
        for (SharedTerm shared : this.mSharedVars) {
            LinkedList<SharedTerm> slot;
            MutableRational real = new MutableRational(shared.getOffset());
            MutableRational eps = new MutableRational(0, 1);
            if (shared.getLinVar() != null) {
                if (shared.getLinVar().mDead) {
                    ExactInfinitNumber simpval = simps.get(shared.getLinVar());
                    real.addmul(simpval.getRealValue(), shared.getFactor());
                    eps.addmul(simpval.getEpsilon(), shared.getFactor());
                } else {
                    if (shared.getLinVar().mBasic) {
                        eps.addmul(shared.getLinVar().computeEpsilon(), shared.getFactor());
                    } else if (shared.getLinVar().mCurval.mEps > 0) {
                        eps.add(shared.getFactor());
                    } else if (shared.getLinVar().mCurval.mEps < 0) {
                        eps.sub(shared.getFactor());
                    }
                    real.addmul(shared.getLinVar().mCurval.mA, shared.getFactor());
                }
            }
            ExactInfinitNumber curval = new ExactInfinitNumber(real.toRational(), eps.toRational());
            if (this.mEngine.getLogger().isDebugEnabled()) {
                this.mEngine.getLogger().debug(shared + " = " + curval);
            }
            if ((slot = (LinkedList<SharedTerm>)result.get(curval)) == null) {
                slot = new LinkedList<SharedTerm>();
                result.put(curval, slot);
            }
            slot.add(shared);
        }
        return result;
    }

    private Literal ensureDisequality(LAEquality eq) {
        boolean usegt;
        LinVar v = eq.getVar();
        assert (eq.getDecideStatus().getSign() == -1);
        if (!v.mCurval.mA.equals(eq.getBound())) {
            return null;
        }
        if (v.mBasic) {
            v.fixEpsilon();
        }
        if (v.mCurval.mEps != 0) {
            return null;
        }
        InfinitNumber bound = new InfinitNumber(eq.getBound(), 0);
        BoundConstraint gbc = (BoundConstraint)eq.getVar().mConstraints.get(bound);
        boolean bl = usegt = gbc == null;
        if (!usegt && gbc.getDecideStatus() == null) {
            return gbc.negate();
        }
        InfinitNumber strictbound = bound.sub(eq.getVar().getEpsilon());
        BoundConstraint lbc = (BoundConstraint)eq.getVar().mConstraints.get(strictbound);
        if (lbc != null && lbc.getDecideStatus() == null) {
            return lbc;
        }
        return usegt ? this.generateConstraint(eq.getVar(), eq.getBound(), false, false).negate() : this.generateConstraint(eq.getVar(), eq.getBound(), false, true);
    }

    private InfinitNumber choose(MutableInfinitNumber lower, MutableInfinitNumber upper, Set<Rational> prohibitions, Map<Rational, Set<Rational>> sharedPoints, Rational lcm, InfinitNumber currentValue) {
        InfinitNumber cur;
        InfinitNumber ilcm;
        MutableInfinitNumber down;
        MutableInfinitNumber up;
        block11: {
            if (upper.equals(lower) || !prohibitions.contains(currentValue.mA) && !this.hasSharing(sharedPoints, Rational.ZERO)) {
                return currentValue;
            }
            if (lcm == Rational.POSITIVE_INFINITY) {
                InfinitNumber mid;
                InfinitNumber low = lower.toInfinitNumber();
                if (low.isInfinity()) {
                    low = upper.mA.signum() > 0 ? InfinitNumber.ZERO : upper.toInfinitNumber().sub(InfinitNumber.ONE);
                }
                if ((mid = upper.toInfinitNumber().add(low).div(Rational.TWO)).isInfinity()) {
                    mid = low.add(InfinitNumber.ONE);
                }
                while (prohibitions.contains(mid.mA) || this.hasSharing(sharedPoints, mid.sub((InfinitNumber)currentValue).mA)) {
                    mid = mid.add(low).div(Rational.TWO);
                }
                return mid;
            }
            up = new MutableInfinitNumber(currentValue);
            down = new MutableInfinitNumber(currentValue);
            ilcm = new InfinitNumber(lcm, 0);
            do {
                up.add(ilcm);
                if (up.compareTo(upper) > 0) break block11;
                cur = up.toInfinitNumber();
                if (!prohibitions.contains(cur.mA) && !this.hasSharing(sharedPoints, cur.sub((InfinitNumber)currentValue).mA)) {
                    return cur;
                }
                down.sub(ilcm);
                if (down.compareTo(lower) < 0) break block11;
                cur = down.toInfinitNumber();
            } while (prohibitions.contains(cur.mA) || this.hasSharing(sharedPoints, cur.sub((InfinitNumber)currentValue).mA));
            return cur;
        }
        up.add(ilcm);
        while (up.compareTo(upper) <= 0) {
            cur = up.toInfinitNumber();
            if (!prohibitions.contains(cur.mA) && !this.hasSharing(sharedPoints, cur.sub((InfinitNumber)currentValue).mA)) {
                return cur;
            }
            up.add(ilcm);
        }
        down.sub(ilcm);
        while (down.compareTo(lower) >= 0) {
            cur = down.toInfinitNumber();
            if (!prohibitions.contains(cur.mA) && !this.hasSharing(sharedPoints, cur.sub((InfinitNumber)currentValue).mA)) {
                return cur;
            }
            down.sub(ilcm);
        }
        return currentValue;
    }

    private boolean hasSharing(Map<Rational, Set<Rational>> sharedPoints, Rational diff) {
        TreeSet<Rational> used = new TreeSet<Rational>();
        for (Map.Entry<Rational, Set<Rational>> entry : sharedPoints.entrySet()) {
            Rational sharedDiff = entry.getKey().mul(diff);
            for (Rational r : entry.getValue()) {
                if (used.add(r.add(sharedDiff))) continue;
                return true;
            }
        }
        return false;
    }

    private Clause mbtc(Map<ExactInfinitNumber, List<SharedTerm>> cong) {
        for (Map.Entry<ExactInfinitNumber, List<SharedTerm>> congclass : cong.entrySet()) {
            List<SharedTerm> lcongclass = congclass.getValue();
            if (lcongclass.size() <= 1) continue;
            this.mEngine.getLogger().debug(new DebugMessage("propagating MBTC: {0}", lcongclass));
            Iterator<SharedTerm> it = lcongclass.iterator();
            SharedTerm shared1 = it.next();
            while (it.hasNext()) {
                SharedTerm shared2 = it.next();
                EqualityProxy eq = shared1.createEquality(shared2);
                assert (eq != EqualityProxy.getTrueProxy());
                assert (eq != EqualityProxy.getFalseProxy());
                CCEquality cceq = eq.createCCEquality(shared1, shared2);
                if (cceq.getLASharedData().getDecideStatus() != null) {
                    if (cceq.getDecideStatus() == cceq.negate()) {
                        return this.generateEqualityClause(cceq);
                    }
                    if (cceq.getDecideStatus() == null) {
                        this.mProplist.add(cceq);
                        continue;
                    }
                    this.mEngine.getLogger().debug(new DebugMessage("already set: {0}", cceq.getAtom().getDecideStatus()));
                    continue;
                }
                this.mEngine.getLogger().debug(new DebugMessage("MBTC: Suggesting literal {0}", cceq));
                this.mSuggestions.add(cceq.getLASharedData());
            }
        }
        return null;
    }

    @Override
    public Literal getSuggestion() {
        Literal res;
        do {
            if (!this.mSuggestions.isEmpty()) continue;
            return null;
        } while ((res = this.mSuggestions.removeFirst()).getAtom().getDecideStatus() != null);
        return res;
    }

    private InfinitNumber computeMaxEpsilon(Set<Rational> prohibitions) {
        InfinitNumber maxeps = InfinitNumber.POSITIVE_INFINITY;
        for (LinVar v : this.mLinvars) {
            InfinitNumber diff;
            if (v.mBasic) {
                InfinitNumber diff2;
                Rational epsilons = v.computeEpsilon();
                if (epsilons.signum() > 0) {
                    diff2 = v.getUpperBound().sub(new InfinitNumber(v.mCurval.mA, 0)).div(epsilons);
                    if (diff2.compareTo(maxeps) < 0) {
                        maxeps = diff2;
                    }
                } else if (epsilons.signum() < 0 && (diff2 = v.getLowerBound().sub(new InfinitNumber(v.mCurval.mA, 0)).div(epsilons)).compareTo(maxeps) < 0) {
                    maxeps = diff2;
                }
                if (epsilons.signum() == 0 || v.mDisequalities == null) continue;
                for (Rational prohib : v.mDisequalities.keySet()) {
                    prohibitions.add(prohib.sub(v.mCurval.mA).div(epsilons));
                }
                continue;
            }
            if (v.mCurval.mEps > 0) {
                diff = v.getUpperBound().sub(new InfinitNumber(v.mCurval.mA, 0));
                if (diff.compareTo(maxeps) < 0) {
                    maxeps = diff;
                }
                assert (v.mCurval.mEps == 1);
                if (v.mDisequalities == null) continue;
                for (Rational prohib : v.mDisequalities.keySet()) {
                    prohibitions.add(prohib.sub(v.mCurval.mA));
                }
                continue;
            }
            if (v.mCurval.mEps >= 0) continue;
            diff = new InfinitNumber(v.mCurval.mA, 0).sub(v.getLowerBound());
            if (diff.compareTo(maxeps) < 0) {
                maxeps = diff;
            }
            assert (v.mCurval.mEps == -1);
            if (v.mDisequalities == null) continue;
            for (Rational prohib : v.mDisequalities.keySet()) {
                prohibitions.add(v.mCurval.mA.sub(prohib));
            }
        }
        return maxeps;
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void restart(int iteration) {
    }

    public LAEquality createEquality(int stackLevel, MutableAffinTerm at) {
        InfinitNumber bound;
        Rational normFactor = at.getGCD().inverse();
        at.mul(normFactor);
        LinVar var = this.generateLinVar(this.getSummandMap(at), stackLevel);
        if (at.mSummands.size() == 1) {
            Rational fac = at.mSummands.values().iterator().next();
            bound = at.mConstant.negate().div(fac);
        } else {
            bound = at.mConstant.negate();
        }
        assert (bound.mEps == 0);
        LAEquality sharedData = var.getEquality(bound);
        if (sharedData == null) {
            sharedData = new LAEquality(stackLevel, var, bound.mA);
            this.mEngine.addAtom(sharedData);
            var.addEquality(sharedData);
        }
        this.ensureUnsimplified(var);
        return sharedData;
    }

    @Override
    public Clause startCheck() {
        this.mEps = null;
        this.mInCheck = true;
        return this.simplifyTableau();
    }

    @Override
    public void endCheck() {
        this.mInCheck = false;
    }

    public Literal createCompositeLiteral(LAReason comp, Literal beforeLit) {
        InfinitNumber litBound;
        ++this.mCompositeCreateLit;
        int depth = comp.getLastLiteral().getDecideLevel();
        if (this.mEngine.getLogger().isDebugEnabled()) {
            this.mEngine.getLogger().debug("Create Propagated Literal for " + comp + " @ level " + depth);
        }
        LinVar var = comp.getVar();
        InfinitNumber bound = comp.getBound();
        if (!comp.isUpper()) {
            bound = bound.sub(var.getEpsilon());
        }
        BoundConstraint bc = new BoundConstraint(bound, var, this.mEngine.getAssertionStackLevel());
        Literal lit = comp.isUpper() ? bc : bc.negate();
        int decideLevel = comp.getLastLiteral().getDecideLevel();
        if (beforeLit != null && beforeLit.getAtom().getDecideLevel() == decideLevel) {
            this.mEngine.insertPropagatedLiteralBefore(this, lit, beforeLit);
        } else {
            this.mEngine.insertPropagatedLiteral(this, lit, decideLevel);
        }
        InfinitNumber infinitNumber = litBound = comp.isUpper() ? bc.getBound() : bc.getInverseBound();
        if (!comp.getExactBound().equals(litBound)) {
            this.insertReasonOfNewComposite(var, lit);
        }
        return lit;
    }

    public void generateSharedVar(SharedTerm shared, MutableAffinTerm mat, int level) {
        assert (mat.getConstant().mEps == 0);
        if (mat.isConstant()) {
            shared.setLinVar(Rational.ZERO, null, mat.getConstant().mA);
        } else {
            Rational normFactor = mat.getGCD().inverse();
            Rational offset = mat.getConstant().mA;
            mat.mul(normFactor);
            LinVar linVar = this.generateLinVar(this.getSummandMap(mat), level);
            shared.setLinVar(normFactor.inverse(), linVar, offset);
        }
    }

    public void share(SharedTerm shared) {
        this.mSharedVars.add(shared);
    }

    public void unshare(SharedTerm shared) {
        this.mSharedVars.remove(shared);
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
        if (atom instanceof BoundConstraint) {
            BoundConstraint bc = (BoundConstraint)atom;
            LinVar v = bc.getVar();
            v.mConstraints.remove(bc.getBound());
        } else if (atom instanceof LAEquality) {
            LAEquality laeq = (LAEquality)atom;
            InfinitNumber num = new InfinitNumber(laeq.getBound(), 0);
            laeq.getVar().mEqualities.remove(num);
            for (CCEquality eq : laeq.getDependentEqualities()) {
                eq.removeLASharedData();
            }
        }
    }

    @Override
    public void pop(Object object, int targetlevel) {
        ArrayList<LinVar> removeVars = new ArrayList<LinVar>();
        for (LinVar v : this.mLinvars) {
            if (v.mAssertionstacklevel <= targetlevel) continue;
            removeVars.add(v);
        }
        for (LinVar v : this.mSimps.keySet()) {
            if (v.mAssertionstacklevel <= targetlevel) continue;
            removeVars.add(v);
        }
        for (LinVar v : removeVars) {
            this.mOob.remove(v);
            this.mPropBounds.remove(v);
            if (v.mDead) {
                this.mSimps.remove(v);
            } else {
                this.removeLinVar(v);
            }
            if (v == this.mConflictVar) {
                this.mConflictVar = null;
            }
            v.mAssertionstacklevel = -1;
            if (!v.isInt()) continue;
            this.mIntVars.remove(v);
        }
        this.mSharedVars.endScope();
        this.mTerms.endScope();
        this.mSuggestions.clear();
        this.mProplist.clear();
        assert (this.popPost());
    }

    private final boolean popPost() {
        for (Map.Entry<LinVar, TreeMap<LinVar, Rational>> me : this.mSimps.entrySet()) {
            assert (me.getKey().mDead);
            for (Map.Entry<LinVar, Rational> me2 : me.getValue().entrySet()) {
                assert (!me2.getKey().mDead);
                assert (!this.mSimps.containsKey(me2.getKey()));
                assert (!me2.getValue().equals(Rational.ZERO));
            }
        }
        return true;
    }

    @Override
    public Object push() {
        this.mTerms.beginScope();
        this.mSharedVars.beginScope();
        return null;
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":LA", new Object[][]{{"Pivot", this.mNumPivots}, {"PivotBland", this.mNumPivotsBland}, {"SwitchToBland", this.mNumSwitchToBland}, {"Vars", this.mLinvars.size()}, {"SimpVars", this.mSimps == null ? 0 : this.mSimps.size()}, {"CompLits", this.mCompositeCreateLit}, {"Cuts", this.mNumCuts}, {"Branches", this.mNumBranches}, {"Times", new Object[][]{{"Pivot", this.mPivotTime / 1000000L}, {"BoundComp", this.mPropBoundTime / 1000000L}, {"BoundSet", this.mPropBoundSetTime / 1000000L}, {"BoundBack", this.mBacktrackPropTime / 1000000L}, {"CutGen", this.mCutGenTime / 1000000L}}}}};
    }

    private LinVar findBestVar() {
        LinVar best = null;
        for (LinVar v : this.mOob) {
            if (best != null && best.mChainlength <= v.mChainlength) continue;
            best = v;
        }
        if (best != null) {
            this.mOob.remove(best);
        }
        return best;
    }

    private MatrixEntry findNonBasic(LinVar basic, boolean isLower) {
        assert (basic.mBasic);
        MatrixEntry best = null;
        boolean unboundedSide = false;
        MatrixEntry entry = basic.mHeadEntry.mNextInRow;
        while (entry != basic.mHeadEntry) {
            boolean checkLower;
            LinVar col = entry.mColumn;
            if (col.mUpper == null && col.mLower == null) {
                return entry;
            }
            boolean bl = checkLower = isLower == entry.mCoeff.signum() < 0;
            if (checkLower) {
                if (col.mLower == null) {
                    if (unboundedSide && best.mColumn.mChainlength > col.mChainlength) {
                        best = entry;
                    } else {
                        best = entry;
                        unboundedSide = true;
                    }
                } else if (!unboundedSide && col.isDecrementPossible() && (best == null || best.mColumn.mChainlength > col.mChainlength)) {
                    best = entry;
                }
            } else if (col.mUpper == null) {
                if (unboundedSide && best.mColumn.mChainlength > col.mChainlength) {
                    best = entry;
                } else {
                    best = entry;
                    unboundedSide = true;
                }
            } else if (!unboundedSide && col.isIncrementPossible() && (best == null || best.mColumn.mChainlength > col.mChainlength)) {
                best = entry;
            }
            entry = entry.mNextInRow;
        }
        return best;
    }

    private FunctionSymbol getsValueFromLA(Term term) {
        ApplicationTerm at;
        if (term instanceof ApplicationTerm && (at = (ApplicationTerm)term).getParameters().length == 0) {
            return at.getFunction();
        }
        return null;
    }

    @Override
    public void fillInModel(Model model, Theory t, SharedTermEvaluator ste) {
        this.prepareModel();
        for (LinVar linVar : this.mLinvars) {
            Term term;
            FunctionSymbol fsym;
            if (linVar.isInitiallyBasic() || (fsym = this.getsValueFromLA(term = linVar.getSharedTerm().getTerm())) == null) continue;
            Rational val = this.realValue(linVar);
            model.extendNumeric(fsym, val);
        }
        if (this.mSimps != null) {
            for (Map.Entry entry : this.mSimps.entrySet()) {
                Term term;
                FunctionSymbol fsym;
                LinVar var = (LinVar)entry.getKey();
                if (var.isInitiallyBasic() || (fsym = this.getsValueFromLA(term = var.getSharedTerm().getTerm())) == null) continue;
                Rational val = Rational.ZERO;
                for (Map.Entry chain : ((TreeMap)entry.getValue()).entrySet()) {
                    val = val.add(this.realValue((LinVar)chain.getKey()).mul((Rational)chain.getValue()));
                }
                model.extendNumeric(fsym, val);
            }
        }
    }

    private static class UnsimpData {
        LinVar mVar;
        Rational mFac;

        public UnsimpData(LinVar v, Rational f) {
            this.mVar = v;
            this.mFac = f;
        }
    }
}

