/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.math.BigInteger;

public class MatrixEntry {
    BigInteger mCoeff;
    LinVar mRow;
    LinVar mColumn;
    MatrixEntry mPrevInRow;
    MatrixEntry mNextInRow;
    MatrixEntry mPrevInCol;
    MatrixEntry mNextInCol;

    public void insertRow(LinVar nb, BigInteger value) {
        assert (this.mRow.mHeadEntry == this);
        assert (this.mRow == this.mColumn);
        assert (nb != this.mRow);
        assert (!value.equals(BigInteger.ZERO));
        MatrixEntry ptr = this.mNextInRow;
        int poscmp = Integer.MAX_VALUE - this.mColumn.mMatrixpos;
        while (ptr.mColumn.mMatrixpos + poscmp < nb.mMatrixpos + poscmp) {
            ptr = ptr.mNextInRow;
        }
        if (ptr.mColumn == nb) {
            assert (ptr != this);
            ptr.mCoeff = ptr.mCoeff.add(value);
            if (ptr.mCoeff.equals(BigInteger.ZERO)) {
                ptr.removeFromMatrix();
            }
        } else {
            ptr.insertBefore(nb, value);
        }
    }

    public void insertBefore(LinVar col, BigInteger value) {
        assert (!value.equals(BigInteger.ZERO));
        MatrixEntry newEntry = new MatrixEntry();
        newEntry.mColumn = col;
        newEntry.mRow = this.mRow;
        newEntry.mCoeff = value;
        newEntry.mNextInRow = this;
        newEntry.mPrevInRow = this.mPrevInRow;
        newEntry.mNextInCol = col.mHeadEntry.mNextInCol;
        newEntry.mPrevInCol = col.mHeadEntry;
        this.mPrevInRow.mNextInRow = newEntry;
        this.mPrevInRow = newEntry;
        col.mHeadEntry.mNextInCol.mPrevInCol = newEntry;
        col.mHeadEntry.mNextInCol = newEntry;
        ++this.mRow.mChainlength;
        ++col.mChainlength;
    }

    public void removeFromRow() {
        this.mPrevInRow.mNextInRow = this.mNextInRow;
        this.mNextInRow.mPrevInRow = this.mPrevInRow;
        --this.mRow.mChainlength;
    }

    public void removeFromColumn() {
        this.mPrevInCol.mNextInCol = this.mNextInCol;
        this.mNextInCol.mPrevInCol = this.mPrevInCol;
    }

    public void removeFromMatrix() {
        this.mPrevInRow.mNextInRow = this.mNextInRow;
        this.mNextInRow.mPrevInRow = this.mPrevInRow;
        this.mPrevInCol.mNextInCol = this.mNextInCol;
        this.mNextInCol.mPrevInCol = this.mPrevInCol;
        --this.mRow.mChainlength;
        --this.mColumn.mChainlength;
    }

    public void add(MatrixEntry other) {
        assert (this.mColumn == other.mColumn);
        BigInteger gcd = Rational.gcd(this.mCoeff, other.mCoeff);
        BigInteger tmul = other.mCoeff.divide(gcd);
        BigInteger omul = this.mCoeff.divide(gcd);
        if (tmul.signum() < 0) {
            tmul = tmul.negate();
        } else {
            omul = omul.negate();
        }
        assert (this.mCoeff.multiply(tmul).add(other.mCoeff.multiply(omul)).signum() == 0);
        this.mRow.mulUpperLower(Rational.valueOf(tmul, BigInteger.ONE));
        int poscmp = Integer.MAX_VALUE - this.mColumn.mMatrixpos;
        MatrixEntry trow = this.mNextInRow;
        MatrixEntry orow = other.mNextInRow;
        gcd = BigInteger.ZERO;
        while (orow != other) {
            while (trow.mColumn.mMatrixpos + poscmp < orow.mColumn.mMatrixpos + poscmp) {
                trow.mCoeff = trow.mCoeff.multiply(tmul);
                gcd = Rational.gcd(gcd, trow.mCoeff);
                trow = trow.mNextInRow;
            }
            BigInteger ocoeff = orow.mCoeff.multiply(omul);
            assert (!ocoeff.equals(BigInteger.ZERO));
            if (trow.mColumn == orow.mColumn) {
                BigInteger oldval = trow.mCoeff.multiply(tmul);
                trow.mCoeff = oldval.add(ocoeff);
                this.mRow.updateUpperLowerClear(oldval, trow.mColumn);
                if (trow.mCoeff.equals(BigInteger.ZERO)) {
                    trow.removeFromMatrix();
                } else {
                    gcd = Rational.gcd(gcd, trow.mCoeff);
                    this.mRow.updateUpperLowerSet(trow.mCoeff, trow.mColumn);
                }
                trow = trow.mNextInRow;
            } else {
                gcd = Rational.gcd(gcd, ocoeff);
                trow.insertBefore(orow.mColumn, ocoeff);
                this.mRow.updateUpperLowerSet(ocoeff, orow.mColumn);
            }
            orow = orow.mNextInRow;
        }
        while (trow != this) {
            trow.mCoeff = trow.mCoeff.multiply(tmul);
            gcd = Rational.gcd(gcd, trow.mCoeff);
            trow = trow.mNextInRow;
        }
        this.mRow.updateUpperLowerClear(this.mCoeff.multiply(tmul), trow.mColumn);
        gcd = gcd.abs();
        if (!gcd.equals(BigInteger.ONE)) {
            trow = this.mNextInRow;
            while (trow != this) {
                assert (trow.mCoeff.remainder(gcd).equals(BigInteger.ZERO));
                trow.mCoeff = trow.mCoeff.divide(gcd);
                trow = trow.mNextInRow;
            }
            this.mRow.mulUpperLower(Rational.valueOf(BigInteger.ONE, gcd));
        }
        this.removeFromMatrix();
        ++this.mColumn.mChainlength;
    }

    public void pivot() {
        this.mColumn.mHeadEntry.removeFromColumn();
        this.mColumn.mHeadEntry.mNextInCol = this.mColumn.mHeadEntry.mPrevInCol = this.mRow.mHeadEntry;
        this.mRow.mHeadEntry.mNextInCol = this.mRow.mHeadEntry.mPrevInCol = this.mColumn.mHeadEntry;
        this.mRow.mHeadEntry = this.mColumn.mHeadEntry;
        this.mRow.mHeadEntry.mColumn = this.mRow;
        this.mColumn.mHeadEntry = this;
        this.mColumn.mChainlength = this.mRow.mChainlength;
        this.mRow.mChainlength = 1;
        MatrixEntry entry = this;
        do {
            entry.mRow = this.mColumn;
        } while ((entry = entry.mNextInRow) != this);
    }

    public String rowToString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.mCoeff).append("*(").append(this.mColumn).append(')');
        MatrixEntry ptr = this.mNextInRow;
        while (ptr != this) {
            sb.append('+');
            sb.append(ptr.mCoeff).append("*(").append(ptr.mColumn).append(')');
            ptr = ptr.mNextInRow;
        }
        return sb.append("=0]").toString();
    }

    public String colToString() {
        StringBuilder sb = new StringBuilder("[");
        String comma = "";
        MatrixEntry ptr = this.mNextInCol;
        while (ptr != this) {
            sb.append(comma);
            sb.append('(').append(ptr.mRow).append(")->").append(ptr.mCoeff);
            comma = ",";
            ptr = ptr.mNextInCol;
        }
        return sb.append(']').toString();
    }

    public String toString() {
        if (this.mNextInRow == null) {
            return this.mColumn + ":" + this.colToString();
        }
        if (this.mRow == this.mColumn) {
            return this.rowToString();
        }
        return "[" + this.mRow + "/" + this.mColumn + "]->" + this.mCoeff;
    }
}

