/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java_cup.runtime.Symbol;
import java_cup.runtime.SymbolFactory;

public class MySymbolFactory
implements SymbolFactory {
    public Symbol newSymbol(String name, int id, int lline, int lcol, int rline, int rcol, Object value) {
        return new LineColumnSymbol(name, id, lline, lcol, rline, rcol, value);
    }

    public Symbol newSymbol(String name, int id, int lline, int lcol, int rline, int rcol) {
        return new LineColumnSymbol(name, id, lline, lcol, rline, rcol, null);
    }

    public Symbol newSymbol(String name, int id, Symbol left, Symbol right, Object value) {
        return new LineColumnSymbol(name, id, left, right, value);
    }

    public Symbol newSymbol(String name, int id, Symbol left, Symbol right) {
        return new LineColumnSymbol(name, id, left, right, null);
    }

    public Symbol newSymbol(String name, int id) {
        return new LineColumnSymbol(name, id, -1, -1, -1, -1, null);
    }

    public Symbol newSymbol(String name, int id, Object value) {
        return new LineColumnSymbol(name, id, -1, -1, -1, -1, value);
    }

    public Symbol startSymbol(String name, int id, int state) {
        LineColumnSymbol s = new LineColumnSymbol(name, id, state);
        return s;
    }

    public class LineColumnSymbol
    extends Symbol {
        private final String mName;
        private final int mLColumn;
        private final int mRColumn;

        public LineColumnSymbol(String name, int id, int state) {
            super(id, state);
            this.mName = name;
            this.mLColumn = -1;
            this.mRColumn = -1;
        }

        public LineColumnSymbol(String name, int id, int left, int lcolumn, int right, int rcolumn, Object o) {
            super(id, left, right, o);
            this.mName = name;
            this.mLColumn = lcolumn;
            this.mRColumn = rcolumn;
        }

        public LineColumnSymbol(String name, int id, Symbol left, Symbol right, Object o) {
            super(id, left, right, o);
            this.mName = name;
            this.mLColumn = left instanceof LineColumnSymbol ? ((LineColumnSymbol)left).mLColumn : 0;
            this.mRColumn = right instanceof LineColumnSymbol ? ((LineColumnSymbol)left).mRColumn : 0;
        }

        public String getLocation() {
            if (this.mLColumn >= 0) {
                return this.left + ":" + this.mLColumn;
            }
            return Integer.toString(this.left);
        }

        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "(" + this.mName + " " + this.left + ":" + this.mLColumn + "-" + this.right + ":" + this.mRColumn + ")";
        }
    }
}

