/*
 * Decompiled with CFR 0.152.
 */
package java_cup;

import java_cup.Grammar;
import java_cup.terminal;

public class terminal_set {
    private static final int LOG_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private long[] _elements;
    private Grammar _grammar;

    public terminal_set(Grammar grammar) {
        this._grammar = grammar;
        this._elements = new long[(grammar.num_terminals() - 1 >>> 6) + 1];
    }

    public terminal_set(terminal_set terminal_set2) {
        this(terminal_set2._grammar);
        this._elements = (long[])terminal_set2._elements.clone();
    }

    public boolean empty() {
        for (int i = 0; i < this._elements.length; ++i) {
            if (this._elements[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean contains(terminal terminal2) {
        return this.contains(terminal2.index());
    }

    public boolean contains(int n) {
        int n2 = n >> 6;
        long l = 1L << (n & 0x3F);
        return (this._elements[n2] & l) != 0L;
    }

    public boolean is_subset_of(terminal_set terminal_set2) {
        assert (terminal_set2._elements.length == this._elements.length);
        for (int i = 0; i < this._elements.length; ++i) {
            if ((this._elements[i] & (terminal_set2._elements[i] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean add(terminal terminal2) {
        long l;
        int n = terminal2.index();
        int n2 = n >> 6;
        boolean bl = (this._elements[n2] & (l = 1L << (n & 0x3F))) == 0L;
        int n3 = n2;
        this._elements[n3] = this._elements[n3] | l;
        return bl;
    }

    public void remove(terminal terminal2) {
        int n = terminal2.index();
        int n2 = n >> 6;
        long l = 1L << (n & 0x3F);
        int n3 = n2;
        this._elements[n3] = this._elements[n3] & (l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean add(terminal_set terminal_set2) {
        assert (terminal_set2._elements.length == this._elements.length);
        boolean bl = false;
        for (int i = 0; i < this._elements.length; ++i) {
            if (((this._elements[i] ^ 0xFFFFFFFFFFFFFFFFL) & terminal_set2._elements[i]) != 0L) {
                bl = true;
            }
            int n = i;
            this._elements[n] = this._elements[n] | terminal_set2._elements[i];
        }
        return bl;
    }

    public boolean intersects(terminal_set terminal_set2) {
        assert (terminal_set2._elements.length == this._elements.length);
        for (int i = 0; i < this._elements.length; ++i) {
            if ((this._elements[i] & terminal_set2._elements[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean equals(terminal_set terminal_set2) {
        assert (terminal_set2._elements.length == this._elements.length);
        for (int i = 0; i < this._elements.length; ++i) {
            if (this._elements[i] == terminal_set2._elements[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof terminal_set)) {
            return false;
        }
        return this.equals((terminal_set)object);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._elements.length; ++i) {
            n = 13 * n + 157 * (int)(this._elements[i] >> 16) + (int)this._elements[i];
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        String string = "";
        for (int i = 0; i < this._grammar.num_terminals(); ++i) {
            if (!this.contains(i)) continue;
            stringBuilder.append(string).append(this._grammar.get_terminal(i));
            string = ", ";
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

