/*
 * Decompiled with CFR 0.152.
 */
package jsylvan;

import java.util.ArrayList;

public class JSylvan {
    private static long zero;
    private static long one;
    private static JSylvan instance;

    public static void initialize(long workers, long stacksize, int tablesize, int cachesize, int granularity) {
        if (instance != null) {
            throw new RuntimeException("JSylvan already initialized!");
        }
        instance = new JSylvan();
        JSylvan.initLace(workers, stacksize);
        JSylvan.initSylvan(tablesize, cachesize, granularity);
    }

    public static long getTrue() {
        return one;
    }

    public static long getFalse() {
        return zero;
    }

    public static native long makeVar(int var0);

    public static native long makeNot(long var0);

    public static native long makeAnd(long var0, long var2);

    public static native long makeOr(long var0, long var2);

    public static native long makeImplies(long var0, long var2);

    public static native long makeIte(long var0, long var2, long var4);

    public static native long makeEquals(long var0, long var2);

    public static native long makeNotEquals(long var0, long var2);

    public static native long makeExists(long var0, long var2);

    public static native long makeNext(long var0, long var2, long var4);

    public static native long makeUnionPar(long[] var0);

    public static native long makeConstrain(long var0, long var2);

    public static native long makeRestrict(long var0, long var2);

    public static native long ref(long var0);

    public static native void deref(long var0);

    public static native int getVar(long var0);

    public static native long getIf(long var0);

    public static native long getThen(long var0);

    public static native long getElse(long var0);

    public static native void print(long var0);

    public static native void fprint(String var0, long var1);

    public static native void printDot(long var0);

    public static native void fprintDot(String var0, long var1);

    public static native void disableGC();

    public static native void enableGC();

    public static native double satcount(long var0, long var2);

    public static native long nodecount(long var0);

    public static native long makeSupport(long var0);

    public static long makeSet(int[] variables) {
        long result = zero;
        for (int i = 0; i < variables.length; ++i) {
            long var = JSylvan.ref(JSylvan.makeVar(variables[i]));
            long old = JSylvan.ref(result);
            result = JSylvan.makeOr(result, var);
            JSylvan.deref(var);
            JSylvan.deref(old);
        }
        return result;
    }

    public static int[] fromSet(long bdd) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        while (bdd != zero) {
            if (bdd == one) {
                throw new RuntimeException("not a BDD set");
            }
            temp.add(JSylvan.getVar(bdd));
            bdd = JSylvan.getElse(bdd);
        }
        int[] res = new int[temp.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Integer)temp.get(i);
        }
        return res;
    }

    private JSylvan() {
    }

    private static native void initLace(long var0, long var2);

    private static native void initSylvan(int var0, int var1, int var2);

    static {
        instance = null;
    }
}

