/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.sei.rtss.jldd;

import edu.cmu.sei.rtss.jldd.swig.CIntArray;
import edu.cmu.sei.rtss.jldd.swig.JLDD;
import edu.cmu.sei.rtss.jldd.swig.theory_t;
import edu.toronto.cs.expr.BindOp;
import edu.toronto.cs.expr.BoolOp;
import edu.toronto.cs.expr.ComparisonOp;
import edu.toronto.cs.expr.Expr;
import edu.toronto.cs.expr.ExprFactory;
import edu.toronto.cs.expr.NumericOp;
import edu.toronto.cs.expr.Operator;
import edu.toronto.cs.expr.RationalOp;
import edu.toronto.cs.expr.SimpleTypeOp;
import edu.toronto.cs.expr.TupleOp;
import edu.toronto.cs.expr.VariableOp;
import edu.toronto.cs.util.StopWatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class LDDBuilder {
    protected Map<Expr, Integer> vm;
    protected List<Expr> vl;
    protected ExprFactory eFac;
    protected Expr zero;
    protected int ldd;
    protected int ldd_true;
    protected theory_t theory;
    boolean useCache = false;
    boolean doStats = true;
    LinkedList<Map<Expr, Integer>> scopes;
    Map<String, StopWatch> stats = new HashMap<String, StopWatch>();
    private StopWatch boolClock;
    private StopWatch quantClock;
    private StopWatch numQuantClock;

    public LDDBuilder(int _ldd, ExprFactory ef) {
        this(_ldd, ef, false, false);
    }

    public LDDBuilder(int _ldd, ExprFactory ef, boolean _useCache, boolean _doStats) {
        this.vm = new HashMap<Expr, Integer>();
        this.vl = new ArrayList<Expr>();
        this.ldd = _ldd;
        this.theory = JLDD.jldd_get_theory(this.ldd);
        this.ldd_true = JLDD.Ldd_GetTrue(this.ldd);
        this.eFac = ef;
        this.zero = this.eFac.intExpr(0L);
        this.useCache = _useCache;
        this.doStats = _doStats;
        this.scopes = new LinkedList();
        if (this.doStats) {
            this.initClocks();
        }
    }

    public Map<String, StopWatch> getStats() {
        return this.stats;
    }

    private void initClocks() {
        this.boolClock = new StopWatch();
        this.boolClock.pause();
        this.stats.put("Bool", this.boolClock);
        this.quantClock = new StopWatch();
        this.quantClock.pause();
        this.stats.put("BoolQuant", this.quantClock);
        this.numQuantClock = new StopWatch();
        this.numQuantClock.pause();
        this.stats.put("NumQuant", this.numQuantClock);
    }

    public Expr toExpr(int n) {
        int N = JLDD.jldd_regular(n);
        if (N == this.ldd_true) {
            return N == n ? this.eFac.trueExpr() : this.eFac.falseExpr();
        }
        HashMap<Integer, Expr> cache = new HashMap<Integer, Expr>();
        Expr res = this.toExprRecur(n, cache);
        Iterator i$ = cache.keySet().iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            JLDD.jldd_recursive_deref(this.ldd, k);
        }
        return res;
    }

    protected Expr toExprRecur(int n, Map<Integer, Expr> cache) {
        int N = JLDD.jldd_regular(n);
        Expr res = null;
        res = N == this.ldd_true ? this.eFac.trueExpr() : cache.get(N);
        if (res != null) {
            return N == n ? res : BoolOp.lnot((Expr)res);
        }
        Expr c = this.exprFromCons(JLDD.Ldd_GetCons(this.ldd, N));
        res = this.lite(c, this.toExprRecur(JLDD.jldd_T(n), cache), this.toExprRecur(JLDD.jldd_E(n), cache));
        JLDD.jldd_ref(N);
        cache.put(N, res);
        return N == n ? res : BoolOp.not((Expr)res);
    }

    private Expr lite(Expr c, Expr t, Expr e) {
        if (t == e) {
            return t;
        }
        if (BoolOp.isTrue((Expr)c)) {
            return t;
        }
        if (BoolOp.isFalse((Expr)c)) {
            return e;
        }
        if (BoolOp.isTrue((Expr)t) && BoolOp.isFalse((Expr)e)) {
            return c;
        }
        if (BoolOp.isFalse((Expr)t) && BoolOp.isTrue((Expr)e)) {
            return BoolOp.lnot((Expr)c);
        }
        return BoolOp.ite((Expr)c, (Expr)t, (Expr)e);
    }

    protected Expr exprFromCons(int lincons) {
        ComparisonOp op = this.theory.is_strict(lincons) != 0 ? ComparisonOp.LT : ComparisonOp.LEQ;
        return this.eFac.op((Operator)op).binApply(this.exprFromTerm(this.theory.get_term(lincons)), this.exprFromCst(this.theory.get_constant(lincons)));
    }

    protected Expr exprFromCst(int cst) {
        return this.eFac.ratExpr((long)this.theory.cst_get_si_num(cst), (long)this.theory.cst_get_si_den(cst));
    }

    protected Expr exprFromTerm(int t) {
        Expr[] coeffs = new Expr[this.theory.term_size(t)];
        for (int i = 0; i < coeffs.length; ++i) {
            coeffs[i] = this.lmult(this.exprFromCst(this.theory.term_get_coeff(t, i)), this.numVar(this.theory.term_get_var(t, i)));
        }
        return coeffs.length > 1 ? NumericOp.plus((Expr[])coeffs) : coeffs[0];
    }

    private Expr lmult(Expr cst, Expr var) {
        if (RationalOp.getN((Expr)cst) == 1L && RationalOp.getD((Expr)cst) == 1L) {
            return var;
        }
        return NumericOp.mult((Expr)cst, (Expr)var);
    }

    public int eval(Expr expr) {
        IdentityHashMap<Expr, Integer> cache = new IdentityHashMap<Expr, Integer>();
        int res = this.eval(expr, cache);
        JLDD.jldd_ref(res);
        for (Integer n : cache.values()) {
            JLDD.jldd_recursive_deref(this.ldd, n);
        }
        JLDD.jldd_deref(res);
        return res;
    }

    protected int eval(Expr e, Map<Expr, Integer> cache) {
        Integer v;
        int res = 0;
        if (BoolOp.isNot((Expr)e)) {
            return JLDD.jldd_not(this.eval(e.arg(0), cache));
        }
        if (BoolOp.isTrue((Expr)e)) {
            return this.ldd_true;
        }
        if (BoolOp.isFalse((Expr)e)) {
            return JLDD.jldd_not(this.ldd_true);
        }
        if (this.useCache && (v = cache.get(e)) != null) {
            return v;
        }
        if (BindOp.isScope((Expr)e)) {
            this.pushScope();
            LinkedList<Expr> decls = new LinkedList<Expr>();
            if (BindOp.isBind((Expr)BindOp.getScopeDecls((Expr)e))) {
                decls.add(BindOp.getScopeDecls((Expr)e));
            } else {
                decls.addAll(BindOp.getScopeDecls((Expr)e).args());
            }
            for (Expr decl : decls) {
                assert (BindOp.isBind((Expr)decl));
                int t1 = this.eval(BindOp.value((Expr)decl), cache);
                JLDD.jldd_ref(t1);
                this.declare(BindOp.name((Expr)decl), t1);
            }
            decls = null;
            res = this.eval(BindOp.getScopeBody((Expr)e), cache);
            JLDD.jldd_ref(res);
            this.popScope();
        } else if (BoolOp.isAnd((Expr)e)) {
            res = this.ldd_true;
            JLDD.jldd_ref(res);
            for (Expr arg : e.args()) {
                int t1 = this.eval(arg, cache);
                JLDD.jldd_ref(t1);
                if (this.doStats) {
                    this.boolClock.resume();
                }
                int t2 = JLDD.Ldd_And(this.ldd, t1, res);
                if (this.doStats) {
                    this.boolClock.pause();
                }
                JLDD.jldd_ref(t2);
                JLDD.jldd_recursive_deref(this.ldd, t1);
                JLDD.jldd_recursive_deref(this.ldd, res);
                res = t2;
            }
        } else if (BoolOp.isOr((Expr)e)) {
            res = JLDD.jldd_not(this.ldd_true);
            JLDD.jldd_ref(res);
            for (Expr arg : e.args()) {
                int t1 = this.eval(arg, cache);
                JLDD.jldd_ref(t1);
                if (this.doStats) {
                    this.boolClock.resume();
                }
                int t2 = JLDD.Ldd_Or(this.ldd, t1, res);
                if (this.doStats) {
                    this.boolClock.pause();
                }
                JLDD.jldd_ref(t2);
                JLDD.jldd_recursive_deref(this.ldd, t1);
                JLDD.jldd_recursive_deref(this.ldd, res);
                res = t2;
            }
        } else if (BoolOp.isImpl((Expr)e)) {
            int t1 = this.eval(e.arg(0), cache);
            JLDD.jldd_ref(t1);
            int t2 = this.eval(e.arg(1), cache);
            JLDD.jldd_ref(t2);
            if (this.doStats) {
                this.boolClock.resume();
            }
            res = JLDD.Ldd_Or(this.ldd, JLDD.jldd_not(t1), t2);
            if (this.doStats) {
                this.boolClock.pause();
            }
            JLDD.jldd_ref(res);
            JLDD.jldd_recursive_deref(this.ldd, t1);
            JLDD.jldd_recursive_deref(this.ldd, t2);
        } else if (BoolOp.isLpmi((Expr)e)) {
            int t1 = this.eval(e.arg(0), cache);
            JLDD.jldd_ref(t1);
            int t2 = this.eval(e.arg(1), cache);
            JLDD.jldd_ref(t2);
            if (this.doStats) {
                this.boolClock.resume();
            }
            res = JLDD.Ldd_Or(this.ldd, t1, JLDD.jldd_not(t2));
            if (this.doStats) {
                this.boolClock.pause();
            }
            JLDD.jldd_ref(res);
            JLDD.jldd_recursive_deref(this.ldd, t1);
            JLDD.jldd_recursive_deref(this.ldd, t2);
        } else if (BoolOp.isIte((Expr)e)) {
            int t1 = this.eval(e.arg(0), cache);
            JLDD.jldd_ref(t1);
            int t2 = this.eval(e.arg(1), cache);
            JLDD.jldd_ref(t2);
            int t3 = this.eval(e.arg(2), cache);
            JLDD.jldd_ref(t3);
            if (this.doStats) {
                this.boolClock.resume();
            }
            res = JLDD.Ldd_Ite(this.ldd, t1, t2, t3);
            if (this.doStats) {
                this.boolClock.pause();
            }
            JLDD.jldd_ref(res);
            JLDD.jldd_recursive_deref(this.ldd, t1);
            JLDD.jldd_recursive_deref(this.ldd, t2);
            JLDD.jldd_recursive_deref(this.ldd, t3);
        } else if (BoolOp.isXor((Expr)e) || BoolOp.isIff((Expr)e)) {
            int t1 = this.eval(e.arg(0), cache);
            JLDD.jldd_ref(t1);
            int t2 = this.eval(e.arg(1), cache);
            JLDD.jldd_ref(t2);
            if (this.doStats) {
                this.boolClock.resume();
            }
            res = JLDD.Ldd_Xor(this.ldd, t1, t2);
            if (this.doStats) {
                this.boolClock.pause();
            }
            JLDD.jldd_ref(res);
            if (BoolOp.isIff((Expr)e)) {
                res = JLDD.jldd_not(res);
            }
            JLDD.jldd_recursive_deref(this.ldd, t1);
            JLDD.jldd_recursive_deref(this.ldd, t2);
        } else if (BoolOp.isForall((Expr)e) || BoolOp.isExists((Expr)e)) {
            CIntArray vars;
            int varsLength;
            int tmp = this.eval(e.arg(1), cache);
            JLDD.jldd_ref(tmp);
            if (TupleOp.isTuple((Expr)e.arg(0))) {
                int i = 0;
                varsLength = e.arg(0).args().size();
                vars = new CIntArray(varsLength);
                for (Expr a : e.arg(0).args()) {
                    vars.setitem(i++, this.findVarNum(a));
                }
            } else {
                varsLength = 1;
                vars = new CIntArray(varsLength);
                vars.setitem(0, this.findVarNum(e.arg(0)));
            }
            if (this.doStats) {
                if (varsLength == 1) {
                    this.quantClock.resume();
                } else {
                    this.numQuantClock.resume();
                }
            }
            if (BoolOp.isForall((Expr)e)) {
                tmp = JLDD.jldd_not(tmp);
            }
            res = JLDD.Ldd_MvExistAbstract(this.ldd, tmp, vars.cast(), varsLength);
            if (BoolOp.isForall((Expr)e)) {
                res = JLDD.jldd_not(res);
            }
            JLDD.jldd_ref(res);
            JLDD.jldd_recursive_deref(this.ldd, tmp);
            vars.delete();
            if (this.doStats) {
                if (varsLength == 1) {
                    this.quantClock.pause();
                } else {
                    this.numQuantClock.pause();
                }
            }
        } else if (e.op().getClass() == ComparisonOp.class) {
            res = this.evalConstraint(e);
            JLDD.jldd_ref(res);
        } else {
            res = this.isInScope(e) ? this.lookup(e) : this.evalConstraint(ComparisonOp.leq((Expr)e, (Expr)this.zero));
            JLDD.jldd_ref(res);
        }
        if (res != 0) {
            if (this.useCache) {
                cache.put(e, res);
            } else {
                JLDD.jldd_deref(res);
            }
        }
        return res;
    }

    protected int lookup(Expr e) {
        for (Map map : this.scopes) {
            Integer r = (Integer)map.get(e);
            if (r == null) continue;
            return r;
        }
        throw new NoSuchElementException("Not in scope: " + e);
    }

    protected void declare(Expr var, int f) {
        assert (!this.scopes.isEmpty());
        this.scopes.getFirst().put(var, f);
    }

    protected boolean isInScope(Expr e) {
        for (Map map : this.scopes) {
            if (!map.containsKey(e)) continue;
            return true;
        }
        return false;
    }

    protected void pushScope() {
        this.scopes.addFirst(new IdentityHashMap());
    }

    protected void popScope() {
        Map<Expr, Integer> scope = this.scopes.removeFirst();
        for (int i : scope.values()) {
            JLDD.jldd_recursive_deref(this.ldd, i);
        }
    }

    protected int evalConstraint(Expr exp) {
        if (!RationalOp.isRat((Expr)exp.arg(1))) {
            Expr lhs = exp.arg(0);
            Expr rhs = exp.arg(1);
            assert (!NumericOp.isPlus((Expr)lhs)) : "Cannot rearrange: " + exp;
            if (NumericOp.isMult((Expr)rhs) && RationalOp.isRat((Expr)rhs.arg(0))) {
                assert (rhs.arity() == 2) : "Cannot handle: " + exp;
                rhs = NumericOp.mult((Expr)this.eFac.ratExpr(-RationalOp.getN((Expr)rhs.arg(0)), RationalOp.getD((Expr)rhs.arg(1))), (Expr)rhs.arg(1));
            } else {
                rhs = NumericOp.mult((Expr)this.eFac.ratExpr(-1L, 1L), (Expr)rhs);
            }
            return this.evalConstraint(this.eFac.op(exp.op()).binApply(NumericOp.plus((Expr)lhs, (Expr)rhs), this.zero));
        }
        if (ComparisonOp.isGt((Expr)exp)) {
            return JLDD.jldd_not(this.evalConstraint(ComparisonOp.leq((Expr)exp.arg(0), (Expr)exp.arg(1))));
        }
        if (ComparisonOp.isGeq((Expr)exp)) {
            return JLDD.jldd_not(this.evalConstraint(ComparisonOp.lt((Expr)exp.arg(0), (Expr)exp.arg(1))));
        }
        if (ComparisonOp.isEq((Expr)exp) || ComparisonOp.isNeq((Expr)exp)) {
            int t1 = this.evalConstraint(ComparisonOp.leq((Expr)exp.arg(0), (Expr)exp.arg(1)));
            JLDD.jldd_ref(t1);
            int t2 = this.evalConstraint(ComparisonOp.lt((Expr)exp.arg(0), (Expr)exp.arg(1)));
            JLDD.jldd_ref(t2);
            t2 = JLDD.jldd_not(t2);
            int t3 = JLDD.Ldd_And(this.ldd, t1, t2);
            JLDD.jldd_ref(t3);
            JLDD.jldd_recursive_deref(this.ldd, t1);
            JLDD.jldd_recursive_deref(this.ldd, t2);
            if (ComparisonOp.isNeq((Expr)exp)) {
                t3 = JLDD.jldd_not(t3);
            }
            JLDD.jldd_deref(t3);
            return t3;
        }
        CIntArray var = new CIntArray(2);
        for (int i = 0; i < 2; ++i) {
            var.setitem(i, -1);
        }
        CIntArray coeff = new CIntArray(2);
        for (int i = 0; i < 2; ++i) {
            coeff.setitem(i, 0);
        }
        Expr lhs = exp.arg(0);
        int pos = 0;
        if (NumericOp.isPlus((Expr)lhs)) {
            assert (lhs.arity() <= 2);
            for (Expr arg : lhs.args()) {
                this.setCoeff(arg, var, coeff, pos++);
            }
        } else {
            this.setCoeff(lhs, var, coeff, pos++);
        }
        assert (pos != 2 || var.getitem(0) != var.getitem(1)) : "Bad expression " + exp;
        if (pos == 2 && var.getitem(0) > var.getitem(1)) {
            int var0 = var.getitem(0);
            int var1 = var.getitem(1);
            var.setitem(0, var1);
            var.setitem(1, var0);
            int coeff0 = coeff.getitem(0);
            int coeff1 = coeff.getitem(1);
            coeff.setitem(0, coeff1);
            coeff.setitem(1, coeff0);
        }
        int term = this.theory.create_linterm_sparse(var.cast(), coeff.cast(), pos);
        coeff.delete();
        var.delete();
        assert (RationalOp.isRat((Expr)exp.arg(1))) : "Can't evaluate " + exp.arg(1) + " of " + exp;
        int cst = this.theory.create_rat_cst((int)RationalOp.getN((Expr)exp.arg(1)), (int)RationalOp.getD((Expr)exp.arg(1)));
        int cons = this.theory.create_cons(term, exp.op() == ComparisonOp.LEQ ? 0 : 1, cst);
        int res = JLDD.Ldd_FromCons(this.ldd, cons);
        this.theory.destroy_lincons(cons);
        return res;
    }

    private void setCoeff(Expr exp, CIntArray var, CIntArray coeff, int pos) {
        assert (0 <= pos && pos <= 2) : "Detected more than 2 variables per constraint!";
        if (!NumericOp.isMult((Expr)exp)) {
            var.setitem(pos, this.varNum(exp));
            coeff.setitem(pos, this.theory.create_int_cst(1));
        } else {
            Expr lhs = exp.arg(0);
            Expr rhs = exp.arg(1);
            assert (RationalOp.isRat((Expr)lhs) || RationalOp.isRat((Expr)rhs)) : "One of those is not a rational; lhs: " + lhs + ", rhs: " + rhs;
            if (RationalOp.isRat((Expr)rhs)) {
                lhs = exp.arg(1);
                rhs = exp.arg(0);
            }
            coeff.setitem(pos, this.theory.create_rat_cst(RationalOp.getN((Expr)lhs), RationalOp.getD((Expr)lhs)));
            var.setitem(pos, this.varNum(rhs));
        }
    }

    public int varNum(Expr exp) {
        Integer num = this.vm.get(exp);
        if (num != null) {
            return num;
        }
        int n = this.vm.size();
        assert (this.isLegalVar(exp)) : "Attempt to abstract away a non-variable: " + exp;
        this.vm.put(exp, n);
        this.vl.add(exp);
        return n;
    }

    protected boolean isLegalVar(Expr e) {
        if (VariableOp.isVar((Expr)e)) {
            return true;
        }
        if (BindOp.isBind((Expr)e) && (SimpleTypeOp.isRealT((Expr)BindOp.type((Expr)e)) || SimpleTypeOp.isIntT((Expr)BindOp.type((Expr)e)))) {
            return true;
        }
        return BindOp.isBoolVar((Expr)e);
    }

    public int findVarNum(Expr exp) throws UndeclaredVariableException {
        Integer num = this.vm.get(exp);
        if (num != null) {
            return num;
        }
        throw new UndeclaredVariableException("No binding for: " + exp + " with code " + System.identityHashCode(exp));
    }

    public Expr numVar(int i) {
        return this.vl.get(i);
    }

    public static class UndeclaredVariableException
    extends RuntimeException {
        private static final long serialVersionUID = 7991390147340403341L;

        public UndeclaredVariableException(String m) {
            super(m);
        }
    }
}

