/*
 * Decompiled with CFR 0.152.
 */
package jpl;

import java.io.File;
import jpl.Atom;
import jpl.Compound;
import jpl.Term;
import jpl.Version;
import jpl.fli.Prolog;

public class JPL {
    protected static final boolean DEBUG = false;
    public static final Term JFALSE = new Compound("@", new Term[]{new Atom("false")});
    public static final Term JTRUE = new Compound("@", new Term[]{new Atom("true")});
    public static final Term JNULL = new Compound("@", new Term[]{new Atom("null")});
    public static final Term JVOID = new Compound("@", new Term[]{new Atom("void")});
    protected static boolean modeDontTellMe = true;
    private static String nativeLibraryName = "jpl";
    private static String nativeLibraryDir = null;
    private static String nativeLibraryPath = null;
    private static final Version version_ = new Version();

    public static String setNativeLibraryName(String string) {
        if (string == null) {
            throw new NullPointerException("newName cannot be null");
        }
        String string2 = nativeLibraryName;
        nativeLibraryName = string;
        return string2;
    }

    public static String setNativeLibraryDir(String string) {
        String string2 = nativeLibraryDir;
        nativeLibraryDir = string;
        return string2;
    }

    public static String setNativeLibraryPath(String string) {
        String string2 = nativeLibraryPath;
        nativeLibraryPath = string;
        return string2;
    }

    public static void loadNativeLibrary() {
        if (nativeLibraryPath != null) {
            System.load(new File(nativeLibraryPath).getAbsolutePath());
        } else if (nativeLibraryDir != null) {
            System.load(new File(nativeLibraryDir, System.mapLibraryName(nativeLibraryName)).getAbsolutePath());
        } else {
            System.loadLibrary(nativeLibraryName);
        }
    }

    public static void setDTMMode(boolean bl) {
        modeDontTellMe = bl;
    }

    public static String[] getDefaultInitArgs() {
        return Prolog.get_default_init_args();
    }

    public static void setDefaultInitArgs(String[] stringArray) {
        Prolog.set_default_init_args(stringArray);
    }

    public static String[] getActualInitArgs() {
        return Prolog.get_actual_init_args();
    }

    public static boolean init(String[] stringArray) {
        return Prolog.set_default_init_args(stringArray) && JPL.init();
    }

    public static boolean init() {
        return Prolog.initialise();
    }

    public static boolean isTag(String string) {
        return string.length() == 22 && string.charAt(0) == 'J' && string.charAt(1) == '#' && Character.isDigit(string.charAt(2)) && Character.isDigit(string.charAt(3)) && Character.isDigit(string.charAt(4)) && Character.isDigit(string.charAt(5)) && Character.isDigit(string.charAt(6)) && Character.isDigit(string.charAt(7)) && Character.isDigit(string.charAt(8)) && Character.isDigit(string.charAt(9)) && Character.isDigit(string.charAt(10)) && Character.isDigit(string.charAt(11)) && Character.isDigit(string.charAt(12)) && Character.isDigit(string.charAt(13)) && Character.isDigit(string.charAt(14)) && Character.isDigit(string.charAt(15)) && Character.isDigit(string.charAt(16)) && Character.isDigit(string.charAt(17)) && Character.isDigit(string.charAt(18)) && Character.isDigit(string.charAt(19)) && Character.isDigit(string.charAt(20)) && Character.isDigit(string.charAt(21));
    }

    public static Term newJRef(Object object) {
        return new Compound("@", new Term[]{new Atom(Prolog.object_to_tag(object))});
    }

    public static void halt() {
        Prolog.halt(0);
    }

    public static Version version() {
        return version_;
    }

    public static String version_string() {
        return JPL.version_.major + "." + JPL.version_.minor + "." + JPL.version_.patch + "-" + JPL.version_.status;
    }

    public static void main(String[] stringArray) {
        System.out.println(JPL.version_string());
    }
}

