/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.io.IOException;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.BenchmarkClientFactory;
import org.sosy_lab.verifiercloud.client.applications.cpachecker.CPAcheckerClientFactory;
import org.sosy_lab.verifiercloud.client.applications.infoclient.InfoClientFactory;
import org.sosy_lab.verifiercloud.client.applications.interactive.InteractiveClientFactory;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.application.ProgramModeFactory;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.help.HelpFactory;
import org.sosy_lab.verifiercloud.master.MasterFactory;
import org.sosy_lab.verifiercloud.worker.WorkerFactory;

public enum Modes {
    MASTER("master", new MasterFactory()),
    WORKER("worker", new WorkerFactory()),
    BENCHMARK("benchmark", new BenchmarkClientFactory()),
    CPACHECKER("cpachecker", new CPAcheckerClientFactory()),
    CLIENT("client", new InteractiveClientFactory()),
    INFOCLIENT("infoclient", new InfoClientFactory()),
    HELP("help", new HelpFactory());

    private final String optionName;
    private final ProgramModeFactory factory;

    private Modes(String optionName, ProgramModeFactory programModeFactory) {
        this.optionName = optionName;
        this.factory = Preconditions.checkNotNull(programModeFactory);
    }

    public static Optional<Modes> getProgramModeFromString(String modeName) {
        for (Modes possibleModes : Modes.values()) {
            if (!possibleModes.matchesOption(modeName)) continue;
            return Optional.of(possibleModes);
        }
        return Optional.absent();
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getOptions() {
        return this.factory.getOptions();
    }

    public String getHelpText() {
        return this.factory.getHelpText();
    }

    public String getOptionDescription() {
        return this.factory.getOptionDescription();
    }

    public AbstractCloudModule createModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        return this.factory.createModule(commandLineArguments, userConfigurationPath);
    }

    public ImmutableCollection<ConfigurationHandler<?>> getConfigurationHandlers(Logger logger) {
        return this.factory.getConfigurationHandlers(logger);
    }

    private boolean matchesOption(String option) {
        return this.getOptionName().equalsIgnoreCase(option);
    }
}

