/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud;

import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.Modes;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.application.DefaultCommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.dependencies.SoftwareDependencyCheck;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationUtils;

public class VerifierCloud {
    public static void main(String[] args) throws IOException {
        String givenMode;
        Optional<Modes> possibleMode;
        Locale.setDefault(new Locale("en"));
        if (args.length == 0) {
            VerifierCloud.printHelpAndExit();
        }
        if (!(possibleMode = Modes.getProgramModeFromString(givenMode = args[0])).isPresent()) {
            VerifierCloud.printHelpAndExit();
        }
        CommandLineArguments commandLineArguments = VerifierCloud.getCommandLineArguments(args);
        Path config = VerifierCloud.getUserConfigurationPath();
        AbstractCloudModule module = possibleMode.get().createModule(commandLineArguments, config);
        try {
            module.initialize();
        }
        catch (ApplicationInitializationException e) {
            System.err.println("Failed to initialize program: " + e.getMessage());
            System.exit(1);
        }
        Injector appInjector = Guice.createInjector(module);
        if (!VerifierCloud.areSoftwareDependenciesMet(appInjector)) {
            return;
        }
        ApplicationService appService = appInjector.getInstance(ApplicationService.class);
        appService.start();
    }

    public static Path getUserConfigurationPath() {
        Path result = null;
        String configEnvVariable = System.getenv("VCLOUD_CONFIG");
        if (configEnvVariable == null) {
            result = Constants.DEFAULT_USER_CONFIGURATION_FOLDER;
        } else {
            try {
                result = Paths.get(configEnvVariable, new String[0]);
            }
            catch (InvalidPathException e) {
                System.err.println("Invalid configuration path given by enviroment variable VCLOUD_CONFIG");
                VerifierCloud.printHelpAndExit();
            }
        }
        return result;
    }

    private static boolean areSoftwareDependenciesMet(Injector appInjector) {
        SoftwareDependencyCheck softwareDependencyCheck = appInjector.getInstance(SoftwareDependencyCheck.class);
        Collection<String> missingPrograms = softwareDependencyCheck.determineMissingPrograms();
        if (!missingPrograms.isEmpty()) {
            Logger logger = appInjector.getInstance(Logger.class);
            for (String missingProgram : missingPrograms) {
                logger.logf(Level.SEVERE, "Required program %s is missing.", missingProgram);
            }
        }
        return missingPrograms.isEmpty();
    }

    private static CommandLineArguments getCommandLineArguments(String[] args) {
        HashMap<String, String> namedArguments = Maps.newHashMap();
        LinkedList<String> positionalArguments = Lists.newLinkedList();
        UnmodifiableIterator<String> parameterIt = Iterators.forArray(args);
        if (parameterIt.hasNext()) {
            parameterIt.next();
        }
        Optional<Object> lastArgumentKey = Optional.absent();
        boolean positionalArgumentsStarted = false;
        while (parameterIt.hasNext()) {
            String next = ((String)parameterIt.next()).trim();
            if (next.equals("--")) {
                positionalArgumentsStarted = true;
                if (!lastArgumentKey.isPresent()) continue;
                namedArguments.put((String)lastArgumentKey.get(), "true");
                lastArgumentKey = Optional.absent();
                continue;
            }
            if (positionalArgumentsStarted) {
                positionalArguments.add(next);
                continue;
            }
            if (next.startsWith("--")) {
                if (lastArgumentKey.isPresent()) {
                    namedArguments.put((String)lastArgumentKey.get(), "true");
                }
                String currentArgumentKey = next.replaceFirst("--", "");
                lastArgumentKey = Optional.of(currentArgumentKey);
                continue;
            }
            if (lastArgumentKey.isPresent()) {
                String value = next;
                namedArguments.put((String)lastArgumentKey.get(), value);
                lastArgumentKey = Optional.absent();
                continue;
            }
            VerifierCloud.printHelpAndExit();
        }
        if (lastArgumentKey.isPresent()) {
            namedArguments.put((String)lastArgumentKey.get(), "true");
        }
        return new DefaultCommandLineArguments(namedArguments, positionalArguments);
    }

    public static void printHelpAndExit() {
        String programPath = SystemInformationUtils.getLocalProgramFile().getFileName().toString();
        String programStart = "java -jar " + programPath + " ";
        System.out.println("Start programm with: " + programStart + " <mode> <options>\n");
        System.out.println("Available MODES:\n");
        for (Modes mode : Modes.values()) {
            System.out.println(mode.getOptionName() + " " + mode.getOptions() + '\n');
        }
        System.exit(0);
    }
}

