/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;

public abstract class Client
implements ConnectionEventHandler,
ApplicationService {
    protected final Logger logger;
    protected final MasterConnection masterConnection;

    @Inject
    public Client(MasterConnection masterConnection, Logger logger) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public void start() {
        this.logger.logf(Level.INFO, "Starting client.", new Object[0]);
        ListenableFuture<ClientAuthorizationState> futureConnectionState = this.masterConnection.connect();
        try {
            futureConnectionState.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.logf(Level.SEVERE, e, "Connection error: %s", e.getMessage());
            this.stop();
        }
    }

    @Override
    public void stop() {
        this.logger.logf(Level.INFO, "Stopping client.", new Object[0]);
        this.masterConnection.disconnectAndDisable();
    }

    @Override
    public abstract void onConnectionLost();
}

