/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications;

import com.google.inject.name.Names;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.client.files.BackEndClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.CacheStorageProvider;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.DefaultHashCodeCache;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCache;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCacheFileStorage;
import org.sosy_lab.verifiercloud.client.files.in_place.InPlaceClientFileStorage;
import org.sosy_lab.verifiercloud.client.network.ClientAPI;
import org.sosy_lab.verifiercloud.client.network.DefaultClientAPI;
import org.sosy_lab.verifiercloud.client.network.DefaultMasterConnection;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.results.ActiveRequests;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.client.run_storage.MemClientRunStorage;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.StopApplicationUncaughtExceptionHandler;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.DefaultConnectionBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorage;
import org.sosy_lab.verifiercloud.global.util.system.guice.OperatingSystemSpecificBindingsModule;

public abstract class ClientModule
extends AbstractCloudModule {
    public static final String CLIENT_CONFIG_FILE = "Config";
    private final Path clientCacheStoragePath;
    private final Path clientPermanentStoragePath;

    public ClientModule(Path userConfigurationPath) {
        this.clientPermanentStoragePath = userConfigurationPath.resolve("client");
        this.clientCacheStoragePath = this.clientPermanentStoragePath.resolve("cache");
    }

    @Override
    public void configure() {
        this.install(new OperatingSystemSpecificBindingsModule());
        this.bind(ClientFileStorage.class).to(HashCodeCacheFileStorage.class).asEagerSingleton();
        this.bind(BackEndClientFileStorage.class).to(InPlaceClientFileStorage.class).asEagerSingleton();
        this.bind(HashCodeCache.class).to(DefaultHashCodeCache.class).asEagerSingleton();
        this.bind(ClientRunStorage.class).to(MemClientRunStorage.class);
        this.bind(MasterConnection.class).to(DefaultMasterConnection.class);
        this.bind(ConnectionBuilder.class).to(DefaultConnectionBuilder.class);
        this.bind(PermanentStorage.class).annotatedWith(Names.named("cacheStorage")).toProvider(CacheStorageProvider.class).asEagerSingleton();
        this.bind(Path.class).annotatedWith(Names.named("clientCacheStoragePath")).toInstance(this.clientCacheStoragePath);
        this.bind(DefaultMasterConnection.class).asEagerSingleton();
        this.bind(ClientAPI.class).to(DefaultClientAPI.class).asEagerSingleton();
        this.bind(ActiveRequests.class).asEagerSingleton();
        this.bind(Thread.UncaughtExceptionHandler.class).to(StopApplicationUncaughtExceptionHandler.class);
    }

    protected Path getClientPermanentStoragePath() {
        return this.clientPermanentStoragePath;
    }

    protected Path getClientCacheStoragePath() {
        return this.clientCacheStoragePath;
    }
}

