/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.benchmarking;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.applications.Client;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.BenchmarkClientExitCodes;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.BenchmarkingClientException;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.Input;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.InputParser;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.OutputHandler;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.RunCollectionResult;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.AuthenticationFailedException;
import org.sosy_lab.verifiercloud.client.network.exceptions.InsufficientRightsException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunCanceledException;
import org.sosy_lab.verifiercloud.client.run_builders.BenchmarkRunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.client.run_builders.VisiblePathFilter;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.run.RunResult;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class BenchmarkClient
extends Client {
    private static final TimeInterval MAXIMUM_INPUT_READ_TIME = TimeInterval.minutes(2L);
    public static final String DELIMITER = "\\t";
    private static final String WORKER_OUTPUT_FILE = "cloudBenchmarkOutput.txt";
    private final SystemInformationProvider sysInfoProvider;
    private final ClientFileStorage fileStorage;
    private final ClientRunStorage clientRunStorage;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final boolean printNewFiles;
    private final ExecutorService executor;
    private Optional<Future<Input>> inputReader = Optional.absent();
    private final AtomicBoolean stopped = new AtomicBoolean(false);

    @Inject
    public BenchmarkClient(MasterConnection masterConnection, ClientRunStorage clientRunStorage, ClientFileStorage fileStorage, SystemInformationProvider sysInfoProvider, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @Named(value="print-new-files") boolean printNewFiles, Logger logger) throws IOException {
        super(masterConnection, logger);
        this.clientRunStorage = clientRunStorage;
        this.fileStorage = fileStorage;
        this.sysInfoProvider = sysInfoProvider;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.printNewFiles = printNewFiles;
        ThreadFactoryBuilder tb = new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-pool-%d").setUncaughtExceptionHandler(uncaughtExceptionHandler).setDaemon(true);
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.executor = Executors.newFixedThreadPool(availableProcessors, tb.build());
    }

    private Input readInput() throws BenchmarkingClientException {
        Future<Input> inputFuture = this.executor.submit(new InputParser(new InputStreamReader(System.in, Charsets.UTF_8)));
        this.inputReader = Optional.of(inputFuture);
        try {
            Input input;
            Input input2 = input = inputFuture.get(MAXIMUM_INPUT_READ_TIME.toSeconds(), TimeUnit.SECONDS);
            return input2;
        }
        catch (InterruptedException | TimeoutException e) {
            throw new BenchmarkingClientException("Failed to read input: " + e.getMessage(), BenchmarkClientExitCodes.INPUT_TIMEOUT_EXCEEDED);
        }
        catch (ExecutionException e) {
            throw new BenchmarkingClientException("Failed to read input.", e.getCause(), BenchmarkClientExitCodes.ANY_OTHER_FAILURE);
        }
        catch (CancellationException e) {
            throw new BenchmarkingClientException("Cancelled reading input.", e, BenchmarkClientExitCodes.ANY_OTHER_FAILURE);
        }
        finally {
            this.inputReader = Optional.absent();
        }
    }

    @Override
    public void start() {
        super.start();
        Thread.currentThread().setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        if (!this.stopped.get()) {
            try {
                this.fileStorage.initialize();
            }
            catch (IOException | PermanentStorageException e) {
                this.logger.logf(Level.WARNING, "Can not initialize the file storage: %s", e.getMessage());
                this.stop(BenchmarkClientExitCodes.FILE_STORAGE_INITIALIZATION_FAILURE);
                return;
            }
            try {
                this.authenticate();
                Input input = this.readInput();
                input.validateInput();
                this.logger.logf(Level.FINE, "Finished input reading.", new Object[0]);
                Path workerOutputFile = BenchmarkClient.getUnambiguousWorkerOutputFile(input);
                RunCollectionResult runCollectionResult = this.createAndSendRunCollection(input, workerOutputFile);
                OutputHandler outputHandler = new OutputHandler(this.printNewFiles, this.masterConnection, this.executor, this.logger, workerOutputFile, input.getBenchmarkResultDirectory());
                outputHandler.createAndWriteOutput(runCollectionResult);
            }
            catch (BenchmarkingClientException e) {
                this.logger.logf(Level.WARNING, "Benchmark execution failed: %s", e.getMessage());
                this.stop(e.getExitCode());
                return;
            }
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stop();
        }
    }

    private RunCollectionResult createAndSendRunCollection(Input input, Path workerOutputFile) throws BenchmarkingClientException {
        RunCollection benchmarkRunCollection;
        BenchmarkRunCollectionBuilder runCollectionBuilder = new BenchmarkRunCollectionBuilder(this.fileStorage, input, new VisiblePathFilter(), workerOutputFile, this.logger);
        try {
            benchmarkRunCollection = runCollectionBuilder.createRunCollection();
        }
        catch (RunCollectionCreationException e) {
            throw new BenchmarkingClientException("Can not create run collection: " + e.getMessage(), e, BenchmarkClientExitCodes.ANY_OTHER_FAILURE);
        }
        this.logger.logf(Level.INFO, "Send run collection.", new Object[0]);
        List<CheckedFuture<RunResult, RunCanceledException>> runResults = this.sendRunCollections(benchmarkRunCollection);
        RunCollectionResult runCollectionResult = new RunCollectionResult(runCollectionBuilder.getRunToOutputFileNameMap(), runResults);
        return runCollectionResult;
    }

    private static Path getUnambiguousWorkerOutputFile(Input input) {
        Path workerOutputFile = input.getTransferFilesBaseDirectory().resolve(WORKER_OUTPUT_FILE);
        while (Files.exists(workerOutputFile, new LinkOption[0])) {
            workerOutputFile = input.getTransferFilesBaseDirectory().resolve(workerOutputFile.getFileName() + "_");
        }
        return input.getTransferFilesBaseDirectory().relativize(workerOutputFile);
    }

    private List<CheckedFuture<RunResult, RunCanceledException>> sendRunCollections(RunCollection benchRunCollection) throws BenchmarkingClientException {
        ArrayList<CheckedFuture<RunResult, RunCanceledException>> runResults = Lists.newArrayList();
        try {
            runResults.addAll(this.masterConnection.sendRunCollection(benchRunCollection, false));
        }
        catch (InsufficientRightsException e) {
            throw new BenchmarkingClientException("Insufficient rights to perform action: " + e.getMessage(), BenchmarkClientExitCodes.RIGHTS_EXCEPTION);
        }
        return runResults;
    }

    private void authenticate() throws BenchmarkingClientException {
        if (!this.masterConnection.isConnected()) {
            throw new BenchmarkingClientException("Master not connected.", BenchmarkClientExitCodes.CONNECTION_LOST);
        }
        CheckedFuture<ClientAuthorizationState, AuthenticationFailedException> authState = this.masterConnection.authenticate(ClientAccessLevel.USER, this.sysInfoProvider.getUsername());
        try {
            switch ((ClientAuthorizationState)((Object)authState.get(60L, TimeUnit.SECONDS))) {
                case DISCONNECTED: {
                    this.logger.logf(Level.WARNING, "The client version is not compatible with the master.", new Object[0]);
                    throw new BenchmarkingClientException("Authentication failed. Disconnected!", BenchmarkClientExitCodes.CONNECTION_LOST);
                }
                case UNAUTHORIZED: {
                    throw new BenchmarkingClientException("Authentication failure: Authorization failed.", BenchmarkClientExitCodes.AUTHENTICATION_FAILURE);
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new BenchmarkingClientException("Authentication failure: " + e.getMessage(), e, BenchmarkClientExitCodes.AUTHENTICATION_FAILURE);
        }
        catch (TimeoutException e) {
            throw new BenchmarkingClientException("Authentication timeout.", e, BenchmarkClientExitCodes.AUTHENTICATION_FAILURE);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.stopped.getAndSet(true)) {
            super.stop();
            if (this.inputReader.isPresent()) {
                this.inputReader.get().cancel(true);
            }
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void stop(BenchmarkClientExitCodes reason) {
        this.stop();
        System.exit(reason.exitCode());
    }

    @Override
    public void onConnectionLost() {
        this.logger.logf(Level.WARNING, "Connection to master closed.", new Object[0]);
        this.clientRunStorage.markAllAsCanceled(new Exception("Connection lost."));
        if (!this.stopped.get()) {
            this.stop(BenchmarkClientExitCodes.CONNECTION_LOST);
        }
    }
}

