/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.benchmarking;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.BenchmarkClientModule;
import org.sosy_lab.verifiercloud.client.configuration.benchmark.BenchmarkClientConfiguration;
import org.sosy_lab.verifiercloud.client.configuration.common.ClientConfiguration;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.application.ProgramModeFactory;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.util.TableFormatter;

public class BenchmarkClientFactory
implements ProgramModeFactory {
    @Override
    public String getHelpText() {
        return "This mode is used by the benchmark.py script to start the cloud and run several verifier tasks. It uses a protocol to read the necessary information from stdin. For more detailed information about this see README.txt.";
    }

    @Override
    public AbstractCloudModule createModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        return new BenchmarkClientModule(commandLineArguments, userConfigurationPath);
    }

    @Override
    public String getOptionDescription() {
        TableFormatter formatter = new TableFormatter(2, 0);
        for (ConfigurationOption configurationOption : ClientConfiguration.getConfigurationOptions()) {
            formatter.addRow("--" + configurationOption.getName(), configurationOption.getDescription());
        }
        for (ConfigurationOption configurationOption : BenchmarkClientConfiguration.getConfigurationOptions()) {
            formatter.addRow("--" + configurationOption.getName(), configurationOption.getDescription());
        }
        return formatter.buildTable();
    }

    @Override
    public ImmutableCollection<ConfigurationHandler<?>> getConfigurationHandlers(Logger logger) {
        return ImmutableList.of(new DefaultConfigurationHandler<ClientConfiguration>(ClientConfiguration.getDefaultConfigurationBuilder(), logger), new DefaultConfigurationHandler<BenchmarkClientConfiguration>(BenchmarkClientConfiguration.getDefaultConfigurationBuilder(), logger));
    }

    @Override
    public String getOptions() {
        return ClientConfiguration.getOptions() + BenchmarkClientConfiguration.getOptions();
    }
}

