/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.benchmarking;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sosy_lab.verifiercloud.Modes;
import org.sosy_lab.verifiercloud.client.applications.ClientModule;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.BenchmarkClient;
import org.sosy_lab.verifiercloud.client.configuration.benchmark.BenchmarkClientConfiguration;
import org.sosy_lab.verifiercloud.client.configuration.common.ClientConfiguration;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.InitialLogger;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;

public class BenchmarkClientModule
extends ClientModule {
    private static final String BENCHMARK_CLIENT_CONFIG_FILE = "BenchmarkClient_Config";
    private final CommandLineArguments commandLineArguments;
    private ClientConfiguration configuration;
    private BenchmarkClientConfiguration bechmarkConfiguration;
    private final InitialLogger logger;

    public BenchmarkClientModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        super(userConfigurationPath);
        this.commandLineArguments = Preconditions.checkNotNull(commandLineArguments);
        this.logger = LoggerBuilder.createInitialLogger();
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        DefaultConfigurationHandler<ClientConfiguration> clientConfigHandler = new DefaultConfigurationHandler<ClientConfiguration>(ClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
        DefaultConfigurationHandler<BenchmarkClientConfiguration> benchmarkClientConfigHandler = new DefaultConfigurationHandler<BenchmarkClientConfiguration>(BenchmarkClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
        DefaultPermanentStorage permanentStorage = new DefaultPermanentStorage(this.getClientPermanentStoragePath(), this.logger);
        try {
            permanentStorage.initialize();
            permanentStorage.parseFile("Config", clientConfigHandler);
            permanentStorage.parseFile(BENCHMARK_CLIENT_CONFIG_FILE, benchmarkClientConfigHandler);
            CommandLineArguments remainingParameters = clientConfigHandler.claimParameters(this.commandLineArguments);
            remainingParameters = benchmarkClientConfigHandler.claimParameters(remainingParameters);
            if (!remainingParameters.isEmpty()) {
                this.printHelpAndThrowException();
            }
            this.configuration = (ClientConfiguration)clientConfigHandler.getParseResult();
            this.bechmarkConfiguration = (BenchmarkClientConfiguration)benchmarkClientConfigHandler.getParseResult();
            LoggerBuilder.create().logToStdOut(this.configuration.getLogLevel()).injectInto(this.logger);
        }
        catch (InvalidOptionException | PermanentStorageException e) {
            throw new ApplicationInitializationException(e.getMessage());
        }
        BenchmarkClientModule.requireMasterHostname(this.configuration.getMasterHostName());
        AbstractFileContent.setDeserializationPath(Paths.get(Constants.DEFAULT_VCLOUD_FOLDER, new String[0]).resolve("BigFileContentTmp"));
        AbstractFileContent.setWriteRepresentationOnDeserialisation(false);
    }

    private void printHelpAndThrowException() throws ApplicationInitializationException {
        if (this.commandLineArguments.getNamedArguments().containsKey("help")) {
            System.out.println("Use '" + Modes.HELP.getOptionName() + " " + "--" + Modes.BENCHMARK.getOptionName() + "'.");
        }
        System.out.println("Available options for benchmerk client:\n" + ClientConfiguration.getOptions() + BenchmarkClientConfiguration.getOptions());
        throw new ApplicationInitializationException("Invalid parameter given.");
    }

    @Override
    public void configure() {
        super.configure();
        this.install(this.configuration);
        this.install(this.bechmarkConfiguration);
        this.bind(ApplicationService.class).to(BenchmarkClient.class);
        this.bind(ConnectionEventHandler.class).to(BenchmarkClient.class);
        this.bind(BenchmarkClient.class).asEagerSingleton();
        this.bind(Logger.class).toInstance(this.logger);
    }
}

