/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.benchmarking;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;

public class FixedLineIterable
implements Iterable<String> {
    private final BufferedReader inputStream;
    private final int numberOfLines;
    private int lineCounter = 0;
    private final AtomicBoolean iteratorCalled = new AtomicBoolean(false);

    public FixedLineIterable(BufferedReader inputStream, int numberOfLines) {
        this.inputStream = Preconditions.checkNotNull(inputStream);
        this.numberOfLines = Preconditions.checkNotNull(numberOfLines);
    }

    @Override
    public Iterator<String> iterator() {
        Preconditions.checkState(!this.iteratorCalled.getAndSet(true), "Multiple calls are not supported.");
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return FixedLineIterable.this.lineCounter < FixedLineIterable.this.numberOfLines;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                FixedLineIterable.this.lineCounter++;
                try {
                    return FixedLineIterable.this.inputStream.readLine();
                }
                catch (IOException e) {
                    throw new UncheckedExecutionException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

