/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.benchmarking;

import com.google.common.base.Optional;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.BenchmarkClientExitCodes;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.BenchmarkingClientException;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;

public class Input {
    private final Iterable<String> runDefinitions;
    private final Path benchmarkResultDirectory;
    private final Path transferFilesBaseDirectory;
    private final List<String> toolPaths;
    private final Path executingDir;
    private final Requirements requirements;
    private final FileFilter resultFilesFilter;
    private final Optional<SchedulingPriority> priority;

    public Input(Iterable<String> runDefinitions, Path benchmarkResultDirectory, Path transferFilesBaseDirectory, List<String> toolPaths, Path executingDir, Requirements requirements, FileFilter resultFilesFilter, Optional<SchedulingPriority> priority) {
        this.runDefinitions = runDefinitions;
        this.benchmarkResultDirectory = benchmarkResultDirectory;
        this.transferFilesBaseDirectory = transferFilesBaseDirectory;
        this.toolPaths = toolPaths;
        this.executingDir = executingDir;
        this.requirements = requirements;
        this.resultFilesFilter = resultFilesFilter;
        this.priority = priority;
    }

    public void validateInput() throws BenchmarkingClientException {
        if (!Files.isDirectory(this.transferFilesBaseDirectory, new LinkOption[0])) {
            throw new BenchmarkingClientException(this.transferFilesBaseDirectory + " is not a valid base directory.", BenchmarkClientExitCodes.INVALID_INPUT);
        }
        if (!Files.isDirectory(this.benchmarkResultDirectory, new LinkOption[0])) {
            throw new BenchmarkingClientException(this.benchmarkResultDirectory + " is not a valid benchmark directory.", BenchmarkClientExitCodes.INVALID_INPUT);
        }
        if (this.toolPaths.size() == 0) {
            throw new BenchmarkingClientException("No tool path given.", BenchmarkClientExitCodes.INVALID_INPUT);
        }
        if (!Files.isDirectory(this.executingDir, new LinkOption[0])) {
            throw new BenchmarkingClientException(this.executingDir + " is not a valid execution directory.", BenchmarkClientExitCodes.INVALID_INPUT);
        }
    }

    public Iterable<String> getRunDefinitions() {
        return this.runDefinitions;
    }

    public Path getBenchmarkResultDirectory() {
        return this.benchmarkResultDirectory;
    }

    public Path getTransferFilesBaseDirectory() {
        return this.transferFilesBaseDirectory;
    }

    public List<String> getToolPaths() {
        return this.toolPaths;
    }

    public Path getExecutingDir() {
        return this.executingDir;
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    public FileFilter getResultFilesFilter() {
        return this.resultFilesFilter;
    }

    public Optional<SchedulingPriority> getPriority() {
        return this.priority;
    }

    public int hashCode() {
        return Objects.hash(this.benchmarkResultDirectory, this.executingDir, this.requirements, this.toolPaths, this.transferFilesBaseDirectory, this.priority);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Input)) {
            return false;
        }
        Input other = (Input)obj;
        return this.benchmarkResultDirectory.equals(other.benchmarkResultDirectory) && this.executingDir.equals(other.executingDir) && this.requirements.equals(other.requirements) && this.toolPaths.equals(other.toolPaths) && this.transferFilesBaseDirectory.equals(other.transferFilesBaseDirectory) && this.priority.equals(other.priority);
    }
}

