/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.benchmarking;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.FixedLineIterable;
import org.sosy_lab.verifiercloud.client.applications.benchmarking.Input;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.RequirementsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.NoneFileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.PatternFileFilter;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

final class InputParser
implements Callable<Input> {
    private final BufferedReader inputStream;

    public InputParser(Reader inputStream) {
        this.inputStream = new BufferedReader(Preconditions.checkNotNull(inputStream));
    }

    @Override
    public Input call() throws Exception {
        Requirements requirements;
        String toolPathsLine = this.nextLine();
        ArrayList<String> toolPaths = Lists.newArrayList();
        toolPaths.addAll(Lists.newArrayList(toolPathsLine.split("\\t")));
        String pathsLine = this.nextLine();
        String[] paths = pathsLine.split("\\t");
        if (paths.length < 3) {
            throw new IllegalArgumentException("Relative base, output or executing directory path not given.");
        }
        Path transferFilesBaseDirectory = Paths.get(paths[0], new String[0]);
        Path benchmarkResultDirectory = Paths.get(paths[1], new String[0]);
        Path executingDir = Paths.get(paths[2], new String[0]);
        try {
            String requirementsLine = this.nextLine();
            requirements = this.parseRequirements(requirementsLine);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid requirements.", e);
        }
        FileFilter resultFilesFilter = new NoneFileFilter();
        String line = this.nextLine();
        if (!line.matches("^[0-9]+.*$")) {
            resultFilesFilter = PatternFileFilter.forWildcardPattern(line);
            line = this.nextLine();
        }
        String[] numberOfLinesAndPrioity = line.split("\\t");
        Integer numOfLines = Integer.valueOf(numberOfLinesAndPrioity[0]);
        Optional<SchedulingPriority> priority = Optional.absent();
        if (numberOfLinesAndPrioity.length >= 2) {
            String priorityString = numberOfLinesAndPrioity[1].toUpperCase();
            try {
                priority = Optional.of(SchedulingPriority.valueOf(priorityString));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid prioity: " + priorityString + ". " + "Valid vlaues: " + Arrays.toString((Object[])SchedulingPriority.values()));
            }
        }
        FixedLineIterable runDefinitions = new FixedLineIterable(this.inputStream, numOfLines);
        Input input = new Input(runDefinitions, benchmarkResultDirectory, transferFilesBaseDirectory, toolPaths, executingDir, requirements, resultFilesFilter, priority);
        return input;
    }

    private Requirements parseRequirements(String requirementsLine) throws IllegalArgumentException {
        RequirementsBuilder builder;
        String[] requirementsTokens = requirementsLine.split("\\t");
        if (requirementsTokens.length >= 2) {
            try {
                MemoryUnit memory = MemoryUnit.megabyte(Integer.parseInt(requirementsTokens[0]));
                int coreRequirements = Integer.parseInt(requirementsTokens[1]);
                builder = RequirementsBuilder.withProcessors(coreRequirements).setMemoryRequirements(memory);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
            if (requirementsTokens.length >= 3) {
                List<String> cpuRequirements = Splitter.on(",").splitToList(requirementsTokens[2]);
                builder.setCpuRequirements(cpuRequirements);
            }
        } else {
            throw new IllegalArgumentException("Too few requirements arguments");
        }
        builder.requireCgroups();
        return builder.build();
    }

    private String nextLine() throws IOException {
        String line = this.inputStream.readLine();
        Preconditions.checkArgument(line != null);
        return line;
    }
}

