/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.benchmarking;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.StringTokenizer;

public class RunResultParser {
    public EnumMap<Columns, String> parse(String output) {
        EnumMap<Columns, String> result = new EnumMap<Columns, String>(Columns.class);
        StringTokenizer lines = new StringTokenizer(output, "\n");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            String[] lineTokens = line.split("\\s+");
            if (lineTokens[0].matches("")) {
                lineTokens = Arrays.copyOfRange(lineTokens, 1, lineTokens.length);
            }
            if (lineTokens.length < 2) continue;
            switch (lineTokens[0]) {
                case "Walltime:": {
                    result.put(Columns.walltime, lineTokens[1]);
                    break;
                }
                case "CpuTime:": {
                    result.put(Columns.cputime, lineTokens[1]);
                    break;
                }
                case "Number": {
                    this.handleBeginnWithNumber(result, lineTokens);
                    break;
                }
                case "Verification": {
                    if (!lineTokens[1].equals("result:")) break;
                    String status = lineTokens[2].split("\\.")[0];
                    result.put(Columns.status, status);
                    break;
                }
                case "Time": {
                    this.handleBeginWithTime(result, lineTokens);
                    break;
                }
            }
        }
        return result;
    }

    private void handleBeginWithTime(EnumMap<Columns, String> result, String[] lineTokens) {
        if (lineTokens.length >= 5 && lineTokens[1].equals("for")) {
            switch (lineTokens[2]) {
                case "transfer": {
                    result.put(Columns.transfer_time, lineTokens[4]);
                    break;
                }
                case "merge": {
                    result.put(Columns.merge_time, lineTokens[4]);
                    break;
                }
                case "stop": {
                    result.put(Columns.stop_time, lineTokens[4]);
                    break;
                }
            }
        }
    }

    private void handleBeginnWithNumber(EnumMap<Columns, String> result, String[] lineTokens) {
        if (lineTokens.length >= 5 && lineTokens[1].equals("of") && lineTokens[2].equals("times")) {
            switch (lineTokens[3]) {
                case "merged:": {
                    result.put(Columns.merges, lineTokens[4]);
                    break;
                }
                case "stopped:": {
                    result.put(Columns.stops, lineTokens[4]);
                    break;
                }
            }
        }
    }

    public static enum Columns {
        status,
        cputime,
        walltime,
        total,
        reached,
        merges,
        stops,
        merge_time,
        stop_time,
        transfer_time,
        cpa_time,
        os,
        cpu,
        ram;

    }
}

