/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.cpachecker;

import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.sosy_lab.verifiercloud.Modes;
import org.sosy_lab.verifiercloud.client.applications.ClientModule;
import org.sosy_lab.verifiercloud.client.applications.cpachecker.CPAcheckerClient;
import org.sosy_lab.verifiercloud.client.configuration.common.ClientConfiguration;
import org.sosy_lab.verifiercloud.client.configuration.cpachecker.CPAcheckerConfiguration;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.InitialLogger;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;

public class CPAcheckerClientModule
extends ClientModule {
    public static final String COMMAND = "command";
    private static final String CPACHECKER_CONFIG_FILE = "CPAchecker.config";
    private ClientConfiguration clientConfiguration;
    private CPAcheckerConfiguration cpaConfiguration;
    private final CommandLineArguments commandLineArguments;
    private final InitialLogger logger;

    public CPAcheckerClientModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) {
        super(userConfigurationPath);
        this.commandLineArguments = Preconditions.checkNotNull(commandLineArguments);
        this.logger = LoggerBuilder.createInitialLogger();
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        DefaultPermanentStorage permanentStorage = new DefaultPermanentStorage(this.getClientPermanentStoragePath(), this.logger);
        try {
            permanentStorage.initialize();
            DefaultConfigurationHandler<ClientConfiguration> clientConfHandler = new DefaultConfigurationHandler<ClientConfiguration>(ClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
            permanentStorage.parseFile("Config", clientConfHandler);
            DefaultConfigurationHandler<CPAcheckerConfiguration> cpaCheckerConfHandler = new DefaultConfigurationHandler<CPAcheckerConfiguration>(CPAcheckerConfiguration.getDefaultConfigurationBuilder(), this.logger);
            permanentStorage.parseFile(CPACHECKER_CONFIG_FILE, cpaCheckerConfHandler);
            CommandLineArguments remainingParameters = clientConfHandler.claimParameters(this.commandLineArguments);
            remainingParameters = cpaCheckerConfHandler.claimParameters(remainingParameters);
            if (!remainingParameters.getNamedArguments().isEmpty()) {
                this.printHelpAndThrowException();
            }
            this.clientConfiguration = (ClientConfiguration)clientConfHandler.getParseResult();
            this.cpaConfiguration = (CPAcheckerConfiguration)cpaCheckerConfHandler.getParseResult();
        }
        catch (InvalidOptionException | PermanentStorageException e) {
            throw new ApplicationInitializationException(e.getMessage());
        }
        LoggerBuilder.create().logToStdOut(this.clientConfiguration.getLogLevel()).injectInto(this.logger);
        CPAcheckerClientModule.requireMasterHostname(this.clientConfiguration.getMasterHostName());
        AbstractFileContent.setDeserializationPath(Paths.get(Constants.DEFAULT_VCLOUD_FOLDER, new String[0]).resolve("BigFileContentTmp"));
        AbstractFileContent.setWriteRepresentationOnDeserialisation(false);
    }

    private void printHelpAndThrowException() throws ApplicationInitializationException {
        if (this.commandLineArguments.getNamedArguments().containsKey("help")) {
            System.out.println("Use '" + Modes.HELP.getOptionName() + " " + "--" + Modes.CPACHECKER.getOptionName() + "'.");
        }
        System.out.println("Available options for CPAchecker client:\n" + ClientConfiguration.getOptions() + CPAcheckerConfiguration.getOptions());
        throw new ApplicationInitializationException("Invalid parameter given.");
    }

    @Override
    public void configure() {
        super.configure();
        this.install(this.clientConfiguration);
        this.install(this.cpaConfiguration);
        this.bind(new TypeLiteral<List<String>>(){}).annotatedWith(Names.named(COMMAND)).toInstance(this.commandLineArguments.getPositionalArguments());
        this.bind(ApplicationService.class).to(CPAcheckerClient.class);
        this.bind(ConnectionEventHandler.class).to(CPAcheckerClient.class);
        this.bind(CPAcheckerClient.class).asEagerSingleton();
        this.bind(Logger.class).toInstance(this.logger);
    }
}

