/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.cpachecker;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.run_builders.MultiFileRunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.RequirementsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.filters.PatternFileFilter;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class CPAcheckerRunCollectionProvider {
    protected static final RelativePath OUTPUT_FILE = StringRelativePath.from("output.txt");
    private final Path cpacheckerDir;
    private final Path inputFile;
    private final List<String> command;
    private final ImmutableSet<String> requiredFiles;
    private final TimeInterval timeLimit;
    private final MemoryUnit memoryRequirementLimitation;
    private final Integer cores;
    private final ClientFileStorage clientFileStorage;
    private final Logger logger;
    private final SchedulingPriority priority;
    private final Optional<String> username;
    private final ImmutableList<String> cpuModel;
    private final PatternFileFilter resultFileFilter;

    @Inject
    public CPAcheckerRunCollectionProvider(ClientFileStorage clientFileStorage, Logger logger, @Named(value="cpachecker-dir") Path cpacheckerDir, @Named(value="command") List<String> command, @Named(value="input") Path inputFile, @Named(value="requiredFiles") ImmutableSet<String> requiredFiles, @Named(value="timeLimitation") TimeInterval timeLimit, @Named(value="cpu-model") ImmutableList<String> cpuModel, @Named(value="memory-requirement-limitation") MemoryUnit memoryRequirementLimitation, @Named(value="priority") SchedulingPriority priority, @Named(value="cores-requirement-limitation") Integer cores, @Named(value="resultFilePattern") String resultFilePattern, @Named(value="username") Optional<String> username) {
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.logger = logger;
        this.cpacheckerDir = Preconditions.checkNotNull(cpacheckerDir);
        this.command = Preconditions.checkNotNull(command);
        this.inputFile = Preconditions.checkNotNull(inputFile);
        this.requiredFiles = Preconditions.checkNotNull(requiredFiles);
        this.timeLimit = Preconditions.checkNotNull(timeLimit);
        this.cpuModel = Preconditions.checkNotNull(cpuModel);
        this.memoryRequirementLimitation = Preconditions.checkNotNull(memoryRequirementLimitation);
        this.priority = Preconditions.checkNotNull(priority);
        this.resultFileFilter = PatternFileFilter.forWildcardPattern(resultFilePattern);
        this.username = username;
        Preconditions.checkArgument(cores >= 1);
        this.cores = cores;
    }

    public RunCollection createCPAcheckerRunCollection() throws IOException, RunCollectionCreationException {
        if (!Files.isDirectory(this.cpacheckerDir, new LinkOption[0])) {
            throw new RunCollectionCreationException("Cannot find CPAchecker dir: " + this.cpacheckerDir);
        }
        Path realCPAcheckerPath = this.cpacheckerDir.toRealPath(new LinkOption[0]).toAbsolutePath();
        Path realInputPath = this.inputFile.toRealPath(new LinkOption[0]).toAbsolutePath();
        Path basePath = this.getBasePath(realCPAcheckerPath, realInputPath).toAbsolutePath();
        Path relativeRunExecutionPath = basePath.relativize(realCPAcheckerPath);
        Limitations limitations = LimitationsBuilder.from(this.timeLimit).setCoreLimit(this.cores).setMemoryLimit(this.memoryRequirementLimitation).build();
        Requirements requirements = RequirementsBuilder.withProcessors(this.cores).setMemoryRequirements(this.memoryRequirementLimitation).setCpuRequirements(this.cpuModel).build();
        MultiFileRunCollectionBuilder runBuilder = new MultiFileRunCollectionBuilder(this.command, this.clientFileStorage, limitations, requirements, relativeRunExecutionPath, OUTPUT_FILE, this.resultFileFilter, this.logger);
        for (String requiredFile : this.requiredFiles) {
            Path file = realCPAcheckerPath.resolve(requiredFile);
            if (!Files.exists(file, new LinkOption[0])) {
                throw new RunCollectionCreationException(file.toString() + " does not exist. " + this.cpacheckerDir.toAbsolutePath().normalize() + " is not a CPAchecker trunk.");
            }
            runBuilder.addProgramFiles(file, basePath);
        }
        if (this.username.isPresent()) {
            runBuilder.setAnnotation("User: " + this.username.get());
        }
        runBuilder.addInputFiles(realInputPath, basePath);
        runBuilder.setPriority(this.priority);
        return runBuilder.createRunCollection();
    }

    private Path getBasePath(Path path1, Path path2) {
        Path pathPart2;
        Path pathPart1;
        Iterator<Path> it1 = path1.iterator();
        Iterator<Path> it2 = path2.iterator();
        Path path = Paths.get(File.separator, new String[0]);
        while (it1.hasNext() && it2.hasNext() && (pathPart1 = it1.next()).equals(pathPart2 = it2.next())) {
            path = path.resolve(pathPart1);
        }
        return path;
    }
}

