/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.infoclient;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.applications.Client;
import org.sosy_lab.verifiercloud.client.applications.infoclient.OutputFailedException;
import org.sosy_lab.verifiercloud.client.applications.infoclient.formatting.InfoClientOutputFormat;
import org.sosy_lab.verifiercloud.client.applications.infoclient.formatting.OutputFormatter;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.AuthenticationFailedException;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class InfoClient
extends Client {
    private final TimeInterval TIMEOUT = TimeInterval.seconds(30L);
    private final InfoClientOutputFormat format;
    private final Optional<Path> outputTarget;
    private final Optional<TimeInterval> repetitionInterval;
    private final SystemInformationProvider sysInfoProvider;
    private final Timer outputRepetitionTimer = new Timer("InfoClientTimer", false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private OutputFormatter outputFormatter;

    @Inject
    public InfoClient(MasterConnection masterConnection, Logger logger, SystemInformationProvider sysInfoProvider, @Named(value="format") InfoClientOutputFormat format, @Named(value="output") Optional<Path> output, @Named(value="interval") Optional<TimeInterval> repetitionInterval) {
        super(masterConnection, logger);
        this.sysInfoProvider = sysInfoProvider;
        this.format = Preconditions.checkNotNull(format);
        this.outputTarget = Preconditions.checkNotNull(output);
        this.repetitionInterval = Preconditions.checkNotNull(repetitionInterval);
    }

    private boolean fetchAndWriteInformation() {
        if (!this.masterConnection.isConnected()) {
            this.logger.logf(Level.SEVERE, "Connection to master lost", new Object[0]);
            return false;
        }
        CheckedFuture<MasterSummary, MasterSummaryNotRetrievableException> masterSummaryFuture = this.masterConnection.getMasterSummary();
        MasterSummary masterSummary = null;
        try {
            masterSummary = masterSummaryFuture.checkedGet(this.TIMEOUT.toSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException | MasterSummaryNotRetrievableException e) {
            this.logger.logf(Level.SEVERE, "Cannot retrieve master summary: %s", e.getMessage());
            return false;
        }
        try {
            this.writeOutput(this.outputFormatter.generateOutput(masterSummary));
        }
        catch (OutputFailedException e) {
            this.logger.logf(Level.SEVERE, "Failed to write results: %s", e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void start() {
        super.start();
        if (!this.masterConnection.isConnected()) {
            return;
        }
        this.outputFormatter = this.format.createFormatter(this.masterConnection.getMasterHostName(), this.repetitionInterval, this.logger);
        CheckedFuture<ClientAuthorizationState, AuthenticationFailedException> authenticate = this.masterConnection.authenticate(ClientAccessLevel.USER, this.sysInfoProvider.getUsername());
        try {
            authenticate.checkedGet(this.TIMEOUT.toSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException | AuthenticationFailedException e) {
            this.logger.logf(Level.SEVERE, "Authentication failure: %s", e.getMessage());
            this.stop();
            return;
        }
        if (this.repetitionInterval.isPresent()) {
            this.outputRepetitionTimer.schedule((TimerTask)new OutputTask(), 0L, this.repetitionInterval.get().toMilliseconds());
        } else {
            this.fetchAndWriteInformation();
            this.stop();
        }
    }

    private void writeOutput(String output) throws OutputFailedException {
        if (this.outputTarget.isPresent()) {
            Path actualTarget = this.outputTarget.get();
            try {
                Files.write(actualTarget, output.getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
            catch (AccessDeniedException e) {
                throw new OutputFailedException("Write access to " + actualTarget + " denied.");
            }
            catch (IOException e) {
                throw new OutputFailedException(e.getMessage());
            }
        } else {
            System.out.println(output);
        }
    }

    @Override
    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            super.stop();
            this.outputRepetitionTimer.cancel();
        }
    }

    @Override
    public void onConnectionLost() {
        this.stop();
    }

    private class OutputTask
    extends TimerTask {
        private OutputTask() {
        }

        @Override
        public void run() {
            if (!InfoClient.this.fetchAndWriteInformation()) {
                InfoClient.this.stop();
            }
        }
    }
}

