/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.infoclient;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.Modes;
import org.sosy_lab.verifiercloud.client.applications.ClientModule;
import org.sosy_lab.verifiercloud.client.applications.infoclient.InfoClient;
import org.sosy_lab.verifiercloud.client.configuration.common.ClientConfiguration;
import org.sosy_lab.verifiercloud.client.configuration.infoclient.InfoClientConfiguration;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.InitialLogger;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;

public class InfoClientModule
extends ClientModule {
    private static final String INFO_CLIENT_CONFIG_FILE = "InfoClient_Config";
    private ClientConfiguration clientConfiguration;
    private InfoClientConfiguration infoClientConfiguration;
    private final CommandLineArguments commandLineArguments;
    private InitialLogger logger;

    public InfoClientModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        super(userConfigurationPath);
        this.commandLineArguments = Preconditions.checkNotNull(commandLineArguments);
        this.logger = LoggerBuilder.createInitialLogger();
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        DefaultPermanentStorage permanentStorage = new DefaultPermanentStorage(this.getClientPermanentStoragePath(), this.logger);
        try {
            permanentStorage.initialize();
            DefaultConfigurationHandler<ClientConfiguration> clientConfHandler = new DefaultConfigurationHandler<ClientConfiguration>(ClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
            DefaultConfigurationHandler<InfoClientConfiguration> infoClientConfHandler = new DefaultConfigurationHandler<InfoClientConfiguration>(InfoClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
            permanentStorage.parseFile("Config", clientConfHandler);
            permanentStorage.parseFile(INFO_CLIENT_CONFIG_FILE, infoClientConfHandler);
            CommandLineArguments remainingArguments = clientConfHandler.claimParameters(this.commandLineArguments);
            remainingArguments = infoClientConfHandler.claimParameters(remainingArguments);
            if (!remainingArguments.isEmpty()) {
                this.printHelpAndThrowException();
            }
            this.clientConfiguration = (ClientConfiguration)clientConfHandler.getParseResult();
            this.infoClientConfiguration = (InfoClientConfiguration)infoClientConfHandler.getParseResult();
            LoggerBuilder.create().logToStdError(this.clientConfiguration.getLogLevel()).injectInto(this.logger);
        }
        catch (InvalidOptionException | PermanentStorageException e) {
            throw new ApplicationInitializationException(e.getMessage());
        }
        InfoClientModule.requireMasterHostname(this.clientConfiguration.getMasterHostName());
    }

    private void printHelpAndThrowException() throws ApplicationInitializationException {
        if (this.commandLineArguments.getNamedArguments().containsKey("help")) {
            System.out.println("Use '" + Modes.HELP.getOptionName() + " " + "--" + Modes.INFOCLIENT.getOptionName() + "'.");
        }
        System.out.println("Available options for InfoClient:\n" + ClientConfiguration.getOptions() + InfoClientConfiguration.getOptions());
        throw new ApplicationInitializationException("Invalid parameter given.");
    }

    @Override
    public void configure() {
        super.configure();
        this.install(this.clientConfiguration);
        this.install(this.infoClientConfiguration);
        this.bind(Logger.class).toInstance(this.logger);
        this.bind(ApplicationService.class).to(InfoClient.class);
        this.bind(ConnectionEventHandler.class).to(InfoClient.class);
        this.bind(InfoClient.class).asEagerSingleton();
    }
}

