/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.infoclient.formatting;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.applications.infoclient.formatting.OutputFormatter;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.worker_health.WorkerHealth;
import org.sosy_lab.verifiercloud.global.worker_health.WorkerHealthAnalysis;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.RunCollectionSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.SchedulerSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.ScheduledRequirements;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class HTMLOutputFormatter
implements OutputFormatter {
    private static final String TITLE_NEWLINE = " &#10;";
    private final String masterHostname;
    private final Logger logger;
    private final String htmlTemplate;
    private final TimeInterval repetitionInterval;
    private final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ('GMT'Z)");
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss ('GMT'Z)");
    private final Map<String, String> runCollectionColors;

    public HTMLOutputFormatter(String masterHostname, Optional<TimeInterval> repetitionInterval, Logger logger) {
        this.masterHostname = Preconditions.checkNotNull(masterHostname);
        this.logger = Preconditions.checkNotNull(logger);
        this.htmlTemplate = this.loadHTMLTemplate();
        this.repetitionInterval = repetitionInterval.isPresent() ? repetitionInterval.get() : TimeInterval.minutes(1L);
        this.runCollectionColors = Maps.newHashMap();
    }

    @Override
    public String generateOutput(MasterSummary masterSummary) {
        long timeBeforeMillis = 0L;
        if (this.logger.wouldLog(Level.FINER)) {
            timeBeforeMillis = System.currentTimeMillis();
        }
        ImmutableList<WorkerSummary> workerSummaries = masterSummary.getWorkerSummaries();
        ImmutableList<WorkerSummary> sortedWorkers = FluentIterable.from(workerSummaries).toSortedList(new CPUHostnameWorkerComparator());
        Map<String, Integer> activeRuns = this.getNumberOfActiveRuns(workerSummaries);
        ImmutableCollection<RunCollectionSummary> runCollectionSummaries = masterSummary.getSchedulerSummary().getRunCollections();
        ImmutableList<RunCollectionSummary> sortedRuns = FluentIterable.from(runCollectionSummaries).toSortedList(new RunCollectionComparator());
        StringBuilder runHTMLTableRows = new StringBuilder();
        for (RunCollectionSummary runCollectionSummary : sortedRuns) {
            runHTMLTableRows.append((CharSequence)this.generateRunCollectionHTMLTableRow(runCollectionSummary, activeRuns));
        }
        StringBuilder workerHTMLTableRows = new StringBuilder();
        for (WorkerSummary workerSummary : sortedWorkers) {
            workerHTMLTableRows.append((CharSequence)this.generateWorkerHTMLTableRow(workerSummary));
        }
        String filledTemplate = this.fillHTMLTemplate(this.htmlTemplate, masterSummary, workerHTMLTableRows, runHTMLTableRows);
        if (this.logger.wouldLog(Level.FINER)) {
            long timeAfterMillis = System.currentTimeMillis();
            long requiredTime = timeAfterMillis - timeBeforeMillis;
            this.logger.logf(Level.FINER, "Time for HTML output generation: %d ms", requiredTime);
        }
        return filledTemplate;
    }

    private Map<String, Integer> getNumberOfActiveRuns(ImmutableList<WorkerSummary> workerSummaries) {
        HashMap<String, Integer> activeRuns = Maps.newHashMap();
        for (WorkerSummary workerSummary : workerSummaries) {
            for (WorkerPartitionInformation partition : workerSummary.getExecutorState().getPartitions()) {
                String runCollectionId = partition.getRunCollectionId();
                if (activeRuns.containsKey(runCollectionId)) {
                    Integer oldValue = (Integer)activeRuns.get(runCollectionId);
                    activeRuns.put(runCollectionId, oldValue + 1);
                    continue;
                }
                activeRuns.put(runCollectionId, 1);
            }
        }
        return activeRuns;
    }

    private String escapeHostname(String hostname) {
        return hostname.replaceAll("[^a-zA-Z0-9]", "-");
    }

    private String convertStringAndIDToHTMLColor(String str, String id) {
        int strHashCode = str.hashCode() & Integer.MAX_VALUE;
        int idHashCode = id.hashCode() & Integer.MAX_VALUE;
        float hue = (float)strHashCode / 2.1474836E9f;
        float brightness = 0.25f + 0.35f * ((float)idHashCode / 2.1474836E9f);
        Color color = Color.getHSBColor(hue, 1.0f, brightness);
        String rgb = Integer.toHexString(color.getRGB()).substring(2);
        return "#" + rgb;
    }

    private String convertStringAndIDToHTMLColorAttribute(String str, String id) {
        String colorAttribute = "style=\"color: " + this.convertStringAndIDToHTMLColor(str, id) + "\"";
        this.runCollectionColors.put(id, colorAttribute);
        return colorAttribute;
    }

    private String getColorAttributeForRunCollectionUUID(String uuid) {
        return this.runCollectionColors.containsKey(uuid) ? this.runCollectionColors.get(uuid) : "";
    }

    private String htmlTableCell(Object cellContent, String attributes) {
        if (attributes.isEmpty()) {
            return "<td>" + cellContent + "</td>\n";
        }
        return "<td " + attributes + ">" + cellContent + "</td>\n";
    }

    private String htmlTableCell(Object cellContent) {
        return this.htmlTableCell(cellContent, "");
    }

    private String fillHTMLTemplate(String htmlTemplate, MasterSummary masterSummary, StringBuilder workerHTMLTableRows, StringBuilder runHTMLTableRows) {
        Date today = Calendar.getInstance().getTime();
        String dateString = this.dateTimeFormat.format(today);
        SchedulerSummary schedulerSummary = masterSummary.getSchedulerSummary();
        float masterLoadAsFloat = masterSummary.getLoad().getLoad1Minute();
        String masterLoad = masterSummary.getLoad().getLoad1MinuteString();
        String masterLoadString = !masterLoad.isEmpty() && masterSummary.getMasterProcessorCount() > 0 && masterLoadAsFloat > (float)masterSummary.getMasterProcessorCount() ? "<span class=\"excessive-load\">" + masterLoad + "</span>" : "<span>" + masterLoad + "</span>";
        int workerCountTotal = masterSummary.getWorkerSummaries().size() + masterSummary.getUnconnectedWorkers().size();
        int workerCountUnconnected = masterSummary.getUnconnectedWorkers().size();
        int workerCountConnected = masterSummary.getWorkerSummaries().size();
        int workerCountIdle = masterSummary.getNumberOfIdleWorkers();
        int workerCountWorking = masterSummary.getNumberOfWorkingWorkers();
        int workerCountUserOccupied = masterSummary.getNumberOfUserOccupiedWorkers();
        int runsActive = masterSummary.getSchedulerSummary().getNumberOfAssignedRuns();
        int runCollections = masterSummary.getSchedulerSummary().getRunCollections().size();
        int numberOfFinishedRuns = schedulerSummary.getNumberOfFinishedRuns();
        String meanTimeToRunFinish = numberOfFinishedRuns == 0 ? "-" : schedulerSummary.getAccumulatedRunWaitingTime().devide(numberOfFinishedRuns).toString();
        String workerNumbersDataTags = "data-total=\"" + workerCountTotal + "\" " + "data-unconnected=\"" + workerCountUnconnected + "\" " + "data-connected=\"" + workerCountConnected + "\" " + "data-working=\"" + workerCountWorking + "\" " + "data-idle=\"" + workerCountIdle + "\" " + "data-runs-active=\"" + runsActive + "\" " + "data-scheduled-run-collections=\"" + runCollections + "\" " + "data-user-occupied=\"" + workerCountUserOccupied + "\" " + "data-overall-processors=\"" + masterSummary.getNumberOfProcessors() + "\" " + "data-assigned-processors=\"" + masterSummary.getNumberOfAssignedProcessors() + "\" " + "data-free-processors=\"" + masterSummary.getNumberOfFreeProcessors() + "\" " + "data-overall-ram-byte=\"" + masterSummary.getRAM().toByte() + "\" " + "data-assigned-ram-byte=\"" + masterSummary.getAssignedRAM().toByte() + "\" " + "data-free-ram-byte=\"" + masterSummary.getFreeRAM().toByte() + "\" ";
        return htmlTemplate.replace("%interval_seconds%", Long.toString(this.repetitionInterval.toSeconds())).replace("%timestamp%", "<time data-timestamp=\"" + today.getTime() + "\">" + dateString + "</time>").replace("%master_hostname%", this.masterHostname).replace("%master_uptime%", masterSummary.getUptime().toString()).replace("%master_uptime_data_attr%", masterSummary.getUptime().toSeconds() + "s").replace("%master_load%", masterLoadString).replace("%worker_numbers_data_attrs%", workerNumbersDataTags).replace("%workers_total%", Integer.toString(workerCountTotal)).replace("%workers_connected%", Integer.toString(workerCountConnected)).replace("%workers_working%", Integer.toString(workerCountWorking)).replace("%workers_idle%", Integer.toString(workerCountIdle)).replace("%workers_useroccupied%", Integer.toString(workerCountUserOccupied)).replace("%workers_unconnected%", Integer.toString(workerCountUnconnected)).replace("%workers_unconnected_list%", Joiner.on("<br>\n").join(masterSummary.getUnconnectedWorkers())).replace("%unfinished_runs%", Integer.toString(schedulerSummary.getNumberOfAssignedRuns() + schedulerSummary.getNumberOfUnassignedRuns())).replace("%active_runs%", Integer.toString(schedulerSummary.getNumberOfAssignedRuns())).replace("%finished_runs%", Integer.toString(numberOfFinishedRuns)).replace("%total_wall_time%", schedulerSummary.getTimeConsumedByFinishedRuns().toString()).replace("%total_wall_time_data_attr%", schedulerSummary.getTimeConsumedByFinishedRuns().toSeconds() + "s").replace("%mean_time_to_finish%", meanTimeToRunFinish).replace("%stored_files%", Integer.toString(masterSummary.getFileStorageInformation().getNumberOfStoredFiles())).replace("%stored_file_size%", masterSummary.getFileStorageInformation().getStorageSize().toStringBothUnits()).replace("%stored_file_size_data_attr%", masterSummary.getFileStorageInformation().getStorageSize().toByte() + "b").replace("%run_table_rows%", runHTMLTableRows.toString()).replace("%worker_table_rows%", workerHTMLTableRows.toString());
    }

    private String formatDateTime(Date date) {
        Calendar then = Calendar.getInstance();
        then.setTimeInMillis(date.getTime());
        Calendar now = Calendar.getInstance();
        if (then.get(1) == now.get(1) && then.get(6) == now.get(6)) {
            return this.timeFormat.format(date);
        }
        return this.dateTimeFormat.format(date);
    }

    private String formatDateTime(long millis) {
        return this.formatDateTime(new Date(millis));
    }

    private StringBuilder generateRunCollectionHTMLTableRow(RunCollectionSummary runCollectionSummary, Map<String, Integer> executedRuns) {
        StringBuilder runHTMLTableRow = new StringBuilder();
        int numberOfFinishedRuns = runCollectionSummary.getNumberOfFinishedRuns();
        int finishedPercentage = 100 * numberOfFinishedRuns / runCollectionSummary.getNumberOfRuns();
        int numberOfExecutedRuns = 0;
        String id = runCollectionSummary.getId();
        if (executedRuns.containsKey(id)) {
            numberOfExecutedRuns = executedRuns.get(id);
        }
        String timeAdded = this.formatDateTime(runCollectionSummary.getTimeAddedMillis());
        String estimatedCompletionTime = this.estimateCompletionTime(runCollectionSummary);
        runHTMLTableRow.append("<tr");
        ScheduledRequirements requirements = runCollectionSummary.getRequirements();
        runHTMLTableRow.append(" title=\"Requirements:").append(TITLE_NEWLINE).append("Processors: ").append(requirements.getProcessorRequirements()).append(TITLE_NEWLINE);
        if (requirements.getCPURequirements().isPresent()) {
            runHTMLTableRow.append("CPU Model: ").append(requirements.getCPURequirements().get()).append(TITLE_NEWLINE);
        }
        if (requirements.getMemoryRequirements().isPresent()) {
            runHTMLTableRow.append("Memory: ").append(requirements.getMemoryRequirements().get()).append(TITLE_NEWLINE);
        }
        runHTMLTableRow.append(TITLE_NEWLINE).append("Limitations: ").append(TITLE_NEWLINE);
        Limitations limitations = FluentIterable.from(runCollectionSummary.getLimitations()).first().get();
        runHTMLTableRow.append("Time: ").append(limitations.getTimeLimit()).append(TITLE_NEWLINE);
        if (limitations.getMemoryLimit().isPresent()) {
            runHTMLTableRow.append("Memory: ").append(limitations.getMemoryLimit().get()).append(TITLE_NEWLINE);
        }
        if (limitations.getProcessorLimit().isPresent()) {
            runHTMLTableRow.append("Processors: ").append(limitations.getProcessorLimit().get()).append(TITLE_NEWLINE);
        }
        runHTMLTableRow.delete(runHTMLTableRow.length() - TITLE_NEWLINE.length(), runHTMLTableRow.length());
        runHTMLTableRow.append("\"");
        runHTMLTableRow.append(">");
        String owner = runCollectionSummary.getOwner();
        runHTMLTableRow.append(this.htmlTableCell(id, this.convertStringAndIDToHTMLColorAttribute(owner, id) + " class=\"rcid\"")).append(this.htmlTableCell(owner + (runCollectionSummary.isDetachable() ? "*" : ""))).append(this.htmlTableCell((Object)runCollectionSummary.getPriority(), "class=\"prio-" + (Object)((Object)runCollectionSummary.getPriority()) + "\"")).append(this.htmlTableCell(String.format("%d (%d)", runCollectionSummary.getNumberOfRuns(), numberOfExecutedRuns))).append(this.htmlTableCell(String.format("%s (%d%%)", numberOfFinishedRuns, finishedPercentage), String.format("class=\"progress\" style=\"background-size: %d%% 100%%\"", finishedPercentage))).append(this.htmlTableCell(runCollectionSummary.getConsumedWallTime())).append(this.htmlTableCell(timeAdded)).append(this.htmlTableCell(estimatedCompletionTime)).append("</tr>\n");
        return runHTMLTableRow;
    }

    private String estimateCompletionTime(RunCollectionSummary runCollectionSummary) {
        int numberOfFinishedRuns = runCollectionSummary.getNumberOfFinishedRuns();
        if (numberOfFinishedRuns > 0) {
            long passedMillis = System.currentTimeMillis() - runCollectionSummary.getTimeAddedMillis();
            long estimatedTotalMillis = passedMillis * (long)runCollectionSummary.getNumberOfRuns() / (long)numberOfFinishedRuns;
            long estimatedCompletionMillis = runCollectionSummary.getTimeAddedMillis() + estimatedTotalMillis;
            return this.formatDateTime(estimatedCompletionMillis);
        }
        return "unavailable";
    }

    private StringBuilder generateWorkerHTMLTableRow(WorkerSummary workerSummary) {
        StringBuilder partitionDetails = new StringBuilder();
        int assignedProcessors = workerSummary.getNumberOfReservedProcessors();
        long reservedMemoryBytes = 0L;
        ImmutableCollection<WorkerPartitionInformation> workerPartitions = workerSummary.getExecutorState().getPartitions();
        for (WorkerPartitionInformation partitionInfo : workerPartitions) {
            partitionDetails.append("<tr>").append(this.htmlTableCell((Object)partitionInfo.getState())).append(this.htmlTableCell(partitionInfo.getRunCollectionId(), this.getColorAttributeForRunCollectionUUID(partitionInfo.getRunCollectionId()))).append(this.htmlTableCell(String.format("%d processors", partitionInfo.getNumberOfProcessors()))).append(this.htmlTableCell(String.format("%s memory", partitionInfo.getReservedMemory()))).append("</tr>\n");
            reservedMemoryBytes += MemoryUnit.sum(partitionInfo.getReservedMemory().values()).toByte();
        }
        int usedProcessorPercentage = 100 * assignedProcessors / workerSummary.getNumberOfProcessors();
        int unusableProcessors = workerSummary.getNumberOfUnusableProcessors();
        int unusableProcessorPercentage = 100 * unusableProcessors / workerSummary.getNumberOfProcessors();
        int reservedMemoryPercentage = (int)(100L * reservedMemoryBytes / (workerSummary.getTotalMemory().toByte() - Constants.SYSTEM_MEMORY.toByte()));
        long unusableMemoryBytes = workerSummary.getUnusableMemory().toByte();
        int unusableMemoryPercentage = (int)(100L * unusableMemoryBytes / (workerSummary.getTotalMemory().toByte() - Constants.SYSTEM_MEMORY.toByte()));
        String stateCSSClass = "class=\"state-" + (Object)((Object)workerSummary.getWorkerState()) + "\"";
        String escapedHostname = this.escapeHostname(workerSummary.getWorkerHostname());
        StringBuilder workerRow = new StringBuilder();
        workerRow.append("<tr class=\"toggle-row\" id=\"toggle-details-").append(escapedHostname).append("\">");
        String hostAttributes = String.format("class=\"toggle-cell\" title=\"Load (1 min): %s%sUptime: %s\"", workerSummary.getLoadData().getLoad1MinuteString(), TITLE_NEWLINE, workerSummary.getUptime());
        workerRow.append(this.htmlTableCell(workerSummary.getWorkerHostname(), hostAttributes));
        String usageInformationTitle = String.format("title=\"Relative user occupied time: %.2f %sRelative idle time: %.2f\" %s", workerSummary.getWorkerStatistic().getRelativeUserOccupiedTime(), TITLE_NEWLINE, workerSummary.getWorkerStatistic().getRelativeIdleTime(), stateCSSClass);
        workerRow.append(this.htmlTableCell((Object)workerSummary.getWorkerState(), usageInformationTitle));
        String averageLoad = String.format("title=\"Average cloud load: %.2f\"", workerSummary.getWorkerStatistic().getOverallLoad());
        String runsClass = this.runCountCSSClass(workerSummary, usedProcessorPercentage, reservedMemoryPercentage);
        workerRow.append(this.htmlTableCell(workerPartitions.size(), runsClass + " " + averageLoad));
        WorkerHealthAnalysis workerHealthAnalysis = WorkerHealthAnalysis.analyzeHealth(workerSummary);
        WorkerHealth health = workerHealthAnalysis.getHealth();
        Iterable<String> symptoms = workerHealthAnalysis.getSymptoms();
        String loadAttributes = String.format(" class=\"%s\" title=\"%s\"", health.toString().toLowerCase(), health == WorkerHealth.HEALTHY ? "worker is healthy" : Joiner.on(TITLE_NEWLINE).join(symptoms));
        workerRow.append(this.htmlTableCell("", loadAttributes));
        workerRow.append(this.htmlTableCell(workerSummary.getCPUName()));
        workerRow.append(this.htmlTableCell(workerSummary.getNumberOfProcessors(), String.format("class=\"processor-usage\" style=\"background-size: %d%% 100%%, %d%% 100%%\" title=\"%d total, &#10;%d unusable, &#10;%d used by the VerifierCloud, &#10;%d usable\"", usedProcessorPercentage, unusableProcessorPercentage, workerSummary.getNumberOfProcessors(), unusableProcessors, assignedProcessors, workerSummary.getNumberOfProcessors() - unusableProcessors - assignedProcessors)));
        workerRow.append(this.htmlTableCell(workerSummary.getTotalMemory(), String.format("class=\"memory-usage\" style=\"background-size: %d%% 100%%, %d%% 100%%\" title=\"%s total, &#10;%s unusable, &#10;%s reserved by the VerifierCloud, &#10;%s usable\"", reservedMemoryPercentage, unusableMemoryPercentage, workerSummary.getTotalMemory().toStringBothUnits(), workerSummary.getUnusableMemory().toStringBothUnits(), MemoryUnit.bytes(reservedMemoryBytes).toStringBothUnits(), workerSummary.getFreeMemory().toStringBothUnits())));
        workerRow.append("</tr>\n");
        String workerDetailsCSSClasses = partitionDetails.length() > 0 ? "worker-details" : "worker-details worker-empty";
        workerRow.append(String.format("<tr class=\"%s\" id=\"worker-details-%s\">", workerDetailsCSSClasses, escapedHostname)).append(this.htmlTableCell("<table>" + partitionDetails + "</table>", "colspan=\"7\"")).append("</tr>\n\n");
        return workerRow;
    }

    private String runCountCSSClass(WorkerSummary workerSummary, int usedProcessorPercentage, int usedMemoryPercentage) {
        String runCountCSSClass = workerSummary.getWorkerState() == ExternalWorkerState.USER_OCCUPIED ? "class=\"runcount-occupied\"" : (workerSummary.getExecutorState().getPartitions().size() == 0 ? "class=\"runcount-empty\"" : (usedProcessorPercentage == 100 || usedMemoryPercentage > 85 ? "class=\"runcount-full\"" : "class=\"runcount-hasruns\""));
        return runCountCSSClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadHTMLTemplate() {
        try (InputStream templateStream = this.getClass().getResourceAsStream("template.html");){
            String string = CharStreams.toString(new InputStreamReader(templateStream, "UTF-8"));
            return string;
        }
        catch (IOException e) {
            this.logger.logf(Level.SEVERE, "Could not load HTML template.", new Object[0]);
            throw new RuntimeException("Could not load HTML template.");
        }
    }

    private static final class RunCollectionComparator
    implements Comparator<RunCollectionSummary>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RunCollectionComparator() {
        }

        @Override
        public int compare(RunCollectionSummary o1, RunCollectionSummary o2) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)o1.getOwner()), (Comparable<?>)((Object)o2.getOwner())).compare(o1.getTimeAddedMillis(), o2.getTimeAddedMillis()).result();
        }
    }

    private static final class CPUHostnameWorkerComparator
    implements Comparator<WorkerSummary>,
    Serializable {
        private static final long serialVersionUID = -6607685260946673180L;

        private CPUHostnameWorkerComparator() {
        }

        @Override
        public int compare(WorkerSummary o1, WorkerSummary o2) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)o1.getCPUName()), (Comparable<?>)((Object)o2.getCPUName())).compare((Comparable<?>)((Object)o1.getWorkerHostname()), (Comparable<?>)((Object)o2.getWorkerHostname())).result();
        }
    }
}

