/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.interactive;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import org.sosy_lab.verifiercloud.client.applications.interactive.InteractiveClientModule;
import org.sosy_lab.verifiercloud.client.configuration.common.ClientConfiguration;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.application.ProgramModeFactory;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.ConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.ConfigurationOption;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.util.TableFormatter;

public class InteractiveClientFactory
implements ProgramModeFactory {
    @Override
    public String getOptions() {
        return ClientConfiguration.getOptions();
    }

    @Override
    public String getHelpText() {
        return "The interactive client provides the user with a shell to control the master.";
    }

    @Override
    public String getOptionDescription() {
        TableFormatter formatter = new TableFormatter(2, 0);
        for (ConfigurationOption configurationOption : ClientConfiguration.getConfigurationOptions()) {
            formatter.addRow("--" + configurationOption.getName(), configurationOption.getDescription());
        }
        return formatter.buildTable();
    }

    @Override
    public AbstractCloudModule createModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        return new InteractiveClientModule(commandLineArguments, userConfigurationPath);
    }

    @Override
    public ImmutableCollection<ConfigurationHandler<?>> getConfigurationHandlers(Logger logger) {
        return ImmutableList.of(new DefaultConfigurationHandler<ClientConfiguration>(ClientConfiguration.getDefaultConfigurationBuilder(), logger));
    }
}

