/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.interactive;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sosy_lab.verifiercloud.Modes;
import org.sosy_lab.verifiercloud.client.applications.ClientModule;
import org.sosy_lab.verifiercloud.client.applications.interactive.InteractiveClient;
import org.sosy_lab.verifiercloud.client.configuration.common.ClientConfiguration;
import org.sosy_lab.verifiercloud.client.interactive.ConsoleUserCommandShell;
import org.sosy_lab.verifiercloud.client.interactive.UserCommandShell;
import org.sosy_lab.verifiercloud.client.interactive.console.ConsoleBridge;
import org.sosy_lab.verifiercloud.client.interactive.console.UserConsole;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.application.CommandLineArguments;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.MemoryLogger;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;

public class InteractiveClientModule
extends ClientModule {
    private ClientConfiguration configuration;
    private final CommandLineArguments commandLineArguments;
    private final MemoryLogger logger;

    public InteractiveClientModule(CommandLineArguments commandLineArguments, Path userConfigurationPath) throws IOException {
        super(userConfigurationPath);
        this.commandLineArguments = Preconditions.checkNotNull(commandLineArguments);
        this.logger = new MemoryLogger();
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        DefaultConfigurationHandler<ClientConfiguration> handler = new DefaultConfigurationHandler<ClientConfiguration>(ClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
        DefaultPermanentStorage permanentStorage = new DefaultPermanentStorage(this.getClientPermanentStoragePath(), this.logger);
        try {
            permanentStorage.initialize();
            permanentStorage.parseFile("Config", handler);
            CommandLineArguments remainingParameters = handler.claimParameters(this.commandLineArguments);
            if (!remainingParameters.isEmpty()) {
                this.printHelpAndThrowException();
            }
            this.configuration = (ClientConfiguration)handler.getParseResult();
        }
        catch (InvalidOptionException | PermanentStorageException e) {
            throw new ApplicationInitializationException(e.getMessage());
        }
        InteractiveClientModule.requireMasterHostname(this.configuration.getMasterHostName());
        AbstractFileContent.setDeserializationPath(Paths.get(Constants.DEFAULT_VCLOUD_FOLDER, new String[0]).resolve("BigFileContentTmp"));
        AbstractFileContent.setWriteRepresentationOnDeserialisation(false);
    }

    private void printHelpAndThrowException() throws ApplicationInitializationException {
        if (this.commandLineArguments.getNamedArguments().containsKey("help")) {
            System.out.println("Use '" + Modes.HELP.getOptionName() + " " + "--" + Modes.CLIENT.getOptionName() + "'.");
        }
        System.out.println("Available options for interactive client:\n" + ClientConfiguration.getOptions());
        throw new ApplicationInitializationException("Invalid parameter given.");
    }

    @Override
    public void configure() {
        super.configure();
        this.install(this.configuration);
        this.bind(Logger.class).to(MemoryLogger.class);
        this.bind(MemoryLogger.class).toInstance(this.logger);
        this.bind(UserCommandShell.class).to(ConsoleUserCommandShell.class).asEagerSingleton();
        this.bind(UserConsole.class).to(ConsoleBridge.class);
        this.bind(ConsoleBridge.class).asEagerSingleton();
        this.bind(ApplicationService.class).to(InteractiveClient.class);
        this.bind(ConnectionEventHandler.class).to(InteractiveClient.class);
        this.bind(InteractiveClient.class).asEagerSingleton();
    }
}

