/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.util.FileUtils;

public class WebClientStandalone {
    private static final Splitter argSplitter = Splitter.on('=').trimResults();
    private static final Path TOMCAT_WORKING_DIR = Paths.get("tomcat", new String[0]).toAbsolutePath();

    public static void main(String[] args) throws ServletException, LifecycleException, IOException {
        Path webClientWar = Paths.get("vcloud.war", new String[0]).toAbsolutePath();
        for (String arg : args) {
            List<String> tokens = argSplitter.splitToList(arg);
            Preconditions.checkArgument(tokens.size() == 2, arg + " is not a key vlaue pair.");
            if (!tokens.get(0).equalsIgnoreCase("--war")) {
                throw new IllegalArgumentException();
            }
            webClientWar = Paths.get(tokens.get(1), new String[0]).toAbsolutePath();
        }
        Tomcat tomcat = new Tomcat();
        WebClientStandalone.addShutdownHook(tomcat);
        WebClientStandalone.prepareTomcatWoringDir();
        WebClientStandalone.startTomcat(webClientWar, tomcat);
    }

    private static void addShutdownHook(final Tomcat tomcat) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    tomcat.stop();
                    tomcat.destroy();
                    FileUtils.deleteDirectory(TOMCAT_WORKING_DIR, LoggerBuilder.create().build());
                }
                catch (IOException | LifecycleException e) {
                    e.printStackTrace();
                }
            }
        }));
    }

    private static void prepareTomcatWoringDir() throws IOException {
        Files.createDirectories(TOMCAT_WORKING_DIR, new FileAttribute[0]);
        FileUtils.deleteDirectory(TOMCAT_WORKING_DIR, LoggerBuilder.create().build());
        Files.createDirectories(TOMCAT_WORKING_DIR.resolve("webapps"), new FileAttribute[0]);
    }

    private static void startTomcat(Path webClientWar, Tomcat tomcat) throws IOException, ServletException, LifecycleException {
        tomcat.setBaseDir(TOMCAT_WORKING_DIR.toString());
        tomcat.setPort(8088);
        tomcat.addWebapp("/vcloud", webClientWar.toString());
        tomcat.start();
        tomcat.getServer().await();
    }
}

