/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.api;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.RunState;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.WebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.WebAppReloader;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.info.MasterInformationProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.ModelGenerator;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state.RunStates;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramNotAvailableException;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.StartRunInformation;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.validation.StartRunInformationValidator;
import org.sosy_lab.verifiercloud.client.network.ClientAuthorizationState;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.Success;
import org.sosy_lab.verifiercloud.client.network.exceptions.AuthenticationFailedException;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RequestFailureException;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunSubmissionFailureException;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionBuilder;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.client.run_builders.web.WebRunCollectionBuilderFactory;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.master.clientside.ClientAccessLevel;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class DefaultWebClientAPI
implements WebClientAPI,
ConnectionEventHandler {
    private static final TimeInterval CONNECTION_TO_MASTER_TIMER_PERIOD = TimeInterval.minutes(2L);
    private static final TimeInterval MEMORY_LEAK_PREVENTER_PERIOD = TimeInterval.minutes(1L);
    private static final int REQUEST_COUNTER_RELOAD_THRESHOLD = 100000;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private final AtomicInteger requestCounter = new AtomicInteger();
    private final ScheduledExecutorService memoryLeakPreventer = Executors.newSingleThreadScheduledExecutor();
    private final Logger logger;
    private final ModelGenerator modelGenerator;
    private final MasterInformationProvider masterInformationProvider;
    private final MasterConnection masterConnection;
    private final GitManager gitManager;
    private final WebAppReloader webAppReloader;
    private final WebRunCollectionBuilderFactory runCollectionBuilderFactory;
    private final StartRunInformationValidator validator;
    private final ProgramProvider programProvider;
    private final String userName;
    private final ImmutableMap<String, Limitations> preDefinedLimitations;
    private final Optional<URI> basePath;
    private final RunStates runStates;
    private Optional<ConnectToMasterTimerTask> connectTask = Optional.absent();

    @Inject
    public DefaultWebClientAPI(Logger logger, ModelGenerator modelGenerator, MasterInformationProvider masterInformationProvider, SystemInformationProvider systemInformationProvider, MasterConnection masterConnection, WebAppReloader webAppReloader, GitManager gitManager, StartRunInformationValidator validator, WebRunCollectionBuilderFactory runCollectionBuilderFactory, ProgramProvider programProvider, RunStates runStatesCache, @Named(value="preDefinedLimitations") ImmutableMap<String, Limitations> preDefinedLimitations, @Named(value="url") Optional<URI> basePath, @Named(value="username") Optional<String> userName) {
        this.logger = Preconditions.checkNotNull(logger);
        this.modelGenerator = Preconditions.checkNotNull(modelGenerator);
        this.masterInformationProvider = Preconditions.checkNotNull(masterInformationProvider);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.gitManager = Preconditions.checkNotNull(gitManager);
        this.webAppReloader = Preconditions.checkNotNull(webAppReloader);
        this.validator = Preconditions.checkNotNull(validator);
        this.runCollectionBuilderFactory = Preconditions.checkNotNull(runCollectionBuilderFactory);
        this.programProvider = Preconditions.checkNotNull(programProvider);
        this.runStates = Preconditions.checkNotNull(runStatesCache);
        this.preDefinedLimitations = Preconditions.checkNotNull(preDefinedLimitations);
        this.basePath = Preconditions.checkNotNull(basePath);
        this.userName = userName.isPresent() ? userName.get() : systemInformationProvider.getUsername();
    }

    public void initialize() throws ApplicationInitializationException {
        Preconditions.checkState(!this.initialized.getAndSet(true));
        this.logger.logf(Level.FINE, "Initilizing %s.", DefaultWebClientAPI.class.getSimpleName());
        this.memoryLeakPreventer.scheduleAtFixedRate(new MemoryLeakPreventerRunnable(), 0L, MEMORY_LEAK_PREVENTER_PERIOD.toSeconds(), TimeUnit.SECONDS);
        this.connect();
        try {
            this.runCollectionBuilderFactory.initialize();
        }
        catch (IOException | GitAPIException | PermanentStorageException e) {
            this.logger.logf(Level.SEVERE, e, "Cannot initialize WebClientAPI: %s", e.getMessage());
            throw new ApplicationInitializationException((Exception)e);
        }
    }

    public void cleanUp() throws IOException {
        this.checkInitialized();
        this.logger.logf(Level.INFO, "Stopping webclient instance.", new Object[0]);
        if (this.connectTask.isPresent()) {
            this.connectTask.get().stop();
        }
        this.initialized.set(false);
        this.memoryLeakPreventer.shutdown();
        this.runCollectionBuilderFactory.cleanUp();
        this.masterConnection.disconnectAndDisable();
        this.logger.close();
    }

    public RunStates getRunStates() {
        return this.runStates;
    }

    @Override
    public void onConnectionLost() {
        if (this.initialized.get() && !this.connecting.get()) {
            this.masterConnection.disconnectAndDisable();
            this.logger.logf(Level.WARNING, "Connection to master is closed.", new Object[0]);
            this.logger.logf(Level.INFO, "Reloading web client.", new Object[0]);
            try {
                this.webAppReloader.reload();
            }
            catch (ApplicationInitializationException e) {
                this.logger.logf(Level.SEVERE, e, "Cannot reload web client: %s", e.getMessage());
            }
        }
    }

    @Override
    public Logger getLogger() {
        this.checkInitialized();
        return this.logger;
    }

    @Override
    public ModelGenerator getModelGenerator() {
        this.checkInitialized();
        return this.modelGenerator;
    }

    @Override
    public void updateRepository() {
        this.gitManager.fetchNewRevisions();
    }

    @Override
    public ImmutableMap<String, Limitations> getPreDefinedLimitations() {
        return this.preDefinedLimitations;
    }

    @Override
    public Optional<URI> getConfiguredBasePath() {
        return this.basePath;
    }

    @Override
    public UUID startTool(StartRunInformation startRunInformation) throws RunSubmissionFailureException, RunCollectionCreationException, RefNotFoundException {
        this.checkInitialized();
        this.checkMasterConnection();
        this.requestCounter.incrementAndGet();
        this.logger.logf(Level.FINE, "Validating execution parameters %s.", startRunInformation);
        this.validator.validate(startRunInformation);
        RunCollectionBuilder<RefNotFoundException> builder = this.runCollectionBuilderFactory.createWebRunCollectionBuilder(startRunInformation);
        RunCollection runCollection = builder.createRunCollection();
        Run run = (Run)runCollection.getRuns().get(0);
        this.logger.logf(Level.FINE, "Submitting %s.", run);
        Preconditions.checkState(runCollection.getRuns().size() == 1);
        CheckedFuture<Success, RunSubmissionFailureException> success = this.masterConnection.submitRunCollection(runCollection);
        success.checkedGet();
        UUID runId = UUID.fromString(run.getUniqueSecureId());
        this.runStates.addKnownRun(runId, runCollection.getId());
        return runId;
    }

    @Override
    public void removeRun(UUID runId) throws RequestFailureException, MasterSummaryNotRetrievableException {
        String runCollectionID = this.runStates.getKnownRuns().get(runId);
        if (runCollectionID != null) {
            RunState runState = this.runStates.getRunState(runId);
            if (runState.equals((Object)RunState.PROCESSING) || runState.equals((Object)RunState.PENDING)) {
                this.masterConnection.stopRunCollection(runCollectionID).checkedGet();
            }
            this.runStates.removeKnownRun(runId);
        } else if (this.runStates.getKnownFinishedRuns().contains(runId)) {
            this.runStates.removeKnownRun(runId);
        } else {
            throw new RequestFailureException("No run with id " + runId + " is known.");
        }
    }

    @Override
    public FileContent getResult(UUID runId) throws TimeoutException, RequestFailureException {
        this.checkInitialized();
        this.checkMasterConnection();
        CheckedFuture<FileContent, RequestFailureException> resultFuture = this.masterConnection.requestRunResultAsZip(runId.toString());
        return resultFuture.checkedGet(60L, TimeUnit.SECONDS);
    }

    @Override
    public RunState getRunState(UUID id) throws MasterSummaryNotRetrievableException {
        this.checkInitialized();
        this.checkMasterConnection();
        return this.runStates.getRunState(id);
    }

    @Override
    public FileContent getTool(SvnRevision revision) throws RefNotFoundException, ProgramNotAvailableException {
        this.requestCounter.incrementAndGet();
        this.checkInitialized();
        this.checkMasterConnection();
        return this.programProvider.getProgramAsZip(revision);
    }

    @Override
    public String getVcloudInfo() throws MasterSummaryNotRetrievableException {
        this.checkInitialized();
        this.checkMasterConnection();
        return this.masterInformationProvider.getMasterInfoAsHtml();
    }

    private void checkMasterConnection() {
        if (!this.masterConnection.isConnected()) {
            throw new ServiceUnavailableException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"The VerifierCloud is not online.").build());
        }
    }

    private void checkInitialized() {
        Preconditions.checkState(this.initialized.get());
    }

    private void connect() {
        Preconditions.checkState(!this.masterConnection.isConnected());
        if (!this.connecting.getAndSet(true)) {
            Timer timer = new Timer("Master connection timer.");
            timer.scheduleAtFixedRate((TimerTask)new ConnectToMasterTimerTask(timer), 0L, CONNECTION_TO_MASTER_TIMER_PERIOD.toMilliseconds());
        }
    }

    private final class ConnectToMasterTimerTask
    extends TimerTask {
        private final Timer timer;

        public ConnectToMasterTimerTask(Timer timer) {
            this.timer = Preconditions.checkNotNull(timer);
        }

        public void stop() {
            this.timer.cancel();
            DefaultWebClientAPI.this.connectTask = Optional.absent();
        }

        @Override
        public void run() {
            ClientAuthorizationState state;
            DefaultWebClientAPI.this.connectTask = Optional.of(this);
            Preconditions.checkState(!DefaultWebClientAPI.this.masterConnection.isConnected());
            try {
                state = (ClientAuthorizationState)((Object)DefaultWebClientAPI.this.masterConnection.connect().get());
            }
            catch (InterruptedException | ExecutionException e) {
                DefaultWebClientAPI.this.logger.logf(Level.WARNING, e, "Can not connect to the master: %s", e.getMessage());
                return;
            }
            if (!state.equals((Object)ClientAuthorizationState.DISCONNECTED)) {
                DefaultWebClientAPI.this.connecting.set(false);
                this.authenticateAsUser();
            }
        }

        private void authenticateAsUser() {
            ClientAuthorizationState authState;
            CheckedFuture<ClientAuthorizationState, AuthenticationFailedException> authStateFuture = DefaultWebClientAPI.this.masterConnection.authenticate(ClientAccessLevel.USER, DefaultWebClientAPI.this.userName);
            try {
                authState = authStateFuture.checkedGet();
            }
            catch (AuthenticationFailedException e) {
                DefaultWebClientAPI.this.logger.logf(Level.SEVERE, "Can not authanticate as %s", new Object[]{ClientAccessLevel.USER});
                DefaultWebClientAPI.this.masterConnection.disconnectAndDisable();
                return;
            }
            if (authState.equals((Object)ClientAuthorizationState.USER)) {
                this.stop();
            } else {
                DefaultWebClientAPI.this.masterConnection.disconnectAndDisable();
            }
        }
    }

    private class MemoryLeakPreventerRunnable
    implements Runnable {
        private MemoryLeakPreventerRunnable() {
        }

        @Override
        public void run() {
            int currentRequestCount = DefaultWebClientAPI.this.requestCounter.get();
            if (currentRequestCount > 100000) {
                DefaultWebClientAPI.this.logger.logf(Level.INFO, "Reloading webclient after %s memory relevant requests.", currentRequestCount);
                try {
                    DefaultWebClientAPI.this.webAppReloader.reload(DefaultWebClientAPI.this);
                    DefaultWebClientAPI.this.requestCounter.set(0);
                }
                catch (ApplicationInitializationException e) {
                    DefaultWebClientAPI.this.logger.logf(Level.SEVERE, e, "Cannot reload web client: %s", e.getMessage());
                }
            }
        }
    }
}

