/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping;

import javax.annotation.PostConstruct;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.glassfish.jersey.server.mvc.freemarker.FreemarkerMvcFeature;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.WebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping.WebClientBinder;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;

public abstract class AbstractWebClientResourceConfig
extends ResourceConfig {
    protected abstract WebClientAPI getWebClientAPI() throws ApplicationInitializationException;

    @PostConstruct
    public void initialize() throws ApplicationInitializationException {
        this.property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", true);
        this.property("jersey.config.server.exception.processResponseErrors", true);
        this.property("jersey.config.multipart.bufferThreshold", 4000000);
        this.property("jersey.config.server.mvc.caching.freemarker", true);
        this.property("jersey.config.server.mvc.templateBasePath.freemarker", "/WEB-INF/templates");
        this.registerClasses(new Class[]{FreemarkerMvcFeature.class});
        this.registerClasses(new Class[]{MultiPartFeature.class});
        this.packages(true, new String[]{"org.sosy_lab.verifiercloud.client.applications.webclient"});
        this.enableCompression();
        WebClientAPI webClientAPI = this.getWebClientAPI();
        this.register((Object)new WebClientBinder(webClientAPI));
    }

    private void enableCompression() {
        this.registerClasses(new Class[]{EncodingFilter.class, GZipEncoder.class, DeflateEncoder.class});
    }
}

