/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.inject.Inject;
import org.sosy_lab.verifiercloud.client.applications.ClientModule;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.DefaultWebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.WebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.WebAppReloader;
import org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.WebClientUncaughtExceptionHandler;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.DefaultGitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.info.CachingMasterInformationProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.info.MasterInformationProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.DefaultModelGenerator;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.ModelGenerator;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state.DefaultRunStatesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state.RunStates;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state.RunStatesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.CachingProgramProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.EagerProgramFilesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramFilesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.validation.DefaultStartRunInformationValidator;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.validation.StartRunInformationValidator;
import org.sosy_lab.verifiercloud.client.configuration.common.ClientConfiguration;
import org.sosy_lab.verifiercloud.client.configuration.webclient.WebClientConfiguration;
import org.sosy_lab.verifiercloud.client.files.BackEndWebClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.WebClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.CacheStorageProvider;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.DefaultHashCodeCache;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCache;
import org.sosy_lab.verifiercloud.client.files.hashcode_cache.HashCodeCacheWebClientFileStorage;
import org.sosy_lab.verifiercloud.client.files.in_tmp_dir.TmpDirClientFileStorage;
import org.sosy_lab.verifiercloud.client.network.ClientAPI;
import org.sosy_lab.verifiercloud.client.network.ConnectionEventHandler;
import org.sosy_lab.verifiercloud.client.network.DefaultClientAPI;
import org.sosy_lab.verifiercloud.client.network.DefaultMasterConnection;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.results.ActiveRequests;
import org.sosy_lab.verifiercloud.client.run_builders.web.DefaultWebRunCollectionBuilderFactory;
import org.sosy_lab.verifiercloud.client.run_builders.web.WebRunCollectionBuilderFactory;
import org.sosy_lab.verifiercloud.client.run_storage.ClientRunStorage;
import org.sosy_lab.verifiercloud.client.run_storage.MemClientRunStorage;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.logging.InitialLogger;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.ConnectionBuilder;
import org.sosy_lab.verifiercloud.global.networking.establishing.connection_builder.DefaultConnectionBuilder;
import org.sosy_lab.verifiercloud.global.permanent_storage.DefaultPermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.PermanentStorage;
import org.sosy_lab.verifiercloud.global.permanent_storage.configurations.DefaultConfigurationHandler;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.InvalidOptionException;
import org.sosy_lab.verifiercloud.global.permanent_storage.exceptions.PermanentStorageException;
import org.sosy_lab.verifiercloud.global.util.error_trigger.DefaultErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;
import org.sosy_lab.verifiercloud.global.util.system.guice.OperatingSystemSpecificBindingsModule;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;

public class WebClientAPIModule
extends ClientModule {
    private static final String WEB_CLIENT_CONFIG_FILE = "WebClient_Config";
    private final InitialLogger logger;
    private ClientConfiguration configuration;
    private WebClientConfiguration webClientConfiguration;
    private final WebAppReloader webAppReloader;
    private final Optional<DefaultWebClientAPI> oldWebClientAPI;

    public WebClientAPIModule(Path userConfigurationPath, WebAppReloader webAppReloader) {
        super(userConfigurationPath);
        this.webAppReloader = Preconditions.checkNotNull(webAppReloader);
        this.oldWebClientAPI = Optional.absent();
        this.logger = LoggerBuilder.createInitialLogger();
    }

    public WebClientAPIModule(Path userConfigurationPath, WebAppReloader webAppReloader, DefaultWebClientAPI oldWebClientAPI) {
        super(userConfigurationPath);
        this.webAppReloader = Preconditions.checkNotNull(webAppReloader);
        this.oldWebClientAPI = Optional.of(oldWebClientAPI);
        this.logger = LoggerBuilder.createInitialLogger();
    }

    @Override
    public void initialize() throws ApplicationInitializationException {
        DefaultConfigurationHandler<ClientConfiguration> clientConfigHandler = new DefaultConfigurationHandler<ClientConfiguration>(ClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
        DefaultConfigurationHandler<WebClientConfiguration> webClientConfigHandler = new DefaultConfigurationHandler<WebClientConfiguration>(WebClientConfiguration.getDefaultConfigurationBuilder(), this.logger);
        DefaultPermanentStorage permanentStorage = new DefaultPermanentStorage(this.getClientPermanentStoragePath(), this.logger);
        try {
            permanentStorage.initialize();
            permanentStorage.parseFile("Config", clientConfigHandler);
            permanentStorage.parseFile(WEB_CLIENT_CONFIG_FILE, webClientConfigHandler);
            this.configuration = (ClientConfiguration)clientConfigHandler.getParseResult();
            this.webClientConfiguration = (WebClientConfiguration)webClientConfigHandler.getParseResult();
            if (System.getenv().containsKey("VCLOUD_MASTER_PORT")) {
                try {
                    String masterPort = System.getenv().get("VCLOUD_MASTER_PORT");
                    this.logger.logf(Level.INFO, "Setting master port: %s", masterPort);
                    this.configuration.overriedMasterPort(masterPort);
                }
                catch (InvalidOptionException e) {
                    throw new ApplicationInitializationException(e);
                }
            }
            LoggerBuilder loggerBuilder = LoggerBuilder.create().logAsynchronously().logToStdOut(this.configuration.getLogLevel()).logExceptionsToErrorTrigger(this.webClientConfiguration.getErrorTriggerCommand(), Level.WARNING);
            if (this.webClientConfiguration.isLogFileCompressed()) {
                loggerBuilder.logToCompressedFile(this.webClientConfiguration.getFileLogPath(), this.webClientConfiguration.getFileLogLevel());
            } else {
                loggerBuilder.logToFile(this.webClientConfiguration.getFileLogPath(), this.webClientConfiguration.getFileLogLevel());
            }
            loggerBuilder.injectInto(this.logger);
        }
        catch (IOException | PermanentStorageException e) {
            throw new ApplicationInitializationException(e);
        }
        AbstractFileContent.setDeserializationPath(this.webClientConfiguration.getLocalPath().resolve("BigFileContentTmp"));
        AbstractFileContent.setWriteRepresentationOnDeserialisation(false);
        WebClientAPIModule.requireMasterHostname(this.configuration.getMasterHostName());
    }

    @Override
    public void configure() {
        Set<Object> knownFinishedRuns;
        Map<Object, Object> knownRuns;
        this.install(new OperatingSystemSpecificBindingsModule());
        this.bind(WebClientFileStorage.class).to(HashCodeCacheWebClientFileStorage.class).asEagerSingleton();
        this.bind(ClientFileStorage.class).to(WebClientFileStorage.class);
        this.bind(BackEndWebClientFileStorage.class).to(TmpDirClientFileStorage.class).asEagerSingleton();
        this.bind(HashCodeCache.class).to(DefaultHashCodeCache.class).asEagerSingleton();
        this.bind(MasterConnection.class).to(DefaultMasterConnection.class).asEagerSingleton();
        this.bind(ConnectionBuilder.class).to(DefaultConnectionBuilder.class);
        this.bind(PermanentStorage.class).annotatedWith(Names.named("cacheStorage")).toProvider(CacheStorageProvider.class).asEagerSingleton();
        this.bind(Path.class).annotatedWith(Names.named("clientCacheStoragePath")).toProvider(ClientCacheStoragePathProvider.class);
        this.bind(ClientAPI.class).to(DefaultClientAPI.class).asEagerSingleton();
        this.bind(ClientRunStorage.class).to(MemClientRunStorage.class);
        this.bind(ActiveRequests.class).asEagerSingleton();
        this.install(this.configuration);
        this.install(this.webClientConfiguration);
        this.bind(WebClientAPI.class).to(DefaultWebClientAPI.class);
        this.bind(ConnectionEventHandler.class).to(DefaultWebClientAPI.class);
        this.bind(DefaultWebClientAPI.class).asEagerSingleton();
        this.bind(ModelGenerator.class).to(DefaultModelGenerator.class);
        this.bind(StartRunInformationValidator.class).to(DefaultStartRunInformationValidator.class);
        this.bind(Thread.UncaughtExceptionHandler.class).to(WebClientUncaughtExceptionHandler.class);
        this.bind(WebAppReloader.class).toInstance(this.webAppReloader);
        this.bind(ErrorTriggerExecutor.class).to(DefaultErrorTriggerExecutor.class);
        this.bind(GitManager.class).to(DefaultGitManager.class).asEagerSingleton();
        this.bind(ProgramFilesProvider.class).to(EagerProgramFilesProvider.class).asEagerSingleton();
        this.bind(ProgramProvider.class).to(CachingProgramProvider.class);
        this.bind(MasterInformationProvider.class).to(CachingMasterInformationProvider.class);
        this.bind(RunStatesProvider.class).to(DefaultRunStatesProvider.class).asEagerSingleton();
        this.bind(RunStates.class).asEagerSingleton();
        if (this.oldWebClientAPI.isPresent()) {
            RunStates oldRunStates = this.oldWebClientAPI.get().getRunStates();
            knownRuns = oldRunStates.getKnownRuns();
            knownFinishedRuns = oldRunStates.getKnownFinishedRuns();
        } else {
            knownRuns = ImmutableMap.of();
            knownFinishedRuns = ImmutableSet.of();
        }
        this.bind(new TypeLiteral<Map<UUID, String>>(){}).annotatedWith(Names.named("knownRuns")).toInstance(knownRuns);
        this.bind(new TypeLiteral<Set<UUID>>(){}).annotatedWith(Names.named("knownFinishedRuns")).toInstance(knownFinishedRuns);
        this.bind(WebRunCollectionBuilderFactory.class).to(DefaultWebRunCollectionBuilderFactory.class);
        this.bind(Logger.class).toInstance(this.logger);
    }

    private static class ClientCacheStoragePathProvider
    implements Provider<Path> {
        private final Path localPath;

        @Inject
        public ClientCacheStoragePathProvider(@Named(value="local-path") Path localPath) {
            this.localPath = Preconditions.checkNotNull(localPath);
        }

        @Override
        public Path get() {
            return this.localPath.resolve("hashCache");
        }
    }
}

