/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping;

import com.google.common.base.Optional;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.sosy_lab.verifiercloud.VerifierCloud;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.DefaultWebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.WebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping.AbstractWebClientResourceConfig;
import org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping.WebClientAPIModule;
import org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.DefaultWebAppReloader;
import org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.WebAppReloader;
import org.sosy_lab.verifiercloud.global.application.AbstractCloudModule;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;

@Singleton
public class WebClientResourceConfig
extends AbstractWebClientResourceConfig {
    protected static final WebAppReloader webAppReloader = new DefaultWebAppReloader();
    private Optional<DefaultWebClientAPI> webClientAPI = Optional.absent();

    public WebClientResourceConfig() {
    }

    public WebClientResourceConfig(DefaultWebClientAPI webClientAPI) {
        this.webClientAPI = Optional.of(webClientAPI);
    }

    @Override
    @PostConstruct
    public void initialize() throws ApplicationInitializationException {
        if (!this.isRegistered(webAppReloader)) {
            this.register(webAppReloader);
        }
        super.initialize();
    }

    @Override
    protected WebClientAPI getWebClientAPI() throws ApplicationInitializationException {
        WebClientAPIModule module = this.webClientAPI.isPresent() ? new WebClientAPIModule(VerifierCloud.getUserConfigurationPath(), webAppReloader, this.webClientAPI.get()) : new WebClientAPIModule(VerifierCloud.getUserConfigurationPath(), webAppReloader);
        ((AbstractCloudModule)module).initialize();
        Injector appInjector = Guice.createInjector(module);
        DefaultWebClientAPI webClientAPI = appInjector.getInstance(DefaultWebClientAPI.class);
        webClientAPI.initialize();
        this.webClientAPI = Optional.of(webClientAPI);
        return webClientAPI;
    }

    @PreDestroy
    public void cleanUp() throws IOException {
        if (this.webClientAPI.isPresent()) {
            this.webClientAPI.get().cleanUp();
        }
    }
}

