/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling;

import com.google.common.base.Optional;
import javax.inject.Singleton;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.DefaultWebClientAPI;
import org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping.AbstractWebClientResourceConfig;
import org.sosy_lab.verifiercloud.client.applications.webclient.bootstrapping.WebClientResourceConfig;
import org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.WebAppReloader;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;

@Singleton
public final class DefaultWebAppReloader
implements ContainerLifecycleListener,
WebAppReloader {
    private Optional<Container> container = Optional.absent();

    public void onStartup(Container container) {
        this.container = Optional.of(container);
    }

    public void onShutdown(Container container) {
        this.container = Optional.absent();
    }

    public void onReload(Container container) {
        this.container = Optional.of(container);
    }

    @Override
    public void reload(DefaultWebClientAPI webClientAPI) throws ApplicationInitializationException {
        if (this.container.isPresent()) {
            WebClientResourceConfig configuration = new WebClientResourceConfig(webClientAPI);
            ((AbstractWebClientResourceConfig)configuration).initialize();
            this.container.get().reload((ResourceConfig)configuration);
        } else {
            System.err.println("Can not reload the web application because the application container is not present");
        }
    }

    @Override
    public void reload() throws ApplicationInitializationException {
        if (this.container.isPresent()) {
            WebClientResourceConfig configuration = new WebClientResourceConfig();
            ((AbstractWebClientResourceConfig)configuration).initialize();
            this.container.get().reload((ResourceConfig)configuration);
        } else {
            System.err.println("Can not reload the web application because the application container is not present");
        }
    }
}

