/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.WebAppReloader;
import org.sosy_lab.verifiercloud.global.application.ApplicationInitializationException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.error_trigger.ErrorTriggerExecutor;

public class WebClientUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final ReloderRunnable reloderRunnable;
    private final ErrorTriggerExecutor errorTriggerExecutor;
    private final Logger logger;

    @Inject
    public WebClientUncaughtExceptionHandler(WebAppReloader webAppReloader, ErrorTriggerExecutor errorTriggerExecutor, Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
        this.errorTriggerExecutor = Preconditions.checkNotNull(errorTriggerExecutor);
        this.reloderRunnable = new ReloderRunnable(webAppReloader, logger);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.logger.logf(Level.SEVERE, e, "Uncaught exception %s  in thread %s: %s.", e.getClass().getSimpleName(), t, e.getMessage());
        this.errorTriggerExecutor.executeErrorTriggerForUncaughtException(t, e);
        Thread reloaderThread = new Thread((Runnable)this.reloderRunnable, WebClientUncaughtExceptionHandler.class.getSimpleName());
        reloaderThread.start();
    }

    private static class ReloderRunnable
    implements Runnable {
        private final WebAppReloader webAppReloader;
        private final Logger logger;

        public ReloderRunnable(WebAppReloader webAppReloader, Logger logger) {
            this.webAppReloader = Preconditions.checkNotNull(webAppReloader);
            this.logger = Preconditions.checkNotNull(logger);
        }

        @Override
        public void run() {
            this.logger.logf(Level.INFO, "Reloading application.", new Object[0]);
            try {
                this.webAppReloader.reload();
                this.logger.logf(Level.INFO, "Reloaded application.", new Object[0]);
            }
            catch (ApplicationInitializationException exception) {
                this.logger.logf(Level.SEVERE, exception, "Cannot reload web app: %s", exception.getMessage());
            }
        }
    }
}

