/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.mapping;

import com.google.common.base.Preconditions;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramNotAvailableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;

@Provider
public class ProgramNotAvailableExceptionMapper
implements ExceptionMapper<ProgramNotAvailableException> {
    private final Logger logger;

    @Inject
    public ProgramNotAvailableExceptionMapper(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    public Response toResponse(ProgramNotAvailableException e) {
        this.logger.logf(Level.WARNING, e, "Program is not available: %s", e.getMessage());
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type(MediaType.TEXT_PLAIN_TYPE).build();
    }
}

