/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.exception_handling.mapping;

import com.google.common.base.Preconditions;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.sosy_lab.verifiercloud.client.network.exceptions.RunSubmissionFailureException;
import org.sosy_lab.verifiercloud.global.logging.Logger;

@Provider
public class RunSubmissionFailureExceptionMapper
implements ExceptionMapper<RunSubmissionFailureException> {
    private final Logger logger;

    @Inject
    public RunSubmissionFailureExceptionMapper(Logger logger) {
        this.logger = Preconditions.checkNotNull(logger);
    }

    public Response toResponse(RunSubmissionFailureException e) {
        this.logger.logf(Level.WARNING, e, "Run submission failed: %s", e.getMessage());
        if (e.isRunResultStoringNotSupported()) {
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Vcloud does not support result storing.").type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Sever error:\n " + e.getMessage())).type(MediaType.TEXT_PLAIN_TYPE).build();
    }
}

