/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.git_handling;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.LineReader;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.CheckoutException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.ImmutableSvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutionException;

public class DefaultGitManager
implements GitManager {
    private final Path gitRepositoryPath;
    private Optional<Git> repositiory = Optional.absent();
    private final ProcessBuilder fetchCommand;
    private final boolean autoFetch;
    private final Logger logger;
    private final AtomicBoolean fetching = new AtomicBoolean(false);
    private final ExecutorService fetchingThread;

    @Inject
    public DefaultGitManager(@Named(value="gitRepository") Path gitRepositoryPath, @Named(value="gitFetchCommand") String fetchCommand, @Named(value="gitRepositoryAutoFetch") boolean autoFetch, @Named(value="local-path") Path localPath, Thread.UncaughtExceptionHandler exceptionHandler, Logger logger) {
        this.gitRepositoryPath = Preconditions.checkNotNull(gitRepositoryPath);
        this.autoFetch = autoFetch;
        this.logger = Preconditions.checkNotNull(logger);
        File fetchProcessLog = localPath.resolve("fetch.log").toFile();
        this.fetchCommand = new ProcessBuilder(fetchCommand.split(" ")).directory(gitRepositoryPath.toFile()).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.appendTo(fetchProcessLog));
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(DefaultGitManager.class.getSimpleName() + "-%d").setUncaughtExceptionHandler(exceptionHandler);
        this.fetchingThread = Executors.newCachedThreadPool(tfb.build());
    }

    @Override
    public synchronized void initilize() throws IOException, GitAPIException {
        Preconditions.checkState(!this.repositiory.isPresent());
        this.repositiory = Optional.of(Git.open((File)this.gitRepositoryPath.toFile()));
        this.logger.logf(Level.INFO, "Initialized git repository at %s", this.gitRepositoryPath);
        this.fetchingThread.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultGitManager.this.gitSvnFetch();
                    DefaultGitManager.this.logger.logf(Level.INFO, "Finished initial git svn fetch.", new Object[0]);
                }
                catch (IOException e) {
                    DefaultGitManager.this.logger.logf(Level.WARNING, "Can not fetch new revisions: %s", e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gitSvnFetch() throws IOException {
        if (this.fetching.getAndSet(true)) {
            return;
        }
        DefaultGitManager defaultGitManager = this;
        synchronized (defaultGitManager) {
            this.logger.logf(Level.FINER, "Fetching unfetched revisions.", new Object[0]);
            Process fetch = null;
            try {
                fetch = this.fetchCommand.start();
                int returnValue = fetch.waitFor();
                if (returnValue != 0) {
                    this.logger.logf(Level.WARNING, "git svn fetch returned %s", returnValue);
                }
            }
            catch (InterruptedException e) {
                this.logger.logf(Level.WARNING, "Interrupted while waiting for git svn fetch.", new Object[0]);
            }
            finally {
                if (fetch != null) {
                    fetch.destroy();
                }
                this.fetching.set(false);
            }
        }
    }

    private void autoFetchIfEnabled() throws IOException {
        if (this.autoFetch) {
            this.gitSvnFetch();
        }
    }

    @Override
    public synchronized void cleanUp() {
        Preconditions.checkState(this.repositiory.isPresent());
        this.repositiory.get().close();
        this.repositiory = Optional.absent();
        this.fetchingThread.shutdownNow();
    }

    @Override
    @SuppressFBWarnings(value={"IS"}, justification="Only initialisation state is checked.")
    public void fetchNewRevisions() {
        Preconditions.checkState(this.repositiory.isPresent());
        this.fetchingThread.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultGitManager.this.gitSvnFetch();
                }
                catch (IOException e) {
                    DefaultGitManager.this.logger.logf(Level.WARNING, "Can not fetch new revisions: %s", e.getMessage());
                }
            }
        });
    }

    @Override
    public synchronized Path checkOut(ImmutableSvnRevision revision) throws IOException, GitAPIException {
        Preconditions.checkState(this.repositiory.isPresent());
        this.logger.logf(Level.FINE, "Checking out %s.", revision);
        String startCommitHash = this.getStartCommitHash(revision);
        try {
            this.repositiory.get().reset().setRef(startCommitHash).setMode(ResetCommand.ResetType.HARD).call();
        }
        catch (JGitInternalException e) {
            throw new CheckoutException("Cannot check out: %s.", (Exception)((Object)e));
        }
        this.logger.logf(Level.FINER, "Checked out %s.", revision);
        return this.gitRepositoryPath;
    }

    private String getStartCommitHash(ImmutableSvnRevision revision) throws IOException, RefNotFoundException {
        this.checkRevisonExists(revision);
        String revisionString = "r" + revision.getRevisionNumber();
        ImmutableList<String> command = ImmutableList.of("git", "svn", "find-rev", "--before", revisionString, revision.getGitBranch());
        List<String> stdLines = this.startProcessAndReturnStdout(command);
        if (stdLines.isEmpty()) {
            throw new RefNotFoundException("No git hash found for " + revision + ".");
        }
        return stdLines.get(stdLines.size() - 1);
    }

    private void checkRevisonExists(ImmutableSvnRevision revision) throws RefNotFoundException, IOException {
        int lastRev = this.getLastRevisionNumber(revision);
        if (lastRev < revision.getRevisionNumber()) {
            throw new RefNotFoundException(revision + " does not exist. " + "Latest revision is " + lastRev + ".");
        }
    }

    @Override
    public int getCurrentRevision(SvnRevision revision) throws IOException, RefNotFoundException {
        this.autoFetchIfEnabled();
        return this.getLastRevisionNumber(revision);
    }

    private int getLastRevisionNumber(SvnRevision revision) throws IOException, RefNotFoundException {
        String branchOrTagPath = revision.getGitBranch();
        List<String> stdLines = this.startProcessAndReturnStdout(ImmutableList.of("git", "svn", "find-rev", revision.getGitBranch()));
        if (stdLines.isEmpty()) {
            throw new RefNotFoundException("No revision in " + branchOrTagPath + " found.");
        }
        int revisionNumber = Integer.parseInt(stdLines.get(stdLines.size() - 1));
        return revisionNumber;
    }

    private List<String> startProcessAndReturnStdout(List<String> command) throws IOException {
        String name = Joiner.on(" ").join(command);
        Process process = new ProcessBuilder(command).directory(this.gitRepositoryPath.toFile()).start();
        InputReader stderrReader = new InputReader(process.getErrorStream());
        Future<List<String>> stderr = this.fetchingThread.submit(stderrReader);
        InputReader stdoutReader = new InputReader(process.getInputStream());
        Future<List<String>> stdout = this.fetchingThread.submit(stdoutReader);
        try {
            int returnValue = process.waitFor();
            List<String> stdoutLines = stdout.get();
            if (returnValue != 0) {
                this.logOutput(name, process, stdoutLines, stderr.get());
            }
            List<String> list = stdoutLines;
            return list;
        }
        catch (InterruptedException e) {
            this.logger.logf(Level.SEVERE, "Interrupted while waiting for %s.", name);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.logger.logf(Level.SEVERE, "Failed to read ouput of subprocess %s.", name);
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new UncheckedExecutionException(cause);
        }
        finally {
            process.destroy();
        }
    }

    private void logOutput(String name, Process process, List<String> stdout, List<String> stderr) throws IOException {
        int returnValue = process.exitValue();
        ProcessExecutionException e = new ProcessExecutionException(returnValue);
        this.logger.logf(Level.SEVERE, e, "%s returned %s: \n%s\n%s", name, returnValue, stdout, stderr);
    }

    private static class InputReader
    implements Callable<List<String>> {
        private final InputStream source;

        public InputReader(InputStream source) {
            this.source = Preconditions.checkNotNull(source);
        }

        @Override
        public List<String> call() throws Exception {
            String nextLine;
            ArrayList<String> output = Lists.newArrayList();
            InputStreamReader streamReader = new InputStreamReader(this.source, Charsets.UTF_8);
            LineReader reader = new LineReader(streamReader);
            while ((nextLine = reader.readLine()) != null) {
                output.add(nextLine);
            }
            return output;
        }
    }
}

