/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.info;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutionException;
import org.sosy_lab.verifiercloud.client.applications.infoclient.formatting.HTMLOutputFormatter;
import org.sosy_lab.verifiercloud.client.applications.webclient.info.MasterInformationProvider;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.system.cache.InstanceProvider;
import org.sosy_lab.verifiercloud.global.util.system.cache.OneValueCache;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class CachingMasterInformationProvider
implements MasterInformationProvider {
    private final MasterConnection masterConnection;
    private final Logger logger;
    private final String masterHostname;
    private final Optional<TimeInterval> infoPageRefreshInterval;
    private final OneValueCache<String, MasterSummaryNotRetrievableException> pageCache;

    @Inject
    public CachingMasterInformationProvider(MasterConnection masterConnection, Logger logger, @Named(value="connectionBuilderHost") String masterHostname, @Named(value="masterInfoRefreshInterval") TimeInterval infoPageRefreshInterval) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.logger = Preconditions.checkNotNull(logger);
        this.masterHostname = Preconditions.checkNotNull(masterHostname);
        this.infoPageRefreshInterval = Optional.of(infoPageRefreshInterval);
        this.pageCache = new OneValueCache<String, MasterSummaryNotRetrievableException>(infoPageRefreshInterval, new InfoPageProvider());
    }

    @Override
    public String getMasterInfoAsHtml() throws MasterSummaryNotRetrievableException {
        return this.pageCache.get();
    }

    private final class InfoPageProvider
    implements InstanceProvider<String, MasterSummaryNotRetrievableException> {
        private InfoPageProvider() {
        }

        @Override
        public String getInstance() throws MasterSummaryNotRetrievableException {
            MasterSummary masterSummary;
            try {
                masterSummary = (MasterSummary)CachingMasterInformationProvider.this.masterConnection.getMasterSummary().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new MasterSummaryNotRetrievableException(e.getMessage());
            }
            HTMLOutputFormatter formatter = new HTMLOutputFormatter(CachingMasterInformationProvider.this.masterHostname, CachingMasterInformationProvider.this.infoPageRefreshInterval, CachingMasterInformationProvider.this.logger);
            return formatter.generateOutput(masterSummary);
        }
    }
}

