/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.model;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriInfo;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.RunState;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.ModelGenerator;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state.RunStates;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.AbstractRunConfiguration;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.form_format.FormArgumentFilesBean;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevisionPattern;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.beans.AbstractSvnRevisionBean;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class DefaultModelGenerator
implements ModelGenerator {
    private final RunStates runStates;
    private final ImmutableMap<String, Limitations> preDefinedLimitations;
    private final Map<String, Object> config;
    private final ImmutableSet<String> submitOptions;
    private final Optional<URI> basePath;
    private final Optional<URI> staticContentBasePath;

    @Inject
    public DefaultModelGenerator(RunStates runStates, @Named(value="coresRequirementLimitation") int maxCoreLimitation, @Named(value="memoryRequirementLimitation") MemoryUnit maxMemoryLimitation, @Named(value="timeLimitation") TimeInterval maxTimeLimitation, @Named(value="preDefinedLimitations") ImmutableMap<String, Limitations> preDefinedLimitations, @Named(value="configAndSpecPattern") String configAndSpecPattern, @Named(value="allowedRevisionsAndBranches") ImmutableSet<SvnRevisionPattern> allowedRevisions, @Named(value="url") Optional<URI> basePath, @Named(value="staticContentUrl") Optional<URI> staticContentBasePath) {
        this.runStates = Preconditions.checkNotNull(runStates);
        this.preDefinedLimitations = Preconditions.checkNotNull(preDefinedLimitations);
        this.config = DefaultModelGenerator.createConfig(maxCoreLimitation, Preconditions.checkNotNull(maxMemoryLimitation), Preconditions.checkNotNull(maxTimeLimitation), (Map<String, Limitations>)Preconditions.checkNotNull(preDefinedLimitations), Pattern.compile(Preconditions.checkNotNull(configAndSpecPattern)), (Set<SvnRevisionPattern>)Preconditions.checkNotNull(allowedRevisions));
        this.submitOptions = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(FormArgumentFilesBean.getOptionsDescription())).addAll(AbstractRunConfiguration.getOptionsDescription())).build();
        this.basePath = Preconditions.checkNotNull(basePath);
        this.staticContentBasePath = Preconditions.checkNotNull(staticContentBasePath);
    }

    private static Map<String, Object> createConfig(int maxCoreLimitation, MemoryUnit maxMemoryLimitation, TimeInterval maxTimeLimitation, Map<String, Limitations> preDefinedLimitations, Pattern configAndSpecPattern, Set<SvnRevisionPattern> allowedRevisions) {
        return ImmutableMap.builder().put("Maximum core limitation", maxCoreLimitation).put("Maximum memory limitation", (Integer)((Object)maxMemoryLimitation)).put("Maximum time limitation", (Integer)((Object)maxTimeLimitation)).put("Pre defined limitations", (Integer)((Object)preDefinedLimitations)).put("Usable configurations and specifications", (Map<String, Limitations>)((Object)configAndSpecPattern)).put("Allowed svn revisions", (Map<String, Limitations>)((Object)allowedRevisions)).build();
    }

    @Override
    public Map<String, Object> getRunsModel(UriInfo request) {
        Limitations defaultLimits = (Limitations)((ImmutableCollection)this.preDefinedLimitations.values()).asList().get(0);
        ImmutableMap<String, Integer> defaultLimitsMapping = ImmutableMap.of("time", defaultLimits.getTimeLimit(), "memory", defaultLimits.getMemoryLimit().or(MemoryUnit.gigabyte(1L)), "cores", defaultLimits.getProcessorLimit().or(1));
        return this.getPathModel(request).put("defaultLimit", defaultLimitsMapping).build();
    }

    @Override
    public Map<String, Object> getRunStateModel(UriInfo request, UUID runID) throws MasterSummaryNotRetrievableException {
        RunState state = this.runStates.getRunState(runID);
        ImmutableMap<String, RunState> runMapping = ImmutableMap.of("id", runID, "state", state);
        return this.getPathModel(request).put("run", runMapping).build();
    }

    @Override
    public Map<String, Object> getHelpModel(UriInfo request) {
        ImmutableMap<String, Map<String, Object>> helpMapping = ImmutableMap.of("submitOptions", this.submitOptions, "toolDownloadOptions", AbstractSvnRevisionBean.getOptionsDescription(), "runStates", RunState.values(), "configuration", this.config);
        return this.getPathModel(request).put("help", helpMapping).build();
    }

    private ImmutableMap.Builder<String, Object> getPathModel(UriInfo request) {
        URI staticContentPath;
        URI webclientPath;
        if (this.basePath.isPresent() && this.staticContentBasePath.isPresent()) {
            webclientPath = this.basePath.get();
            staticContentPath = this.staticContentBasePath.get();
        } else {
            URI basePath = request.getBaseUri();
            staticContentPath = basePath.resolve("assets/");
            webclientPath = basePath.resolve("webclient/");
        }
        URI runsPath = webclientPath.resolve("runs/");
        URI helpPath = webclientPath.resolve("help/");
        URI masterSummary = webclientPath.resolve("master/info");
        URI tool = webclientPath.resolve("tool/");
        ImmutableMap<String, URI> paths = ImmutableMap.builder().put("runs", runsPath).put("help", helpPath).put("webclient", webclientPath).put("staticContent", staticContentPath).put("masterSummary", masterSummary).put("tool", tool).build();
        return ImmutableMap.builder().put("paths", paths);
    }
}

