/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.RunState;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state.RunStatesProvider;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.transportable.info.master.MasterSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.RunCollectionSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.SchedulerSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;

public class DefaultRunStatesProvider
implements RunStatesProvider {
    private final MasterConnection masterConnection;
    private final Map<UUID, String> runToRunCollectionMapping = new ConcurrentHashMap<UUID, String>();

    @Inject
    public DefaultRunStatesProvider(MasterConnection masterConnection) {
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
    }

    @Override
    public void addKnownRun(UUID runId, String runCollectionId) {
        String oldVlaue = this.runToRunCollectionMapping.put(runId, runCollectionId);
        Preconditions.checkArgument(oldVlaue == null);
    }

    @Override
    public void removeKnownRuns(Set<UUID> newFinishedRuns) {
        for (UUID run : newFinishedRuns) {
            this.runToRunCollectionMapping.remove(run);
        }
    }

    @Override
    public void removeKnownRun(UUID runId) {
        this.runToRunCollectionMapping.remove(runId);
    }

    @Override
    public Map<UUID, String> getRunToRunCollectionMapping() {
        return this.runToRunCollectionMapping;
    }

    @Override
    public Map<UUID, RunState> getInstance() throws MasterSummaryNotRetrievableException {
        return this.getRunStates();
    }

    private Map<UUID, RunState> getRunStates() throws MasterSummaryNotRetrievableException {
        HashMap<UUID, RunState> runStates = Maps.newHashMap();
        MasterSummary masterSummary = this.masterConnection.getMasterSummary().checkedGet();
        ImmutableList<WorkerSummary> workerSummaries = masterSummary.getWorkerSummaries();
        Map<String, Integer> activeRuns = this.getNumberOfActiveRuns(workerSummaries);
        SchedulerSummary schedulerSummary = masterSummary.getSchedulerSummary();
        Map<String, Integer> finishedRuns = this.getNumberOfFinishedRuns(schedulerSummary);
        for (Map.Entry<UUID, String> entry : this.runToRunCollectionMapping.entrySet()) {
            String runCollectionId = entry.getValue();
            UUID runId = entry.getKey();
            RunState runState = this.getRunState(runCollectionId, runId, activeRuns, finishedRuns);
            runStates.put(runId, runState);
        }
        return runStates;
    }

    private RunState getRunState(String runCollectionId, UUID runId, Map<String, Integer> activeRuns, Map<String, Integer> finishedRuns) {
        if (activeRuns.containsKey(runCollectionId) && activeRuns.get(runCollectionId) > 0) {
            return RunState.PROCESSING;
        }
        if (finishedRuns.containsKey(runCollectionId)) {
            int numFinishedRuns = finishedRuns.get(runCollectionId);
            if (numFinishedRuns == 0) {
                return RunState.PENDING;
            }
            if (numFinishedRuns == 1) {
                return RunState.FINISHED;
            }
        }
        return RunState.FINISHED;
    }

    private Map<String, Integer> getNumberOfFinishedRuns(SchedulerSummary schedulerSummary) {
        HashMap<String, Integer> finishedRuns = Maps.newHashMap();
        for (RunCollectionSummary summary : schedulerSummary.getRunCollections()) {
            String id = summary.getId();
            int numberOfFinishedRuns = summary.getNumberOfFinishedRuns();
            finishedRuns.put(id, numberOfFinishedRuns);
        }
        return finishedRuns;
    }

    private Map<String, Integer> getNumberOfActiveRuns(ImmutableList<WorkerSummary> workerSummaries) {
        HashMap<String, Integer> activeRuns = Maps.newHashMap();
        for (WorkerSummary workerSummary : workerSummaries) {
            for (WorkerPartitionInformation partition : workerSummary.getExecutorState().getPartitions()) {
                String runCollectionId = partition.getRunCollectionId();
                if (activeRuns.containsKey(runCollectionId)) {
                    Integer oldValue = (Integer)activeRuns.get(runCollectionId);
                    activeRuns.put(runCollectionId, oldValue + 1);
                    continue;
                }
                activeRuns.put(runCollectionId, 1);
            }
        }
        return activeRuns;
    }
}

