/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.sosy_lab.verifiercloud.client.applications.webclient.api.RunState;
import org.sosy_lab.verifiercloud.client.applications.webclient.model.run_state.RunStatesProvider;
import org.sosy_lab.verifiercloud.client.network.exceptions.MasterSummaryNotRetrievableException;
import org.sosy_lab.verifiercloud.global.util.system.cache.OneValueCache;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class RunStates {
    public static final String KNOWN_RUNS = "knownRuns";
    public static final String KNOWN_FINISHED_RUNS = "knownFinishedRuns";
    private final RunStatesCache cache;
    private final Set<UUID> finishedRuns;

    @Inject
    public RunStates(@Named(value="runStatesCacheValidity") TimeInterval cacheValidity, RunStatesProvider provider, @Named(value="knownRuns") Map<UUID, String> initialKnownRuns, @Named(value="knownFinishedRuns") Set<UUID> initialKnownFinishedRuns) {
        this.cache = new RunStatesCache(cacheValidity, provider);
        this.finishedRuns = Sets.newConcurrentHashSet(initialKnownFinishedRuns);
        for (Map.Entry<UUID, String> initialKnownRun : initialKnownRuns.entrySet()) {
            this.cache.addKnownRun(initialKnownRun.getKey(), initialKnownRun.getValue());
        }
    }

    public void addKnownRun(UUID runId, String runCollectionId) {
        this.cache.addKnownRun(runId, runCollectionId);
    }

    public Map<UUID, String> getKnownRuns() {
        return this.cache.getKnownRuns();
    }

    public Set<UUID> getKnownFinishedRuns() {
        return ImmutableSet.copyOf(this.finishedRuns);
    }

    public void removeKnownRun(UUID runId) {
        this.cache.removeKnownRun(runId);
        this.finishedRuns.remove(runId);
    }

    public RunState getRunState(UUID runId) throws MasterSummaryNotRetrievableException {
        if (this.finishedRuns.contains(runId)) {
            return RunState.FINISHED;
        }
        Map runStates = (Map)this.cache.get();
        RunState runState = (RunState)((Object)runStates.get(runId));
        if (runState != null) {
            return runState;
        }
        return RunState.UNKNOWN;
    }

    private class RunStatesCache
    extends OneValueCache<Map<UUID, RunState>, MasterSummaryNotRetrievableException> {
        private final RunStatesProvider provider;

        public RunStatesCache(TimeInterval cacheValidity, RunStatesProvider provider) {
            super(cacheValidity, provider);
            this.provider = Preconditions.checkNotNull(provider);
        }

        @Override
        protected void valueChanged(Map<UUID, RunState> newValue) {
            Set<UUID> newFinishedRuns = Maps.filterValues(newValue, Predicates.equalTo(RunState.FINISHED)).keySet();
            RunStates.this.finishedRuns.addAll(newFinishedRuns);
            this.provider.removeKnownRuns(newFinishedRuns);
        }

        public void addKnownRun(UUID runId, String runCollectionId) {
            this.provider.addKnownRun(runId, runCollectionId);
            this.invalidate();
        }

        public Map<UUID, String> getKnownRuns() {
            return this.provider.getRunToRunCollectionMapping();
        }

        public void removeKnownRun(UUID runId) {
            this.provider.removeKnownRun(runId);
        }
    }
}

