/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.client.applications.webclient.program_files;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.sosy_lab.verifiercloud.client.applications.webclient.git_handling.GitManager;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramFilesProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramNotAvailableException;
import org.sosy_lab.verifiercloud.client.applications.webclient.program_files.ProgramProvider;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.ImmutableSvnRevision;
import org.sosy_lab.verifiercloud.client.applications.webclient.run_infomation.svn_revision.SvnRevision;
import org.sosy_lab.verifiercloud.client.files.ClientFileStorage;
import org.sosy_lab.verifiercloud.client.network.MasterConnection;
import org.sosy_lab.verifiercloud.client.run_builders.RunCollectionCreationException;
import org.sosy_lab.verifiercloud.global.file_storage.FileUnknownException;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeFileHierarchyBuilder;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class CachingProgramProvider
implements ProgramProvider {
    private final ProgramFilesProvider programFilesProvider;
    private final ClientFileStorage clientFileStorage;
    private final MasterConnection masterConnection;
    private final GitManager gitManager;
    private final Logger logger;
    private final LoadingCache<ImmutableSvnRevision, HashCode> cache;

    @Inject
    public CachingProgramProvider(ProgramFilesProvider programFilesProvider, ClientFileStorage clientFileStorage, MasterConnection masterConnection, GitManager gitManager, Logger logger) {
        this.programFilesProvider = Preconditions.checkNotNull(programFilesProvider);
        this.clientFileStorage = Preconditions.checkNotNull(clientFileStorage);
        this.masterConnection = Preconditions.checkNotNull(masterConnection);
        this.gitManager = Preconditions.checkNotNull(gitManager);
        this.logger = Preconditions.checkNotNull(logger);
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<ImmutableSvnRevision, HashCode>(){

            @Override
            public HashCode load(ImmutableSvnRevision revision) throws Exception {
                return CachingProgramProvider.this.createAndStoreProgramZipFile(revision);
            }
        });
    }

    private HashCode createAndStoreProgramZipFile(ImmutableSvnRevision revision) throws IOException, InterruptedException, ExecutionException, RunCollectionCreationException, RefNotFoundException {
        this.logger.logf(Level.FINER, "Creating program for revision %s.", revision);
        FileHierarchy programFiles = this.getProgramFiles(revision);
        Path tmpDir = Files.createTempDirectory("vcloud-webclient", new FileAttribute[0]);
        Path zipFilePath = tmpDir.resolve("program.zip");
        this.logger.logf(Level.FINE, "Compressing program (%s).", revision);
        URI uri = URI.create("jar:file:" + zipFilePath.toUri().getPath());
        HashMap<String, String> env = Maps.newHashMap();
        env.put("create", "true");
        try (FileSystem zipFile = FileSystems.newFileSystem(uri, env);){
            for (FileAtRelativePath programFile : programFiles) {
                FileContent fileContent = this.getFileContent(programFile.getFileHash());
                this.writeToFileSystem(zipFile, programFile, fileContent);
            }
        }
        HashCode programZipHash = this.clientFileStorage.pushFile(zipFilePath);
        FileUtils.deleteDirectory(tmpDir, this.logger);
        return programZipHash;
    }

    private FileHierarchy getProgramFiles(SvnRevision revision) throws RunCollectionCreationException, RefNotFoundException {
        TreeFileHierarchyBuilder programFilesBuilder = this.programFilesProvider.getProgramFiles(revision);
        return programFilesBuilder.build();
    }

    private void writeToFileSystem(FileSystem zipFile, FileAtRelativePath programFile, FileContent fileContent) throws IOException {
        Path filePath = zipFile.getPath(programFile.getRelativePathString(), new String[0]);
        Path parent = filePath.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        fileContent.writeToPath(filePath);
    }

    private FileContent getFileContent(HashCode fileHash) throws InterruptedException, ExecutionException {
        try {
            if (this.clientFileStorage.isFileKnown(fileHash)) {
                return this.clientFileStorage.getFile(fileHash);
            }
        }
        catch (FileUnknownException fileUnknownException) {
            // empty catch block
        }
        return (FileContent)this.masterConnection.getResultFile(fileHash).get();
    }

    @Override
    public FileContent getProgramAsZip(SvnRevision revision) throws ProgramNotAvailableException, RefNotFoundException {
        this.logger.logf(Level.FINER, "Getting program for revision %s.", revision);
        try {
            ImmutableSvnRevision currentRevision = revision.getCurrentRevision(this.gitManager);
            HashCode fileHash = this.cache.get(currentRevision);
            return this.clientFileStorage.getFile(fileHash);
        }
        catch (IOException | FileUnknownException e) {
            throw new ProgramNotAvailableException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause(e);
            if (cause instanceof RefNotFoundException) {
                throw (RefNotFoundException)cause;
            }
            throw new ProgramNotAvailableException(e);
        }
    }
}

